/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.CaseInsensitiveNameSpace;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.AbstractModuleNameContext;
import org.eclipse.birt.report.model.css.CssNameManager;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class StyleNameContext
extends AbstractModuleNameContext {
    private Map<String, StyleElement> cachedStyles = null;
    private Map<String, StyleElement> cachedTOCStyles = null;

    StyleNameContext(Module module) {
        super(module, "style");
    }

    @Override
    protected void initNameSpace() {
        this.namespace = new CaseInsensitiveNameSpace();
    }

    @Override
    public List<DesignElement> getElements(int level) {
        Theme theme = this.module.getTheme(this.module);
        LinkedHashMap<String, StyleElement> elements = new LinkedHashMap<String, StyleElement>();
        if (theme == null && this.module instanceof Library) {
            return Collections.emptyList();
        }
        if (theme != null) {
            List<StyleElement> tmpStyles = theme.getAllStyles();
            elements.putAll(this.addAllStyles(tmpStyles));
        }
        if (this.module instanceof Library) {
            return new ArrayList<DesignElement>(elements.values());
        }
        List<CssStyle> csses = CssNameManager.getStyles((ICssStyleSheetOperation)((Object)this.module));
        elements.putAll(this.addAllStyles(csses));
        NameSpace ns = this.module.getNameHelper().getNameSpace(this.nameSpaceID);
        List<DesignElement> styles = ns.getElements();
        elements.putAll(this.addAllStyles(styles));
        return new ArrayList<DesignElement>(elements.values());
    }

    private ElementRefValue resolve(DesignElement element) {
        return new ElementRefValue(null, element);
    }

    private ElementRefValue resolve(String elementName) {
        Style tmpStyle;
        String name;
        String string = name = elementName == null ? null : elementName.toLowerCase();
        if (this.module.isCached()) {
            DesignElement style = this.cachedStyles.get(name);
            if (style != null) {
                return new ElementRefValue(null, style);
            }
            style = this.cachedTOCStyles.get(name);
            if (style != null) {
                return new ElementRefValue(null, style);
            }
            return new ElementRefValue(null, elementName);
        }
        Theme theme = this.module.getTheme(this.module);
        if (theme == null && this.module instanceof Library) {
            return new ElementRefValue(null, elementName);
        }
        DesignElement target = null;
        if (this.module instanceof ReportDesign) {
            NameSpace ns = this.module.getNameHelper().getNameSpace(this.nameSpaceID);
            target = ns.getElement(name);
            if (target != null) {
                return new ElementRefValue(null, target);
            }
            List<CssStyle> csses = CssNameManager.getStyles((ICssStyleSheetOperation)((Object)this.module));
            int i = 0;
            while (csses != null && i < csses.size()) {
                CssStyle s = csses.get(i);
                if (name.equalsIgnoreCase(s.getFullName())) {
                    return new ElementRefValue(null, s);
                }
                ++i;
            }
        }
        StyleElement libraryStyle = null;
        if (theme != null) {
            libraryStyle = theme.findStyle(name);
        }
        if (libraryStyle != null) {
            return new ElementRefValue(null, libraryStyle);
        }
        this.buildTOCStyles();
        if (this.cachedTOCStyles != null && (tmpStyle = (Style)this.cachedTOCStyles.get(name)) != null) {
            return new ElementRefValue(null, tmpStyle);
        }
        return new ElementRefValue(null, elementName);
    }

    @Override
    public ElementRefValue resolve(DesignElement focus, DesignElement element, PropertyDefn propDefn, ElementDefn elementDefn) {
        return this.resolve(element);
    }

    @Override
    public ElementRefValue resolve(DesignElement focus, String elementName, PropertyDefn propDefn, ElementDefn elementDefn) {
        return this.resolve(elementName);
    }

    @Override
    public DesignElement findElement(String elementName, IElementDefn elementDefn) {
        ElementRefValue refValue = this.resolve(elementName);
        return refValue == null ? null : refValue.getElement();
    }

    @Override
    public void cacheValues() {
        this.cachedStyles = this.addAllStyles(this.getElements(Integer.MAX_VALUE));
        this.buildTOCStyles();
    }

    private void buildTOCStyles() {
        if (this.cachedTOCStyles == null) {
            List<DesignElement> defaultTocStyle = this.module.getSession().getDefaultTOCStyleValue();
            this.cachedTOCStyles = this.addAllStyles(defaultTocStyle);
        }
    }

    private Map<String, StyleElement> addAllStyles(List<? extends DesignElement> styleList) {
        LinkedHashMap<String, StyleElement> tmpMap = new LinkedHashMap<String, StyleElement>();
        if (styleList != null) {
            int i = 0;
            while (i < styleList.size()) {
                DesignElement style = styleList.get(i);
                tmpMap.put(style.getName().toLowerCase(), (StyleElement)style);
                ++i;
            }
        }
        return tmpMap;
    }
}

