/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.TextualPropertyType;

public class NamePropertyType
extends TextualPropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.name";

    public NamePropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    @Override
    public int getTypeCode() {
        return 13;
    }

    @Override
    public String getName() {
        return "name";
    }

    @Override
    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (defn != null);
        if (value == null) {
            if (defn.isStructureMember()) {
                throw new PropertyValueException(null, "Error.PropertyValueException.VALUE_REQUIRED", 13);
            }
            return null;
        }
        if (value instanceof String) {
            String stringValue = this.trimString((String)value, defn.getTrimOption());
            if (stringValue == null) {
                if (defn.isStructureMember()) {
                    throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 13);
                }
                return null;
            }
            if (!NamePropertyType.isValidName(stringValue)) {
                throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 13);
            }
            return stringValue;
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 13);
    }

    @Override
    public Object validateXml(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if (tmpValue == null) {
            return null;
        }
        return this.trimString(tmpValue, defn.getTrimOption());
    }

    public static boolean isValidName(String value) {
        if (value == null) {
            return true;
        }
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '/' || c == '\\' || c == '.' || c == '!' || c == ';' || c == ',') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String validateName(String name) {
        if (name == null) {
            return null;
        }
        String value = StringUtil.trimString(name);
        if (value == null) {
            return null;
        }
        value = value.replaceAll("/|\\\\|\\.|!|;|,", "_");
        return value;
    }
}

