/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.tray.TrayEditPart;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class TrayContainerEditPart
extends TrayEditPart {
    protected TrayContainerFigure mainFigure;

    protected IFigure createFigure() {
        this.mainFigure = this.createMainFigure();
        this.mainFigure.setTitleFigure(this.createTitleFigure());
        this.mainFigure.setChildrenFigure(this.createChildrenFigure());
        return this.mainFigure;
    }

    protected TrayContainerFigure createMainFigure() {
        return new TrayContainerFigure();
    }

    protected IFigure createTitleFigure() {
        return new Figure();
    }

    protected IFigure createChildrenFigure() {
        Figure result = new Figure();
        result.setLayoutManager((LayoutManager)new ToolbarLayout());
        return result;
    }

    protected EditPart selectEditPart(Object model) {
        EditPart editPart = (EditPart)this.getViewer().getEditPartRegistry().get(model);
        if (editPart != null) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)editPart));
        }
        return editPart;
    }

    protected CommandStack getCommandStack() {
        return this.getViewer().getEditDomain().getCommandStack();
    }

    public IFigure getTitleFigure() {
        return this.mainFigure.getTitleFigure();
    }

    public IFigure getContentPane() {
        return this.mainFigure.getChildrenFigure();
    }

    protected class TrayContainerFigure
    extends Figure {
        protected IFigure titleFigure;
        protected IFigure childrenFigure;

        public TrayContainerFigure() {
            this.setLayoutManager((LayoutManager)new ToolbarLayout());
            this.setOpaque(true);
            this.setBackgroundColor(CommonUIPlugin.getDefault().getColorRegistry().get("trayBackground"));
        }

        public IFigure getChildrenFigure() {
            return this.childrenFigure;
        }

        public void setChildrenFigure(IFigure target) {
            if (this.childrenFigure != null) {
                this.remove(this.childrenFigure);
            }
            this.childrenFigure = target;
            this.add(target);
        }

        public IFigure getTitleFigure() {
            return this.titleFigure;
        }

        public void setTitleFigure(IFigure target) {
            if (this.titleFigure != null) {
                this.remove(this.titleFigure);
            }
            this.titleFigure = target;
            this.add(target);
        }
    }
}

