/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.ArrayList;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;

public class SetConstraintCommand
extends AutoUndoCommand {
    private Point newPos;
    private Dimension newSize;
    private Dimension oldSize;
    private Activity activity;

    public SetConstraintCommand(Activity activity, Point location, Dimension size) {
        super(new ArrayList<Object>());
        this.activity = activity;
        this.newPos = location;
        this.newSize = size;
        this.addModelRoot(activity);
    }

    @Override
    public void doExecute() {
        this.addModelRoot(ModelHelper.getExtension((EObject)this.activity));
        if (this.newSize != null) {
            this.oldSize = ModelHelper.getSize(this.activity);
        }
        if (this.newPos != null) {
            ModelHelper.setLocation(this.activity, this.newPos);
        }
        if (this.newSize != null) {
            ModelHelper.setSize(this.activity, this.newSize);
        }
    }

    public String getLabel() {
        if (this.newSize == null || this.newSize.equals((Object)this.oldSize)) {
            return IBPELUIConstants.CMD_REPOSITION_NODE;
        }
        return IBPELUIConstants.CMD_RESIZE_NODE;
    }
}

