/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class ScopeValidator
extends CActivityValidator {
    protected String fExitStandardFault;
    protected String fIsolated;
    protected List<INode> fActivities;
    private int fCompensationHandlerCount = 0;
    protected int fFaultHandlersCount = 0;

    @Override
    protected void start() {
        super.start();
    }

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_PARTNER_LINKS, 0, 1);
        this.checkChild(ND_MESSAGE_EXCHANGES, 0, 1);
        this.checkChild(ND_VARIABLES, 0, 1);
        this.checkChild(ND_CORRELATION_SETS, 0, 1);
        this.fFaultHandlersCount = this.checkChild(ND_FAULT_HANDLERS, 0, 1);
        this.fCompensationHandlerCount = this.checkChild(ND_COMPENSATION_HANDLER, 0, 1);
        this.checkChild(ND_EVENT_HANDLERS, 0, 1);
        this.checkChild(Filters.ACTIVITIES, 1, 1);
        this.setValue(ND_COMPENSATION_HANDLER + ".count", this.fCompensationHandlerCount);
        this.setValue(ND_FAULT_HANDLERS + ".count", this.fFaultHandlersCount);
    }

    @ARule(sa=0, desc="Check isolated attribute setting on scope", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckIsolatedAttribute_10() {
        this.fIsolated = this.getAttribute(this.mNode, AT_ISOLATED, 1, Filters.BOOLEAN_FILTER, false);
        if (ScopeValidator.isEmpty(this.fIsolated)) {
            this.fIsolated = "no";
        }
        this.setValue(AT_ISOLATED, this.fIsolated);
    }

    @ARule(sa=0, desc="Check exitOnStandardFault attribute setting", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckExitOnStandardFault_10() {
        this.fExitStandardFault = this.getAttribute(this.mNode, AT_EXIT_ON_STANDARD_FAULT, 0, Filters.BOOLEAN_FILTER, false);
        if (ScopeValidator.isEmpty(this.fExitStandardFault)) {
            INode scope = mSelector.selectParent(this.fParentNode, Filters.SCOPE_OR_PROCESS);
            while (scope != null && ScopeValidator.isEmpty(this.fExitStandardFault)) {
                this.fExitStandardFault = this.getValue(scope, AT_EXIT_ON_STANDARD_FAULT, null);
                scope = mSelector.selectParent(scope.parentNode(), Filters.SCOPE_OR_PROCESS);
            }
        }
        this.setValue(AT_EXIT_ON_STANDARD_FAULT, this.fExitStandardFault);
    }

    @ARule(sa=91, desc="Isolated scopes may not contain other isolated scopes", author="michal.chmielewski@oracle.com", date="01/24/2007", errors="BPELC_SCOPE__ISOLATED")
    public void rule_CheckNoIsolatedScopeDescendants_20() {
        if ("no".equals(this.fIsolated)) {
            return;
        }
        INode node = mSelector.selectParent(this.fParentNode, Filters.SCOPE);
        while (node != null) {
            String isolated = this.getValue(node, AT_ISOLATED, "no");
            if ("yes".equals(isolated)) {
                IProblem problem = this.createError(this.mNode);
                problem.fill("BPELC_SCOPE__ISOLATED", this.toString(this.mNode.nodeName()), this.ncName, this.toString(node.nodeName()), node.getAttribute(AT_NAME));
            }
            node = mSelector.selectParent(node.parentNode(), Filters.SCOPE);
        }
    }

    @ARule(sa=92, desc="Within a scope all immediately enclosed scopes must have unique name", author="michal.chmielewski@oracle.com", date="01/24/2007", errors="BPELC_SCOPE__UNIQUE_NAME")
    public void rule_CheckUniqueScopeNames_20() {
        INode scope = mSelector.selectParent(this.fParentNode, Filters.SCOPE_OR_PROCESS);
        if (this.isUndefined(scope)) {
            return;
        }
        String key = "immediate.scope.name." + this.ncName;
        INode aNode = this.getValue(scope, key, null);
        if (aNode == null) {
            this.setValue(scope, key, this.mNode);
        } else if (aNode != this.mNode) {
            IProblem problem = this.createError(this.mNode);
            problem.fill("BPELC_SCOPE__UNIQUE_NAME", this.toString(this.mNode.nodeName()), this.ncName, this.toString(scope.nodeName()), scope.getAttribute(AT_NAME));
        }
    }

    @ARule(sa=79, desc="Root scope inside an FCT-handler MUST not have a compensation handler", author="michal.chmielewski@oracle.com", date="02/28/2007", errors="BPELC_SCOPE__COMPENSATION_HANDLER")
    public void rule_CheckRootFCTScope_25() {
        INode node = mSelector.selectParent(this.mNode, Filters.FCT_HANDLER);
        if (!this.mModelQuery.check(0, node, this.fParentNode)) {
            return;
        }
        if (this.fCompensationHandlerCount > 0) {
            IProblem problem = this.createError();
            problem.fill("BPELC_SCOPE__COMPENSATION_HANDLER", this.toString(this.mNode.nodeName()), this.ncName, this.toString(node.nodeName()));
        }
    }
}

