/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.launch;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.AbstractLaunchConfigProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;

public class CoreBuildGenericLaunchConfigProvider
extends AbstractLaunchConfigProvider {
    private static final String ATTR_OS = "org.eclipse.cdt.debug.core.target_os";
    private static final String ATTR_ARCH = "org.eclipse.cdt.debug.core.target_arch";
    private static final String EMPTY = "";
    private Map<IProject, Map<String, ILaunchConfiguration>> configs = new HashMap<IProject, Map<String, ILaunchConfiguration>>();

    public boolean supports(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        return target.getTypeId().equals("org.eclipse.cdt.launchTargetType.generic");
    }

    public ILaunchConfigurationType getLaunchConfigurationType(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.debug.core.genericLaunchConfigType");
    }

    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        ILaunchConfiguration config = null;
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project != null) {
            Map<String, ILaunchConfiguration> projectConfigs = this.configs.get(project);
            if (projectConfigs == null) {
                projectConfigs = new HashMap<String, ILaunchConfiguration>();
                this.configs.put(project, projectConfigs);
            }
            String os = target.getAttribute("os", EMPTY);
            String arch = target.getAttribute("arch", EMPTY);
            String targetConfig = String.valueOf(os) + '.' + arch;
            config = projectConfigs.get(targetConfig);
            if (config == null) {
                config = this.createLaunchConfiguration(descriptor, target);
            }
        }
        return config;
    }

    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        super.populateLaunchConfiguration(descriptor, target, workingCopy);
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        workingCopy.setMappedResources(new IResource[]{project});
        String os = target.getAttribute("os", EMPTY);
        workingCopy.setAttribute(ATTR_OS, os);
        String arch = target.getAttribute("arch", EMPTY);
        workingCopy.setAttribute(ATTR_ARCH, arch);
    }

    public boolean launchConfigurationAdded(ILaunchConfiguration configuration) throws CoreException {
        if (this.ownsLaunchConfiguration(configuration)) {
            IProject project = configuration.getMappedResources()[0].getProject();
            Map<String, ILaunchConfiguration> projectConfigs = this.configs.get(project);
            if (projectConfigs == null) {
                projectConfigs = new HashMap<String, ILaunchConfiguration>();
                this.configs.put(project, projectConfigs);
            }
            String os = configuration.getAttribute(ATTR_OS, EMPTY);
            String arch = configuration.getAttribute(ATTR_ARCH, EMPTY);
            String targetConfig = String.valueOf(os) + '.' + arch;
            projectConfigs.put(targetConfig, configuration);
            return true;
        }
        return false;
    }

    public boolean launchConfigurationRemoved(ILaunchConfiguration configuration) throws CoreException {
        for (Map.Entry<IProject, Map<String, ILaunchConfiguration>> projectEntry : this.configs.entrySet()) {
            Map<String, ILaunchConfiguration> projectConfigs = projectEntry.getValue();
            for (Map.Entry<String, ILaunchConfiguration> entry : projectConfigs.entrySet()) {
                if (!configuration.equals(entry.getValue())) continue;
                projectConfigs.remove(entry.getKey());
                if (projectConfigs.isEmpty()) {
                    this.configs.remove(projectEntry.getKey());
                }
                return true;
            }
        }
        return false;
    }

    public boolean launchConfigurationChanged(ILaunchConfiguration configuration) throws CoreException {
        return false;
    }

    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) throws CoreException {
        Map<String, ILaunchConfiguration> projectConfigs;
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project != null && (projectConfigs = this.configs.get(project)) != null) {
            for (ILaunchConfiguration config : projectConfigs.values()) {
                config.delete();
            }
        }
    }

    public void launchTargetRemoved(ILaunchTarget target) throws CoreException {
        String os = target.getAttribute("os", EMPTY);
        String arch = target.getAttribute("arch", EMPTY);
        ILaunchTargetManager targetManager = CDebugCorePlugin.getService(ILaunchTargetManager.class);
        ILaunchTarget[] iLaunchTargetArray = targetManager.getLaunchTargets();
        int n = iLaunchTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchTarget t = iLaunchTargetArray[n2];
            if (!target.equals(t) && os.equals(t.getAttribute("os", EMPTY)) && arch.equals(t.getAttribute("arch", EMPTY))) {
                return;
            }
            ++n2;
        }
        for (Map.Entry<IProject, Map<String, ILaunchConfiguration>> projectEntry : this.configs.entrySet()) {
            Map<String, ILaunchConfiguration> projectConfigs = projectEntry.getValue();
            ILaunchConfiguration config = projectConfigs.get(os);
            if (config == null) continue;
            config.delete();
        }
    }
}

