/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.MulticoreVisualizerUIPlugin;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.IVisualizerModelObject;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCPU;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerModel;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCanvas;
import org.eclipse.cdt.visualizer.ui.util.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;

public class MulticoreVisualizerCanvasFilter {
    List<IVisualizerModelObject> m_filterList = null;
    List<IVisualizerModelObject> m_dynamicFilterList = null;
    private MulticoreVisualizerCanvas m_canvas = null;
    private boolean m_filterActive = false;
    private int m_shownCpu = 0;
    private int m_shownCore = 0;
    private int m_shownThread = 0;
    private int m_totalCpu = 0;
    private int m_totalCore = 0;
    private int m_totalThread = 0;
    private static final String STR_FILTER_NOT_ACTIVE = MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.view.CanvasFilter.NotActive.text");
    private static final String STR_FILTER_ACTIVE = MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.view.CanvasFilter.Active.text");
    private static final String STR_CPU = MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.view.CanvasFilter.cpu.text");
    private static final String STR_CORE = MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.view.CanvasFilter.core.text");
    private static final String STR_THREAD = MulticoreVisualizerUIPlugin.getString("MulticoreVisualizer.view.CanvasFilter.thread.text");

    public MulticoreVisualizerCanvasFilter(MulticoreVisualizerCanvas canvas) {
        this.m_canvas = canvas;
    }

    public void dispose() {
        this.clearFilter();
        this.m_canvas = null;
    }

    public void applyFilter() {
        if (this.isFilterActive()) {
            this.clearFilter();
        }
        this.m_filterList = new ArrayList<IVisualizerModelObject>();
        this.m_dynamicFilterList = new ArrayList<IVisualizerModelObject>();
        this.m_filterActive = true;
        ISelection selection = this.m_canvas.getSelection();
        List selectedObjects = SelectionUtils.getSelectedObjects((ISelection)selection);
        for (Object obj : selectedObjects) {
            if (!(obj instanceof IVisualizerModelObject)) continue;
            this.m_filterList.add((IVisualizerModelObject)obj);
        }
    }

    public void clearFilter() {
        if (this.m_filterList != null) {
            this.m_filterList.clear();
            this.m_filterList = null;
        }
        if (this.m_dynamicFilterList != null) {
            this.m_dynamicFilterList.clear();
            this.m_dynamicFilterList = null;
        }
        this.resetCounters();
        this.m_filterActive = false;
    }

    public boolean isFilterActive() {
        return this.m_filterActive;
    }

    public void updateFilter() {
        if (this.m_filterList == null || this.m_canvas == null) {
            return;
        }
        VisualizerModel model = this.m_canvas.getModel();
        this.resetCounters();
        this.m_dynamicFilterList.clear();
        for (IVisualizerModelObject elem : this.m_filterList) {
            if (!this.isElementInCurrentModel(elem)) continue;
            this.addElementToFilterList(elem);
            IVisualizerModelObject parent = elem instanceof VisualizerThread && model != null ? model.getThread(((VisualizerThread)elem).getGDBTID()).getParent() : elem.getParent();
            while (parent != null) {
                this.addElementToFilterList(parent);
                parent = parent.getParent();
            }
        }
    }

    public boolean displayObject(IVisualizerModelObject candidate) {
        if (!this.m_filterActive) {
            return true;
        }
        return this.isElementInFilterList(candidate);
    }

    private void addElementToFilterList(IVisualizerModelObject elem) {
        if (!this.isElementInFilterList(elem)) {
            this.m_dynamicFilterList.add(elem);
            this.stepStatsCounter(elem);
        }
    }

    private boolean isElementInFilterList(IVisualizerModelObject candidate) {
        for (IVisualizerModelObject elem : this.m_dynamicFilterList) {
            if (candidate.compareTo(elem) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isElementInCurrentModel(IVisualizerModelObject element) {
        VisualizerCPU cpu;
        VisualizerCore core;
        VisualizerThread thread;
        VisualizerModel model = this.m_canvas.getModel();
        return model != null && (element instanceof VisualizerThread ? (thread = model.getThread(((VisualizerThread)element).getGDBTID())) != null && thread.compareTo(element) == 0 : (element instanceof VisualizerCore ? (core = model.getCore(element.getID())) != null && core.compareTo(element) == 0 : element instanceof VisualizerCPU && (cpu = model.getCPU(element.getID())) != null && cpu.compareTo(element) == 0));
    }

    private void stepStatsCounter(IVisualizerModelObject modelObj) {
        if (modelObj instanceof VisualizerCPU) {
            ++this.m_shownCpu;
        } else if (modelObj instanceof VisualizerCore) {
            ++this.m_shownCore;
        } else if (modelObj instanceof VisualizerThread) {
            ++this.m_shownThread;
        }
    }

    private void resetCounters() {
        VisualizerModel model;
        this.m_shownCpu = 0;
        this.m_shownCore = 0;
        this.m_shownThread = 0;
        if (this.m_canvas != null && (model = this.m_canvas.getModel()) != null) {
            this.m_totalCpu = model.getCPUCount();
            this.m_totalCore = model.getCoreCount();
            this.m_totalThread = model.getThreadCount();
        }
    }

    private String getStats() {
        return String.valueOf(STR_FILTER_ACTIVE) + " " + STR_CPU + " " + this.m_shownCpu + "/" + this.m_totalCpu + ", " + STR_CORE + " " + this.m_shownCore + "/" + this.m_totalCore + ", " + STR_THREAD + " " + this.m_shownThread + "/" + this.m_totalThread;
    }

    public String toString() {
        if (this.isFilterActive()) {
            return this.getStats();
        }
        return STR_FILTER_NOT_ACTIVE;
    }
}

