/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.wizards.model;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.internal.tools.Messages;
import org.eclipse.e4.internal.tools.wizards.model.NewModelFilePage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class BaseApplicationModelWizard
extends Wizard
implements INewWizard {
    private NewModelFilePage page;
    private ISelection selection;
    protected IWorkbench workbench;

    public BaseApplicationModelWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = this.createWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    protected abstract NewModelFilePage createWizardPage(ISelection var1);

    public abstract String getDefaultFileName();

    public boolean performFinish() {
        IFile modelFile;
        block6: {
            try {
                boolean continueWithExistingFile;
                modelFile = this.getModelFile();
                if (!modelFile.exists() || (continueWithExistingFile = this.handleFileExist())) break block6;
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.BaseApplicationModelWizard_Error, (String)exception.getMessage());
                return false;
            }
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                        Resource resource = resourceSet.createResource(fileURI);
                        EObject rootObject = BaseApplicationModelWizard.this.createInitialModel();
                        if (rootObject == null) {
                            throw new IllegalArgumentException(Messages.BaseApplicationModelWizard_ModelRootMustNotBeNull);
                        }
                        if (modelFile.exists()) {
                            resource.load(null);
                            BaseApplicationModelWizard.this.mergeWithExistingFile(resource, rootObject);
                        } else {
                            resource.getContents().add((Object)rootObject);
                        }
                        HashMap options = new HashMap();
                        resource.save(options);
                        BaseApplicationModelWizard.this.adjustBuildPropertiesFile(modelFile);
                        BaseApplicationModelWizard.this.adjustDependencies(modelFile);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Could not init editor", (String)exception.getMessage());
            return false;
        }
        return true;
    }

    protected boolean handleFileExist() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.BaseApplicationModelWizard_FileExists, (String)Messages.BaseApplicationModelWizard_TheFileAlreadyExists);
        return false;
    }

    protected abstract EObject createInitialModel();

    protected IFile getModelFile() throws CoreException {
        String containerName = this.page.getContainerName();
        String fileName = this.page.getFileName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        return container.getFile((IPath)new Path(fileName));
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.e4.tools.emf.editor3x", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    private void adjustBuildPropertiesFile(IFile file) throws CoreException {
        IProject project = file.getProject();
        IFile buildPropertiesFile = PDEProject.getBuildProperties((IProject)project);
        if (buildPropertiesFile.exists()) {
            String token;
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildPropertiesFile);
            IBuildEntry entry = model.getBuild().getEntry("bin.includes");
            if (!entry.contains(token = file.getProjectRelativePath().toString())) {
                entry.addToken(token);
            }
            model.save();
        }
    }

    protected void adjustDependencies(IFile file) {
    }

    protected void adjustFragmentDependencies(IFile file) {
        IProject project = file.getProject();
        IFile pluginXml = PDEProject.getPluginXml((IProject)project);
        IFile manifest = PDEProject.getManifest((IProject)project);
        WorkspaceBundlePluginModel fModel = new WorkspaceBundlePluginModel(manifest, pluginXml);
        try {
            this.addWorkbenchDependencyIfRequired(fModel);
            this.registerWithExtensionPointIfRequired(project, fModel, file);
        }
        catch (CoreException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.BaseApplicationModelWizard_Error, (String)e.getMessage());
        }
    }

    private void addWorkbenchDependencyIfRequired(WorkspaceBundlePluginModel fModel) throws CoreException {
        BundleDescription bundleDescription;
        IPluginImport[] imports;
        IPluginImport[] iPluginImportArray = imports = fModel.getPluginBase().getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport iPluginImport = iPluginImportArray[n2];
            if ("org.eclipse.e4.ui.model.workbench".equalsIgnoreCase(iPluginImport.getId())) {
                return;
            }
            ++n2;
        }
        String version = "";
        IPluginModelBase findModel = PluginRegistry.findModel((String)"org.eclipse.e4.ui.model.workbench");
        if (findModel != null && (bundleDescription = findModel.getBundleDescription()) != null) {
            version = bundleDescription.getVersion().toString().replaceFirst("\\.qualifier$", "");
        }
        IPluginImport workbenchImport = fModel.getPluginFactory().createImport();
        workbenchImport.setId("org.eclipse.e4.ui.model.workbench");
        workbenchImport.setVersion(version);
        workbenchImport.setMatch(4);
        fModel.getPluginBase().add(workbenchImport);
        fModel.save();
    }

    private void registerWithExtensionPointIfRequired(IProject project, WorkspaceBundlePluginModel fModel, IFile file) throws CoreException {
        IPluginExtension[] extensions;
        BundlePluginModel registryModel = (BundlePluginModel)PluginRegistry.findModel((String)project.getName());
        IPluginExtension[] iPluginExtensionArray = registryModel.getPluginBase().getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension e = iPluginExtensionArray[n2];
            IPluginExtension clonedExtens = this.copyExtension(fModel.getFactory(), e);
            fModel.getPluginBase().add(clonedExtens);
            ++n2;
        }
        iPluginExtensionArray = registryModel.getPluginBase().getExtensionPoints();
        n = iPluginExtensionArray.length;
        n2 = 0;
        while (n2 < n) {
            IPluginExtension ep = iPluginExtensionArray[n2];
            IPluginExtensionPoint clonedExtensionPoint = this.copyExtensionPoint(fModel.getFactory(), (IPluginExtensionPoint)ep);
            fModel.getPluginBase().add(clonedExtensionPoint);
            ++n2;
        }
        IPluginExtension[] iPluginExtensionArray2 = extensions = fModel.getPluginBase().getExtensions();
        int n3 = extensions.length;
        n = 0;
        while (n < n3) {
            IPluginExtension iPluginExtension = iPluginExtensionArray2[n];
            if ("org.eclipse.e4.workbench.model".equalsIgnoreCase(iPluginExtension.getPoint())) {
                IPluginObject[] children;
                IPluginObject[] iPluginObjectArray = children = iPluginExtension.getChildren();
                int n4 = children.length;
                int n5 = 0;
                while (n5 < n4) {
                    IPluginObject child = iPluginObjectArray[n5];
                    if ("fragment".equalsIgnoreCase(child.getName())) {
                        return;
                    }
                    ++n5;
                }
            }
            ++n;
        }
        IPluginExtension extPointFragmentRegister = fModel.getPluginFactory().createExtension();
        IPluginElement element = extPointFragmentRegister.getModel().getFactory().createElement((IPluginObject)extPointFragmentRegister);
        element.setName("fragment");
        element.setAttribute("uri", file.getName());
        extPointFragmentRegister.setId(String.valueOf(project.getName()) + "." + "fragment");
        extPointFragmentRegister.setPoint("org.eclipse.e4.workbench.model");
        extPointFragmentRegister.add((IPluginObject)element);
        fModel.getPluginBase().add(extPointFragmentRegister);
        fModel.save();
    }

    private IPluginExtension copyExtension(IExtensionsModelFactory factory, IPluginExtension ext) {
        try {
            IPluginObject[] _children;
            IPluginExtension clonedExt = factory.createExtension();
            clonedExt.setPoint(ext.getPoint());
            IPluginObject[] iPluginObjectArray = _children = ext.getChildren();
            int n = _children.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginObject elt = iPluginObjectArray[n2];
                if (elt instanceof IPluginElement) {
                    IPluginElement ipe = (IPluginElement)elt;
                    IPluginElement clonedElt = this.copyExtensionElement(factory, ipe, (IPluginObject)ext);
                    clonedExt.add((IPluginObject)clonedElt);
                }
                ++n2;
            }
            return clonedExt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private IPluginExtensionPoint copyExtensionPoint(IExtensionsModelFactory factory, IPluginExtensionPoint ep) {
        try {
            IPluginExtensionPoint clonedExtPt = factory.createExtensionPoint();
            clonedExtPt.setId(ep.getId());
            clonedExtPt.setName(ep.getName());
            clonedExtPt.setSchema(ep.getSchema());
            return clonedExtPt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private IPluginElement copyExtensionElement(IExtensionsModelFactory factory, IPluginElement elt, IPluginObject parent) {
        try {
            IPluginElement clonedElt = factory.createElement(parent);
            clonedElt.setName(elt.getName());
            IPluginAttribute[] iPluginAttributeArray = elt.getAttributes();
            int n = iPluginAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginAttribute a = iPluginAttributeArray[n2];
                clonedElt.setAttribute(a.getName(), a.getValue());
                ++n2;
            }
            iPluginAttributeArray = elt.getChildren();
            n = iPluginAttributeArray.length;
            n2 = 0;
            while (n2 < n) {
                IPluginAttribute e = iPluginAttributeArray[n2];
                if (e instanceof IPluginElement) {
                    IPluginElement ipe = (IPluginElement)e;
                    IPluginElement copyExtensionElement = this.copyExtensionElement(factory, ipe, (IPluginObject)clonedElt);
                    clonedElt.add((IPluginObject)copyExtensionElement);
                }
                ++n2;
            }
            return clonedElt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void mergeWithExistingFile(Resource resource, EObject rootObject) {
    }
}

