/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.impl.ConflictImpl;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.SideLabelProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.ConflictNodeBuilder;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.ConflictNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.AbstractDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ThreeWayComparisonGroupProvider
extends AbstractDifferenceGroupProvider {
    public static final Predicate<? super Diff> DEFAULT_DIFF_GROUP_FILTER_PREDICATE = Predicates.and((Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO})), (Predicate)Predicates.not((Predicate)Predicates.or((Predicate)EMFComparePredicates.anyRefining((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL})), (Predicate)EMFComparePredicates.allAtomicRefining((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})))));

    @Override
    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return comparison != null && comparison.isThreeWay();
    }

    @Override
    protected Collection<? extends IDifferenceGroup> buildGroups(Comparison comparison2) {
        String rightLabel;
        String leftLabel;
        Adapter adapter = EcoreUtil.getAdapter((List)this.getComparison().eAdapters(), SideLabelProvider.class);
        if (adapter instanceof SideLabelProvider) {
            SideLabelProvider labelProvider = (SideLabelProvider)adapter;
            leftLabel = labelProvider.getLeftLabel();
            rightLabel = labelProvider.getRightLabel();
        } else {
            leftLabel = EMFCompareRCPUIMessages.getString("ThreeWayComparisonGroupProvider.left.label");
            rightLabel = EMFCompareRCPUIMessages.getString("ThreeWayComparisonGroupProvider.right.label");
        }
        ConflictsGroupImpl conflicts = new ConflictsGroupImpl(this.getComparison(), EMFCompareRCPUIMessages.getString("ThreeWayComparisonGroupProvider.conflicts.label"), this.getCrossReferenceAdapter());
        conflicts.buildSubTree();
        BasicDifferenceGroupImpl leftSide = new BasicDifferenceGroupImpl(this.getComparison(), (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), DEFAULT_DIFF_GROUP_FILTER_PREDICATE), leftLabel, this.getCrossReferenceAdapter());
        leftSide.buildSubTree();
        BasicDifferenceGroupImpl rightSide = new BasicDifferenceGroupImpl(this.getComparison(), (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), DEFAULT_DIFF_GROUP_FILTER_PREDICATE), rightLabel, this.getCrossReferenceAdapter());
        rightSide.buildSubTree();
        return ImmutableList.of((Object)conflicts, (Object)leftSide, (Object)rightSide);
    }

    public static class CompositeConflict
    extends ConflictImpl {
        private Set<Conflict> conflicts = new LinkedHashSet<Conflict>();
        private EList<Diff> diffs = new BasicEList();
        private ConflictKind conflictKind = ConflictKind.REAL;

        public CompositeConflict(Conflict conflict) {
            this.conflicts.add((Conflict)Preconditions.checkNotNull((Object)conflict));
            this.conflictKind = (ConflictKind)Preconditions.checkNotNull((Object)conflict.getKind());
            this.diffs.addAll(this.computeRefinedDiffs(conflict));
        }

        private Set<Diff> computeRefinedDiffs(Conflict conflict) {
            LinkedHashSet<Diff> computedDiffs = new LinkedHashSet<Diff>();
            for (Diff diff : conflict.getDifferences()) {
                if (diff.getRefines().isEmpty()) {
                    computedDiffs.add(diff);
                    continue;
                }
                computedDiffs.addAll(DiffUtil.getRootRefinedDiffs((Diff)diff));
            }
            return computedDiffs;
        }

        public ConflictKind getKind() {
            return this.conflictKind;
        }

        public EList<Diff> getDifferences() {
            return this.diffs;
        }

        public Set<Conflict> getConflicts() {
            return Collections.unmodifiableSet(this.conflicts);
        }

        public void join(CompositeConflict conflict) {
            LinkedHashSet<Diff> currentDiffSet = new LinkedHashSet<Diff>((Collection<Diff>)this.diffs);
            LinkedHashSet<Diff> otherDiffSet = new LinkedHashSet<Diff>((Collection<Diff>)conflict.getDifferences());
            Sets.SetView newDiffs = Sets.difference(otherDiffSet, currentDiffSet);
            this.diffs.addAll((Collection)newDiffs);
            if (this.conflicts.addAll(conflict.getConflicts()) && this.conflictKind != ConflictKind.REAL) {
                this.conflictKind = Iterables.any(this.conflicts, (Predicate)EMFComparePredicates.containsConflictOfTypes((ConflictKind[])new ConflictKind[]{ConflictKind.REAL})) ? ConflictKind.REAL : ConflictKind.PSEUDO;
            }
        }
    }

    public static class ConflictsGroupImpl
    extends BasicDifferenceGroupImpl {
        private static final Predicate<? super Diff> DEFAULT_CONFLICT_GROUP_FILTER_PREDICATE = EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO});
        private final List<CompositeConflict> compositeConflicts = Lists.newArrayList();
        private final Map<Diff, CompositeConflict> diffToCompositeConflictMap = Maps.newHashMap();

        public ConflictsGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, ECrossReferenceAdapter crossReferenceAdapter) {
            super(comparison, filter, name, crossReferenceAdapter);
        }

        public ConflictsGroupImpl(Comparison comparison, String name, ECrossReferenceAdapter crossReferenceAdapter) {
            super(comparison, DEFAULT_CONFLICT_GROUP_FILTER_PREDICATE, name, crossReferenceAdapter);
        }

        @Override
        protected boolean mustDisplayAsDirectChildOfMatch(Diff diff) {
            return diff.getRefines().isEmpty() || diff.getConflict() != null && !diff.getConflict().getDifferences().containsAll((Collection)diff.getRefines());
        }

        @Override
        protected void doBuildSubTrees() {
            for (Conflict conflict : this.getComparison().getConflicts()) {
                CompositeConflict compositeConflict = new CompositeConflict(conflict);
                this.compositeConflicts.add(compositeConflict);
                this.joinOverlappingCompositeConflicts(compositeConflict);
                this.updateDiffToCompositeConflictMap(compositeConflict);
            }
            for (CompositeConflict compositeConflict : this.compositeConflicts) {
                ConflictNodeBuilder builder = new ConflictNodeBuilder((Conflict)compositeConflict, this);
                ConflictNode conflictNode = builder.buildNode();
                this.children.add(conflictNode);
            }
        }

        private void joinOverlappingCompositeConflicts(CompositeConflict compositeConflict) {
            HashSet<CompositeConflict> compositeConflictsToJoin = new HashSet<CompositeConflict>();
            for (Diff diff : compositeConflict.getDifferences()) {
                if (!this.diffToCompositeConflictMap.containsKey(diff)) continue;
                compositeConflictsToJoin.add(this.diffToCompositeConflictMap.get(diff));
            }
            for (CompositeConflict conflictGroupToJoin : compositeConflictsToJoin) {
                compositeConflict.join(conflictGroupToJoin);
                this.compositeConflicts.remove((Object)conflictGroupToJoin);
            }
        }

        private void updateDiffToCompositeConflictMap(CompositeConflict compositeConflict) {
            for (Diff diff : compositeConflict.getDifferences()) {
                this.diffToCompositeConflictMap.put(diff, compositeConflict);
            }
        }

        @Override
        public IStyledString.IComposedStyledString getStyledName() {
            ComposedStyledString ret = new ComposedStyledString();
            Iterator eAllContents = Iterators.concat((Iterator)Iterators.transform(this.getChildren().iterator(), (Function)E_ALL_CONTENTS));
            Iterator eAllData = Iterators.transform((Iterator)eAllContents, (Function)TREE_NODE_DATA);
            UnmodifiableIterator eAllDiffData = Iterators.filter((Iterator)eAllData, Diff.class);
            HashSet diffs = Sets.newHashSet((Iterator)eAllDiffData);
            boolean unresolvedDiffs = Iterables.any((Iterable)diffs, (Predicate)Predicates.and((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}), (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO})));
            if (unresolvedDiffs) {
                ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
            }
            ret.append(this.getName());
            return ret;
        }

        @Override
        protected void addDiffNode(MatchNode matchNode, Diff diff) {
            DiffNode diffNode = this.createDiffNode(diff);
            this.handleRefiningDiffs(diffNode);
            matchNode.addDiffNode(diffNode);
        }
    }
}

