/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.json.generator.xtend;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.emf2web.json.generator.xtend.JsonGenerator;
import org.eclipse.emf.ecp.emf2web.util.ReferenceHelper;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorization;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizationElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategory;
import org.eclipse.emf.ecp.view.spi.label.model.VLabel;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;

public class FormsJsonGenerator
extends JsonGenerator {
    private static final String TYPE = "type";
    private static final String ELEMENTS = "elements";
    private static final String CONTROL = "Control";
    private static final String CATEGORIZATION = "Categorization";
    private static final String CATEGORY = "Category";
    private static final String SCOPE = "scope";
    private static final String LABEL = "label";
    private ReferenceHelper refHelper;

    public FormsJsonGenerator(ReferenceHelper refHelper) {
        this.refHelper = refHelper;
    }

    @Override
    public JsonElement createJsonElement(EObject object) {
        return this.createJsonFormsElement(object);
    }

    private JsonElement _createJsonFormsElement(EObject object) {
        throw new UnsupportedOperationException("Cannot create a JSON Forms element for EObjects that are not instanceof VView, VControl or VContainer.");
    }

    private JsonElement _createJsonFormsElement(VLabel label) {
        JsonObject _xblockexpression = null;
        JsonObject jsonObj = new JsonObject();
        this.withType(jsonObj, "Label");
        String _name = label.getName();
        _xblockexpression = this.with(jsonObj, "text", _name);
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(VCategorizationElement categorizationElement) {
        JsonObject _jsonObject = new JsonObject();
        JsonObject _withType = this.withType(_jsonObject, CATEGORIZATION);
        EList _categorizations = categorizationElement.getCategorizations();
        return this.withElements(_withType, (Collection<? extends VElement>)_categorizations);
    }

    private JsonElement _createJsonFormsElement(VCategorization categorization) {
        JsonObject _jsonObject = new JsonObject();
        JsonObject _withType = this.withType(_jsonObject, CATEGORIZATION);
        String _label = categorization.getLabel();
        JsonObject _withLabel = this.withLabel(_withType, _label);
        EList _categorizations = categorization.getCategorizations();
        return this.withElements(_withLabel, (Collection<? extends VElement>)_categorizations);
    }

    private JsonElement _createJsonFormsElement(VCategory category) {
        JsonObject _xblockexpression = null;
        JsonObject jsonObj = new JsonObject();
        this.withType(jsonObj, CATEGORY);
        String _label = category.getLabel();
        this.withLabel(jsonObj, _label);
        VContainedElement contained = category.getComposite();
        JsonObject _switchResult = null;
        boolean _matched = false;
        if (!_matched && contained instanceof VContainer) {
            _matched = true;
            EList _children = ((VContainer)contained).getChildren();
            _switchResult = this.withElements(jsonObj, (Collection<? extends VElement>)_children);
        }
        if (!_matched) {
            throw new UnsupportedOperationException("Category must contain a VContainer element");
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(VView view) {
        JsonObject _switchResult = null;
        EList _children = view.getChildren();
        int _size = _children.size();
        switch (_size) {
            case 0: {
                _switchResult = new JsonObject();
                break;
            }
            case 1: {
                EList _children_1 = view.getChildren();
                VContainedElement _get = (VContainedElement)_children_1.get(0);
                _switchResult = this.createJsonFormsElement(_get);
                break;
            }
            default: {
                EList _children_2 = view.getChildren();
                _switchResult = this.createJsonFormsElement(_children_2);
            }
        }
        return _switchResult;
    }

    private JsonElement _createJsonFormsElement(VControl control) {
        JsonObject _xblockexpression = null;
        JsonObject jsonObject = new JsonObject();
        this.withType(jsonObject, CONTROL);
        String _displayLabel = this.getDisplayLabel(control);
        this.withLabel(jsonObject, _displayLabel);
        String _ref = this.getRef(control);
        _xblockexpression = this.withScope(jsonObject, _ref);
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(VContainer container) {
        boolean _tripleNotEquals;
        JsonObject _xblockexpression = null;
        JsonObject jsonObject = new JsonObject();
        String _type = this.getType((VElement)container);
        this.withType(jsonObject, _type);
        String _name = container.getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            String _label = container.getLabel();
            String _displayLabel = this.getDisplayLabel(_label);
            this.withLabel(jsonObject, _displayLabel);
        }
        EList _children = container.getChildren();
        _xblockexpression = this.withElements(jsonObject, (Collection<? extends VElement>)_children);
        return _xblockexpression;
    }

    private JsonElement _createJsonFormsElement(Collection<? extends VElement> elements) {
        JsonObject _xblockexpression = null;
        JsonObject jsonObject = new JsonObject();
        _xblockexpression = this.withVerticalLayout(jsonObject, elements);
        return _xblockexpression;
    }

    private JsonObject withType(JsonObject jsonObject, String type) {
        return this.with(jsonObject, TYPE, type);
    }

    private JsonObject withScope(JsonObject jsonObject, String ref) {
        return this.with(jsonObject, SCOPE, ref);
    }

    private JsonObject withLabel(JsonObject jsonObject, String label) {
        return this.with(jsonObject, LABEL, label);
    }

    private JsonObject withElements(JsonObject jsonObject, Collection<? extends VElement> elements) {
        return this.with(jsonObject, ELEMENTS, elements);
    }

    private JsonObject withVerticalLayout(JsonObject jsonObject, Collection<? extends VElement> elements) {
        JsonObject _xblockexpression = null;
        this.withType(jsonObject, "VerticalLayout");
        _xblockexpression = this.withElements(jsonObject, elements);
        return _xblockexpression;
    }

    private String getType(VElement vElement) {
        EClass _eClass = vElement.eClass();
        return _eClass.getName();
    }

    private String getRef(VControl control) {
        VDomainModelReference _domainModelReference = control.getDomainModelReference();
        return this.refHelper.getStringRepresentation(_domainModelReference);
    }

    private String getDisplayLabel(VControl control) {
        VDomainModelReference _domainModelReference = control.getDomainModelReference();
        return this.refHelper.getLabel(_domainModelReference);
    }

    private String getDisplayLabel(String containerLabel) {
        String _xblockexpression = null;
        String _trim = containerLabel.trim();
        boolean _startsWith = _trim.startsWith("%");
        if (_startsWith) {
            boolean _greaterThan;
            String _trim_1 = containerLabel.trim();
            String label = _trim_1.substring(1);
            String[] split = label.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
            String _get = split[0];
            int _length = _get.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                String _string;
                char _upperCase;
                String _get_1 = split[0];
                char[] charArray = _get_1.toCharArray();
                char _get_2 = charArray[0];
                charArray[0] = _upperCase = Character.toUpperCase(_get_2);
                split[0] = _string = new String(charArray);
            }
            StringBuilder sb = new StringBuilder();
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                sb.append(str);
                sb.append(" ");
                ++n2;
            }
            String _string_1 = sb.toString();
            return _string_1.trim();
        }
        _xblockexpression = containerLabel;
        return _xblockexpression;
    }

    private JsonElement createJsonFormsElement(Object categorization) {
        if (categorization instanceof VCategorization) {
            return this._createJsonFormsElement((VCategorization)categorization);
        }
        if (categorization instanceof VCategory) {
            return this._createJsonFormsElement((VCategory)categorization);
        }
        if (categorization instanceof VCategorizationElement) {
            return this._createJsonFormsElement((VCategorizationElement)categorization);
        }
        if (categorization instanceof VLabel) {
            return this._createJsonFormsElement((VLabel)categorization);
        }
        if (categorization instanceof VControl) {
            return this._createJsonFormsElement((VControl)categorization);
        }
        if (categorization instanceof VContainer) {
            return this._createJsonFormsElement((VContainer)categorization);
        }
        if (categorization instanceof VView) {
            return this._createJsonFormsElement((VView)categorization);
        }
        if (categorization instanceof Collection) {
            return this._createJsonFormsElement((Collection)categorization);
        }
        if (categorization instanceof EObject) {
            return this._createJsonFormsElement((EObject)categorization);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(categorization).toString());
    }
}

