/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.editors.pages;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.context.impl.DomainPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.ui.editor.InteractiveEEFEditor;
import org.eclipse.emf.eef.runtime.ui.editors.pages.AbstractEEFMDFormPage;
import org.eclipse.emf.eef.runtime.ui.layout.EEFFormLayoutFactory;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionContentProvider;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionMessageManager;
import org.eclipse.emf.eef.runtime.ui.viewers.PropertiesEditionViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EEFDetailsPage
extends AbstractFormPart
implements IDetailsPage,
IPropertiesEditionListener {
    private FormToolkit toolkit;
    private EditingDomain editingDomain;
    protected EObject eObject;
    protected IPropertiesEditionComponent propertiesEditionComponent;
    private PropertiesEditionMessageManager messageManager;
    protected PropertiesEditionViewer viewer;
    private AdapterFactory adapterFactory;

    public EEFDetailsPage(FormToolkit toolkit, EditingDomain editingDomain, AdapterFactory adapterFactory) {
        this.toolkit = toolkit;
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
    }

    public void createContents(Composite parent) {
        this.toolkit = this.getManagedForm().getToolkit();
        parent.setLayout((Layout)EEFFormLayoutFactory.createDetailsGridLayout(false, 1));
        parent.setLayoutData((Object)new GridData(1808));
        Composite container = this.toolkit.createComposite(parent, 0x800000);
        GridLayout containerLayout = new GridLayout();
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.messageManager = new PropertiesEditionMessageManager(){

            protected void updateStatus(String message) {
                if (message != null && !"".equals(message)) {
                    EEFDetailsPage.this.getManagedForm().getForm().setMessage(message, 3);
                } else {
                    EEFDetailsPage.this.getManagedForm().getForm().setMessage(null, 0);
                }
            }
        };
        this.viewer = new PropertiesEditionViewer(container, null, 0, 1);
        this.viewer.setDynamicTabHeader(true);
        this.viewer.setToolkit(this.getManagedForm().getToolkit());
        this.viewer.setContentProvider((IContentProvider)new PropertiesEditionContentProvider(this.adapterFactory, "Live", this.editingDomain));
        this.viewer.addPropertiesListener((IPropertiesEditionListener)this);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        EObject newEObject = this.getEObjectFromSelection(selection);
        if (newEObject != null && newEObject != this.eObject) {
            this.eObject = newEObject;
            if (this.eObject != null) {
                if (this.viewer.getToolkit() == null) {
                    this.viewer.setToolkit(this.toolkit);
                }
                this.viewer.setInput((Object)new DomainPropertiesEditionContext(null, null, this.editingDomain, this.adapterFactory, this.eObject));
                this.viewer.addPropertiesListener((IPropertiesEditionListener)this);
            }
        }
    }

    private EObject getEObjectFromSelection(ISelection selection) {
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof EObject) {
            return (EObject)((StructuredSelection)selection).getFirstElement();
        }
        if (selection instanceof EObject) {
            return (EObject)selection;
        }
        if (selection instanceof IAdaptable && ((IAdaptable)selection).getAdapter(EObject.class) != null) {
            return (EObject)((IAdaptable)selection).getAdapter(EObject.class);
        }
        return null;
    }

    public PropertiesEditionViewer getViewer() {
        return this.viewer;
    }

    public void firePropertiesChanged(IPropertiesEditionEvent event) {
        this.handleChange(event);
        if (event.getState() == 10 && event.getKind() == 12) {
            if (this.getEditor() instanceof InteractiveEEFEditor) {
                ((InteractiveEEFEditor)((Object)this.getEditor())).deactivateCCPActions();
            }
        } else if (event.getState() == 10 && event.getKind() == 11 && this.getEditor() instanceof InteractiveEEFEditor) {
            ((InteractiveEEFEditor)((Object)this.getEditor())).activateCCPActions();
        }
    }

    private void handleChange(IPropertiesEditionEvent event) {
        if (this.viewer.isInitializing()) {
            return;
        }
        this.messageManager.processMessage(event);
    }

    private Object getEditor() {
        if (this.getManagedForm().getContainer() instanceof AbstractEEFMDFormPage) {
            return ((AbstractEEFMDFormPage)this.getManagedForm().getContainer()).getEditor();
        }
        return null;
    }
}

