/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.serialization.model.serialization.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.facet.util.emf.core.serialization.ISerializationService;
import org.eclipse.emf.facet.util.emf.core.serialization.model.serialization.SerializationFactory;
import org.eclipse.emf.facet.util.emf.core.serialization.model.serialization.SerializationPackage;

public class SerializationFactoryImpl
extends EFactoryImpl
implements SerializationFactory {
    public static SerializationFactory init() {
        try {
            SerializationFactory theSerializationFactory = (SerializationFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/facet/serialization/0.1.incubation");
            if (theSerializationFactory != null) {
                return theSerializationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SerializationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        eClass.getClassifierID();
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return SerializationFactoryImpl.createExtensibleSerializableJavaObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return SerializationFactoryImpl.convertExtensibleSerializableJavaObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public static Object createExtensibleSerializableJavaObjectFromString(EDataType eDataType, String initialValue) {
        return ISerializationService.INSTANCE.deserialize(initialValue);
    }

    public static String convertExtensibleSerializableJavaObjectToString(EDataType eDataType, Object instanceValue) {
        return ISerializationService.INSTANCE.serialize(instanceValue);
    }

    public SerializationPackage getSerializationPackage() {
        return (SerializationPackage)this.getEPackage();
    }

    @Deprecated
    public static SerializationPackage getPackage() {
        return SerializationPackage.eINSTANCE;
    }
}

