/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ip.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.equinox.internal.ip.impl.ProvisioningAgent;
import org.osgi.service.provisioning.ProvisioningService;

public class Log {
    public static boolean j9workAround;
    public static boolean debug;
    public static boolean remoteDebug;
    public static boolean sendTrace;
    public static byte[] NO_TRACE;
    public static ProvisioningService prvSrv;
    private static PrintStream logStream;
    public static org.eclipse.equinox.internal.util.ref.Log log;

    static {
        NO_TRACE = "NoTrace".getBytes();
        try {
            String logFile = ProvisioningAgent.bc.getProperty("equinox.provisioning.provisioning.logfile");
            if (logFile != null && (logFile = logFile.trim()).length() != 0) {
                File log = new File(logFile);
                log = log.isDirectory() ? new File(log, "log.txt") : log;
                logStream = new PrintStream(new FileOutputStream(log), true);
            }
        }
        catch (Exception exception) {
            logStream = null;
        }
    }

    public static void debug(String obj) {
        String message = "[PROVISIONING] " + obj;
        if (debug && logStream != null) {
            logStream.println(message);
        } else if (log != null) {
            log.debug(message, null);
        }
    }

    public static void debug(Throwable e) {
        Log.debug(null, e, remoteDebug);
    }

    public static void debug(String message, Throwable e) {
        Log.debug(message, e, remoteDebug);
    }

    private static void debug(String message, Throwable e, boolean sendRemote) {
        if (debug && logStream != null) {
            logStream.println("[PROVISIONING] " + message);
            e.printStackTrace(logStream);
        } else if (log != null) {
            log.debug(message, e);
        }
        if (sendRemote && e != null && (e.getMessage() == null || e.getMessage().indexOf("Error from Backend") == -1)) {
            Log.log(message, e);
        }
    }

    private static void log(String message, Throwable e) {
        Log.debug("Log exception remotely.");
        String logUrl = null;
        try {
            Dictionary info;
            ProvisioningService prvSrv = Log.prvSrv;
            if (prvSrv != null && (info = prvSrv.getInformation()) != null && (logUrl = (String)info.get("equinox.provisioning.prv.log")) != null) {
                Log.debug("Log url = " + logUrl);
                HttpURLConnection conn = (HttpURLConnection)new URL(logUrl).openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Connection", "close");
                conn.setRequestProperty("provisioning.spid", "" + info.get("provisioning.spid"));
                conn.setRequestProperty("msg", String.valueOf(message != null ? String.valueOf(message) + ": " : "") + e.getMessage());
                conn.setRequestProperty("lvl", "1");
                OutputStream os = new ByteArrayOutputStream();
                if (sendTrace) {
                    e.printStackTrace(new PrintStream(os));
                } else {
                    os.write(NO_TRACE);
                }
                byte[] stackTrace = ((ByteArrayOutputStream)os).toByteArray();
                if (!j9workAround) {
                    conn.setRequestProperty("Content-Length", String.valueOf(stackTrace.length));
                }
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.connect();
                os = conn.getOutputStream();
                os.write(stackTrace);
                os.flush();
                InputStream is = conn.getInputStream();
                while (is.read() != -1) {
                }
            }
        }
        catch (Throwable t) {
            Log.debug("Error while logging remotely to url \"" + logUrl + '\"', t, false);
        }
    }
}

