/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IHandlePartFactory;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class HoverIntentBehavior
extends AbstractBehavior {
    public static final String HOVER_INTENT_FEEDBACK_PART_FACTORY = "HOVER_INTENT_FEEDBACK_PART_FACTORY";
    public static final String HOVER_INTENT_HANDLE_PART_FACTORY = "HOVER_INTENT_HANDLE_PART_FACTORY";
    private ChangeListener<IContentPart<? extends Node>> hoverIntentObserver = new ChangeListener<IContentPart<? extends Node>>(){

        public void changed(ObservableValue<? extends IContentPart<? extends Node>> observable, IContentPart<? extends Node> oldValue, IContentPart<? extends Node> newValue) {
            HoverIntentBehavior.this.onHoverIntentChange(oldValue, newValue);
        }
    };

    @Override
    protected void doActivate() {
        HoverModel hoverModel = this.getHoverModel();
        hoverModel.hoverIntentProperty().addListener(this.hoverIntentObserver);
        IContentPart<? extends Node> hoverIntent = hoverModel.getHoverIntent();
        if (hoverIntent != null) {
            this.onHoverIntentChange(null, hoverIntent);
        }
    }

    @Override
    protected void doDeactivate() {
        HoverModel hoverModel = this.getHoverModel();
        IContentPart<? extends Node> hoverIntent = hoverModel.getHoverIntent();
        if (hoverIntent != null) {
            this.onHoverIntentChange(hoverIntent, null);
        }
        hoverModel.hoverIntentProperty().removeListener(this.hoverIntentObserver);
        this.clearFeedback();
        this.clearHandles();
    }

    @Override
    protected IFeedbackPartFactory getFeedbackPartFactory(IViewer viewer) {
        return this.getFeedbackPartFactory(viewer, HOVER_INTENT_FEEDBACK_PART_FACTORY);
    }

    @Override
    protected IHandlePartFactory getHandlePartFactory(IViewer viewer) {
        return this.getHandlePartFactory(viewer, HOVER_INTENT_HANDLE_PART_FACTORY);
    }

    protected HoverModel getHoverModel() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        HoverModel hoverModel = (HoverModel)((Object)viewer.getAdapter(HoverModel.class));
        return hoverModel;
    }

    protected void onHoverIntentChange(IContentPart<? extends Node> oldHoverIntent, IContentPart<? extends Node> newHoverIntent) {
        if (oldHoverIntent == newHoverIntent) {
            return;
        }
        if (oldHoverIntent != null) {
            this.removeHandles(oldHoverIntent);
            this.removeFeedback(oldHoverIntent);
        }
        if (newHoverIntent != null) {
            this.addFeedback(newHoverIntent);
            this.addHandles(newHoverIntent);
        }
    }
}

