/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.uicore.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.Activator;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class EMFUtil {
    public static boolean isInFirstResource(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return false;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return false;
        }
        EList resources = resourceSet.getResources();
        return resources.size() > 0 && resourceSet.getResources().get(0) == resource;
    }

    public Collection<EObject> findInstancesOf(EClass eClass, Resource resource) {
        ArrayList<EObject> instances = new ArrayList<EObject>();
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (eObject.eClass() != eClass) continue;
            instances.add(eObject);
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Collection<EClass> findAllClasses(Collection<Resource> browsedResources) {
        TreeSet<EClass> classes = new TreeSet<EClass>(new Comparator<EClass>(){

            @Override
            public int compare(EClass c1, EClass c2) {
                return ModelUtils.getMetaclassQualifiedName((EClassifier)c1).compareTo(ModelUtils.getMetaclassQualifiedName((EClassifier)c2));
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        ArrayList<Resource> newResources = new ArrayList<Resource>();
        resources.addAll(browsedResources);
        for (Resource resource : browsedResources) {
            if (resource == null) {
                MoDiscoLogger.logWarning((String)"null Resource in browsed resources", (Plugin)Activator.getDefault());
                continue;
            }
            Object mutex = resource.getResourceSet();
            if (mutex == null) {
                mutex = EMFUtil.class;
            }
            ResourceSet resourceSet = mutex;
            synchronized (resourceSet) {
                Resource resource2 = resource;
                synchronized (resource2) {
                    TreeIterator allContents = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
                    while (allContents.hasNext()) {
                        EClass eClass;
                        EObject eObject = (EObject)allContents.next();
                        if (eObject instanceof EClass) {
                            eClass = (EClass)eObject;
                            classes.add(eClass);
                            continue;
                        }
                        eClass = eObject.eClass();
                        if (eClass == null) continue;
                        classes.add(eClass);
                        Resource res = eClass.eResource();
                        if (res == null || resources.contains(res)) continue;
                        resources.add(res);
                        newResources.add(res);
                    }
                }
            }
        }
        EMFUtil.addAll(classes, newResources);
        newResources.clear();
        ArrayList<EClass> newClasses = new ArrayList<EClass>();
        for (EClass eClass : classes) {
            EList allSuperTypes = eClass.getEAllSuperTypes();
            for (EClass superclass : allSuperTypes) {
                newClasses.add(superclass);
                Resource resource = superclass.eResource();
                if (resource == null || resources.contains(resource)) continue;
                resources.add(resource);
                newResources.add(resource);
            }
        }
        for (EClass eClass : newClasses) {
            classes.add(eClass);
        }
        EMFUtil.addAll(classes, newResources);
        return classes;
    }

    private static void addAll(Set<EClass> classes, List<Resource> resources) {
        for (Resource resource : resources) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof EClass)) continue;
                EClass eClass = (EClass)eObject;
                classes.add(eClass);
            }
        }
    }

    public static EClass findCommonClass(List<EObject> elements) {
        EClass eClass = null;
        for (EObject element : elements) {
            EClass elementEClass = element.eClass();
            if (eClass == null) {
                eClass = elementEClass;
                continue;
            }
            if (eClass.isSuperTypeOf(elementEClass)) continue;
            if (elementEClass.isSuperTypeOf(eClass)) {
                eClass = elementEClass;
                continue;
            }
            if ((eClass = EMFUtil.findSuperType(eClass, elementEClass)) != null) continue;
            return null;
        }
        return eClass;
    }

    private static EClass findSuperType(EClass eClass, EClass element) {
        LinkedList<EClass> breadthFirstList = new LinkedList<EClass>();
        breadthFirstList.addFirst(eClass);
        while (!breadthFirstList.isEmpty()) {
            EClass candidateClass = (EClass)breadthFirstList.poll();
            if (candidateClass.isSuperTypeOf(element)) {
                return candidateClass;
            }
            for (EClass supertype : candidateClass.getESuperTypes()) {
                breadthFirstList.addLast(supertype);
            }
        }
        return null;
    }

    public static boolean tryResolve(EObject eObject) {
        EObject resolved = EcoreUtil.resolve((EObject)eObject, null);
        return !resolved.eIsProxy();
    }

    public static String proxyURI(EObject eObject) {
        URI eProxyURI = ((InternalEObject)eObject).eProxyURI();
        if (eProxyURI == null) {
            return "";
        }
        return eProxyURI.toString();
    }

    public static <T extends ENamedElement> T findElementWithName(String name, EList<T> elements) {
        for (ENamedElement element : elements) {
            if (!name.equals(element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public static EClass findMetaclassWithName(String metaclassFullyQualifiedName, List<EClass> metaclasses) {
        for (EClass eClass : metaclasses) {
            if (!metaclassFullyQualifiedName.equals(ModelUtils.getMetaclassQualifiedName((EClassifier)eClass))) continue;
            return eClass;
        }
        return null;
    }

    public static String getMetamodelName(String nsURI) {
        if (nsURI != null) {
            String name;
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            if (ePackage != null && (name = ePackage.getName()) != null) {
                return name;
            }
            URI uri = URI.createURI((String)nsURI);
            String lastSegment = uri.lastSegment();
            if (lastSegment != null) {
                return lastSegment;
            }
        }
        return null;
    }

    public static List<EClass> getMetaclasses(Resource metamodel) {
        ArrayList<EClass> metaclasses = new ArrayList<EClass>();
        TreeIterator allContents = metamodel.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof EClass)) continue;
            EClass eClass = (EClass)eObject;
            metaclasses.add(eClass);
        }
        return metaclasses;
    }

    public static EObject findElementByURI(String uriFragment, ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            EObject eObject = resource.getEObject(uriFragment);
            if (eObject == null) continue;
            return eObject;
        }
        return null;
    }
}

