/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LinkedProposalModelPresenter {
    public void enterLinkedMode(ITextViewer viewer, IEditorPart editor, boolean switchedEditor, LinkedProposalModel linkedProposalModel) throws BadLocationException {
        IDocument document = viewer.getDocument();
        LinkedModeModel model = new LinkedModeModel();
        boolean added = false;
        Iterator<LinkedProposalPositionGroup> iterator = linkedProposalModel.getPositionGroupIterator();
        while (iterator.hasNext()) {
            LinkedProposalPositionGroup curr = iterator.next();
            LinkedPositionGroup group = new LinkedPositionGroup();
            LinkedProposalPositionGroup.PositionInformation[] positions = curr.getPositions();
            if (positions.length <= 0) continue;
            LinkedProposalPositionGroup.Proposal[] linkedModeProposals = curr.getProposals();
            if (linkedModeProposals.length <= 1) {
                int i = 0;
                while (i < positions.length) {
                    LinkedProposalPositionGroup.PositionInformation pos = positions[i];
                    if (pos.getOffset() != -1) {
                        group.addPosition(new LinkedPosition(document, pos.getOffset(), pos.getLength(), pos.getSequenceRank()));
                    }
                    ++i;
                }
            } else {
                ICompletionProposal[] proposalImpls = new LinkedPositionProposalImpl[linkedModeProposals.length];
                int i = 0;
                while (i < linkedModeProposals.length) {
                    proposalImpls[i] = new LinkedPositionProposalImpl(linkedModeProposals[i], model);
                    ++i;
                }
                i = 0;
                while (i < positions.length) {
                    LinkedProposalPositionGroup.PositionInformation pos = positions[i];
                    if (pos.getOffset() != -1) {
                        group.addPosition((LinkedPosition)new ProposalPosition(document, pos.getOffset(), pos.getLength(), pos.getSequenceRank(), proposalImpls));
                    }
                    ++i;
                }
            }
            model.addGroup(group);
            added = true;
        }
        model.forceInstall();
        if (editor instanceof JavaEditor) {
            model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer((JavaEditor)editor));
        }
        if (added) {
            int cursorPosition;
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            LinkedProposalPositionGroup.PositionInformation endPosition = linkedProposalModel.getEndPosition();
            if (endPosition != null && endPosition.getOffset() != -1) {
                ui.setExitPosition(viewer, endPosition.getOffset() + endPosition.getLength(), 0, Integer.MAX_VALUE);
            } else if (!switchedEditor && (cursorPosition = viewer.getSelectedRange().x) != 0) {
                ui.setExitPosition(viewer, cursorPosition, 0, Integer.MAX_VALUE);
            }
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new LinkedModeExitPolicy());
            ui.enter();
            IRegion region = ui.getSelectedRegion();
            viewer.setSelectedRange(region.getOffset(), region.getLength());
            viewer.revealRange(region.getOffset(), region.getLength());
        }
    }

    private static class LinkedModeExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private LinkedModeExitPolicy() {
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == '=') {
                return new LinkedModeUI.ExitFlags(1, true);
            }
            return null;
        }
    }

    private static class LinkedPositionProposalImpl
    implements ICompletionProposalExtension2,
    IJavaCompletionProposal {
        private final LinkedProposalPositionGroup.Proposal fProposal;
        private final LinkedModeModel fLinkedPositionModel;

        public LinkedPositionProposalImpl(LinkedProposalPositionGroup.Proposal proposal, LinkedModeModel model) {
            this.fProposal = proposal;
            this.fLinkedPositionModel = model;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            IDocument doc = viewer.getDocument();
            LinkedPosition position = this.fLinkedPositionModel.findPosition(new LinkedPosition(doc, offset, 0));
            if (position != null) {
                try {
                    try {
                        TextEdit edit = this.fProposal.computeEdits(offset, position, trigger, stateMask, this.fLinkedPositionModel);
                        if (edit != null) {
                            edit.apply(position.getDocument(), 0);
                        }
                    }
                    catch (MalformedTreeException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, "Unexpected exception applying edit", (Throwable)e));
                    }
                    catch (BadLocationException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, "Unexpected exception applying edit", (Throwable)e));
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
        }

        public String getDisplayString() {
            return this.fProposal.getDisplayString();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }

        @Override
        public int getRelevance() {
            return this.fProposal.getRelevance();
        }

        public void apply(IDocument document) {
        }

        public String getAdditionalProposalInfo() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            String insert = this.getDisplayString();
            LinkedPosition pos = this.fLinkedPositionModel.findPosition(new LinkedPosition(document, offset, 0));
            int off = pos != null ? pos.getOffset() : Math.max(0, offset - insert.length());
            int length = offset - off;
            if (offset <= document.getLength()) {
                try {
                    String content = document.get(off, length);
                    if (insert.startsWith(content)) {
                        return true;
                    }
                }
                catch (BadLocationException e) {
                    JavaPlugin.log(e);
                }
            }
            return false;
        }
    }
}

