/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.jarimport.JarImportWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ModuleEncapsulationDetail;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewContainerDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.RootCPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class LibrariesWorkbookPage
extends BuildPathBasePage {
    private final ListDialogField<CPListElement> fClassPathList;
    private IJavaProject fCurrJProject;
    private final TreeListDialogField<CPListElement> fLibrariesList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private final int IDX_ADDJAR = 0;
    private final int IDX_ADDEXT = 1;
    private final int IDX_ADDVAR = 2;
    private final int IDX_ADDLIB = 3;
    private final int IDX_ADDFOL = 4;
    private final int IDX_ADDEXTFOL = 5;
    private final int IDX_EDIT = 7;
    private final int IDX_REMOVE = 8;
    private final int IDX_REPLACE = 10;
    private boolean dragDropEnabled;
    private Object draggedItemsLibrary;

    public LibrariesWorkbookPage(CheckedListDialogField<CPListElement> classPathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fClassPathList = classPathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[11];
        stringArray[0] = NewWizardMessages.LibrariesWorkbookPage_libraries_addjar_button;
        stringArray[1] = NewWizardMessages.LibrariesWorkbookPage_libraries_addextjar_button;
        stringArray[2] = NewWizardMessages.LibrariesWorkbookPage_libraries_addvariable_button;
        stringArray[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_addlibrary_button;
        stringArray[4] = NewWizardMessages.LibrariesWorkbookPage_libraries_addclassfolder_button;
        stringArray[5] = NewWizardMessages.LibrariesWorkbookPage_libraries_addextfolder_button;
        stringArray[7] = NewWizardMessages.LibrariesWorkbookPage_libraries_edit_button;
        stringArray[8] = NewWizardMessages.LibrariesWorkbookPage_libraries_remove_button;
        stringArray[10] = NewWizardMessages.LibrariesWorkbookPage_libraries_replace_button;
        String[] buttonLabels = stringArray;
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField<CPListElement>(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(NewWizardMessages.LibrariesWorkbookPage_libraries_label);
        this.fLibrariesList.enableButton(8, false);
        this.fLibrariesList.enableButton(7, false);
        this.fLibrariesList.enableButton(10, false);
        this.fLibrariesList.setViewerComparator(new CPListElementSorter());
    }

    @Override
    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        if (Display.getCurrent() != null) {
            this.updateLibrariesList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LibrariesWorkbookPage.this.updateLibrariesList();
                }
            });
        }
    }

    private void updateLibrariesList() {
        if (JavaModelUtil.is9OrHigher((IJavaProject)this.fCurrJProject)) {
            this.updateLibrariesListWithRootNode();
            return;
        }
        List<CPListElement> cpelements = this.fClassPathList.getElements();
        ArrayList<CPListElement> libelements = new ArrayList<CPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            CPListElement cpe = cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    private void updateLibrariesListWithRootNode() {
        RootCPListElement rootClasspath = new RootCPListElement(this.fCurrJProject, NewWizardMessages.PathRootWorkbookPage_classpath, false);
        RootCPListElement rootModulepath = new RootCPListElement(this.fCurrJProject, NewWizardMessages.PathRootWorkbookPage_modulepath, true);
        List<CPListElement> cpelements = this.fClassPathList.getElements();
        ArrayList<RootCPListElement> libelements = new ArrayList<RootCPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int size = this.fLibrariesList.getElements().size();
        int i = 0;
        while (i < nElements) {
            CPListElement cpe = cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                Object mod;
                if (size > 0) {
                    cpe = this.checkAndUpdateIfModularJRE(cpe);
                }
                if (cpe.getEntryKind() == 5 && cpe.getAttribute("module") == null && !this.isJREContainer(cpe.getPath())) {
                    cpe.updateExtraAttributeOfClasspathEntry();
                    cpe.setAttribute("module", null);
                }
                if ((mod = cpe.getAttribute("module")) == null) {
                    rootClasspath.addCPListElement(cpe);
                } else {
                    rootModulepath.addCPListElement(cpe);
                }
            }
            ++i;
        }
        libelements.add(rootModulepath);
        libelements.add(rootClasspath);
        this.fLibrariesList.setElements(libelements);
        this.fLibrariesList.enableButton(1, false);
        this.fLibrariesList.enableButton(4, false);
        this.fLibrariesList.enableButton(5, false);
        this.fLibrariesList.enableButton(0, false);
        this.fLibrariesList.enableButton(3, false);
        this.fLibrariesList.enableButton(2, false);
        if (!this.dragDropEnabled) {
            this.enableDragDropSupport();
        }
    }

    private CPListElement checkAndUpdateIfModularJRE(CPListElement cpe) {
        boolean modularJava = false;
        IVMInstall vmInstall = JavaRuntime.getVMInstall((IPath)cpe.getPath());
        if (vmInstall != null) {
            modularJava = JavaRuntime.isModularJava((IVMInstall)vmInstall);
        }
        if (modularJava) {
            cpe = CPListElement.create(cpe.getClasspathEntry(), true, this.fCurrJProject);
        }
        return cpe;
    }

    private void enableDragDropSupport() {
        this.dragDropEnabled = true;
        int ops = 2;
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        this.fLibrariesList.getTreeViewer().addDragSupport(ops, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)LibrariesWorkbookPage.this.fLibrariesList.getTreeViewer().getSelection();
                if (ssel == null || ssel.isEmpty()) {
                    event.doit = false;
                }
                if (ssel != null) {
                    Object[] ele;
                    Object[] objectArray = ele = ssel.toArray();
                    int n = ele.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean isJRE;
                        IVMInstall vmInstall;
                        IPath path;
                        CPListElement cpe;
                        Object element = objectArray[n2];
                        if (element instanceof RootCPListElement) {
                            event.doit = false;
                            break;
                        }
                        if (element instanceof CPListElement && (cpe = (CPListElement)element).getEntryKind() == 5 && (path = cpe.getPath()) != null && (vmInstall = JavaRuntime.getVMInstall((IPath)path)) != null && (isJRE = LibrariesWorkbookPage.this.isJREContainer(path))) {
                            event.doit = false;
                            break;
                        }
                        ++n2;
                    }
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)LibrariesWorkbookPage.this.fLibrariesList.getTreeViewer().getSelection();
                event.data = ssel.toArray();
                LibrariesWorkbookPage.this.draggedItemsLibrary = ssel.toArray();
            }

            public void dragFinished(DragSourceEvent event) {
                LibrariesWorkbookPage.this.draggedItemsLibrary = null;
            }
        });
        this.fLibrariesList.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.fLibrariesList.getTreeViewer()){

            public boolean performDrop(Object data) {
                Object[] objects;
                Object[] objectArray = objects = data == null ? (Object[])LibrariesWorkbookPage.this.draggedItemsLibrary : (Object[])data;
                if (objects == null) {
                    return false;
                }
                Object target = this.getCurrentTarget();
                if (target instanceof RootCPListElement) {
                    Object[] objectArray2 = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray2[n2];
                        if (!(object instanceof CPListElement)) {
                            return false;
                        }
                        if (object instanceof RootCPListElement) {
                            return false;
                        }
                        boolean contains = ((RootCPListElement)target).getChildren().contains(object);
                        if (contains) {
                            return false;
                        }
                        RootCPListElement rootNode = (RootCPListElement)target;
                        boolean isModular = rootNode.isModulePathRootNode();
                        RootCPListElement.RootNodeChange direction = RootCPListElement.RootNodeChange.fromOldAndNew(!isModular, isModular);
                        if (direction != RootCPListElement.RootNodeChange.NoChange) {
                            CPListElement cpe = (CPListElement)object;
                            if (cpe.getEntryKind() == 5 && isModular) {
                                IClasspathEntry entry = cpe.getClasspathEntry();
                                IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
                                boolean hasModAttr = false;
                                IClasspathAttribute[] iClasspathAttributeArray = extraAttributes;
                                int n3 = extraAttributes.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IClasspathAttribute attr = iClasspathAttributeArray[n4];
                                    if ("module".equals(attr.getName())) {
                                        hasModAttr = true;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (!hasModAttr) {
                                    cpe.updateExtraAttributeOfClasspathEntry();
                                }
                            }
                            LibrariesWorkbookPage.this.moveCPElementAcrossNode(LibrariesWorkbookPage.this.fLibrariesList, (CPListElement)object, direction);
                        }
                        ((CPListElement)object).setAttribute("module", isModular ? new ModuleEncapsulationDetail[]{} : null);
                        ++n2;
                    }
                    return true;
                }
                return false;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return target instanceof RootCPListElement;
            }
        });
    }

    private boolean isJREContainer(IPath path) {
        String[] segments;
        if (path == null) {
            return false;
        }
        String[] stringArray = segments = path.segments();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String seg = stringArray[n2];
            if (seg.equals(JavaRuntime.JRE_CONTAINER)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean hasRootNodes() {
        if (this.fLibrariesList == null) {
            return false;
        }
        if (this.fLibrariesList.getSize() == 0) {
            return false;
        }
        return this.fLibrariesList.getElement(0).isRootNodeForPath();
    }

    @Override
    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.setViewerComparator(new CPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openJarFileDialog(null);
                break;
            }
            case 1: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 2: {
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 3: {
                libentries = this.openContainerSelectionDialog(null);
                break;
            }
            case 4: {
                libentries = this.openClassFolderDialog(null);
                break;
            }
            case 5: {
                libentries = this.openExternalClassFolderDialog(null);
                break;
            }
            case 7: {
                this.editEntry();
                return;
            }
            case 8: {
                this.removeEntry();
                return;
            }
            case 10: {
                this.replaceJarFile();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List<CPListElement> cplist = this.fLibrariesList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                boolean contains = cplist.contains(curr);
                if (this.hasRootNodes()) {
                    contains = this.hasCurrentElement(cplist, curr);
                }
                if (!contains && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(curr));
                    curr.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(curr));
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty() && index == 4) {
                this.askForAddingExclusionPatternsDialog(elementsToAdd);
            }
            if (!this.hasRootNodes()) {
                this.fLibrariesList.addElements(elementsToAdd);
            } else {
                List<Object> selectedElements = this.fLibrariesList.getSelectedElements();
                List<CPListElement> elements = this.fLibrariesList.getElements();
                if (selectedElements.size() != 1) {
                    return;
                }
                this.fLibrariesList.removeAllElements();
                RootCPListElement selectedCPElement = (RootCPListElement)selectedElements.get(0);
                if (selectedCPElement.isClassPathRootNode()) {
                    for (CPListElement cpListElement : elementsToAdd) {
                        cpListElement.setAttribute("module", null);
                    }
                } else if (selectedCPElement.isModulePathRootNode()) {
                    for (CPListElement cpListElement : elementsToAdd) {
                        Object attribute = cpListElement.getAttribute("module");
                        if (attribute != null) continue;
                        cpListElement.setAttribute("module", new ModuleEncapsulationDetail[0]);
                    }
                }
                selectedCPElement.addCPListElement(elementsToAdd);
                this.fLibrariesList.setElements(elements);
                this.fLibrariesList.refresh();
                this.fLibrariesList.getTreeViewer().expandToLevel(2);
            }
            if (index == 3 || index == 2) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    private boolean hasCurrentElement(List<CPListElement> cplist, CPListElement curr) {
        for (CPListElement cpListElement : cplist) {
            boolean cont;
            if (!cpListElement.isRootNodeForPath() || !(cont = ((RootCPListElement)cpListElement).getChildren().contains(curr))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addElement(CPListElement element) {
        this.fLibrariesList.addElement(element);
        this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection((Object)element));
    }

    private void askForAddingExclusionPatternsDialog(List<CPListElement> newEntries) {
        HashSet<CPListElement> modified = new HashSet<CPListElement>();
        List<CPListElement> existing = this.fClassPathList.getElements();
        LibrariesWorkbookPage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), existing.toArray(new CPListElement[existing.size()]), modified);
        if (!modified.isEmpty()) {
            String title = NewWizardMessages.LibrariesWorkbookPage_exclusion_added_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField<CPListElement> field) {
        List<Object> selection = field.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField<CPListElement> field, KeyEvent event) {
        List<Object> selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void replaceJarFile() {
        IPackageFragmentRoot root = this.getSelectedPackageFragmentRoot();
        if (root != null) {
            JarImportWizard wizard = new JarImportWizard(false);
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)root));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.create();
            dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 520);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jdt.ui.jar_import_wizard_page_context");
            dialog.open();
        }
    }

    private IPackageFragmentRoot getSelectedPackageFragmentRoot() {
        IJavaProject project;
        CPListElement element;
        IClasspathEntry entry;
        Object object;
        List<Object> elements = this.fLibrariesList.getSelectedElements();
        if (elements.size() == 1 && (object = elements.get(0)) instanceof CPListElement && JarImportWizard.isValidClassPathEntry(entry = (element = (CPListElement)object).getClasspathEntry()) && (project = element.getJavaProject()) != null) {
            try {
                IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                int index = 0;
                while (index < roots.length) {
                    if (entry.equals(roots[index].getRawClasspathEntry())) {
                        return roots[index];
                    }
                    ++index;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        return null;
    }

    private void removeEntry() {
        List<Object> selElements = this.fLibrariesList.getSelectedElements();
        HashMap<CPListElement, HashSet<String>> containerEntriesToUpdate = new HashMap<CPListElement, HashSet<String>>();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                if (attrib.isBuiltIn()) {
                    IAccessRule[] value = null;
                    if (key.equals("accessrules")) {
                        value = new IAccessRule[]{};
                    }
                    attrib.setValue(value);
                } else {
                    this.removeCustomAttribute(attrib);
                }
                selElements.remove(i);
                if (attrib.getParent().getParentContainer() instanceof CPListElement) {
                    CPListElement containerEntry = attrib.getParent();
                    HashSet<String> changedAttributes = (HashSet<String>)containerEntriesToUpdate.get(containerEntry);
                    if (changedAttributes == null) {
                        changedAttributes = new HashSet<String>();
                        containerEntriesToUpdate.put(containerEntry, changedAttributes);
                    }
                    changedAttributes.add(key);
                }
            } else if (elem instanceof ModuleEncapsulationDetail) {
                this.removeEncapsulationDetail((ModuleEncapsulationDetail)elem);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else if (this.hasRootNodes()) {
            List<CPListElement> elements = this.fLibrariesList.getElements();
            for (CPListElement cpListElement : elements) {
                ((RootCPListElement)cpListElement).getChildren().removeAll(selElements);
            }
            this.fLibrariesList.getTreeViewer().remove(selElements.toArray());
            this.fLibrariesList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
        for (Map.Entry entry : containerEntriesToUpdate.entrySet()) {
            CPListElement curr = (CPListElement)entry.getKey();
            HashSet attribs = (HashSet)entry.getValue();
            String[] changedAttributes = attribs.toArray(new String[attribs.size()]);
            IClasspathEntry changedEntry = curr.getClasspathEntry();
            this.updateContainerEntry(changedEntry, changedAttributes, this.fCurrJProject, ((CPListElement)curr.getParentContainer()).getPath());
        }
    }

    private boolean canRemove(List<?> selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                if ("module".equals(attrib.getKey())) {
                    return false;
                }
                if (attrib.isNonModifiable()) {
                    return false;
                }
                if (attrib.isBuiltIn()) {
                    if (attrib.getParent().isInContainer(JavaRuntime.JRE_CONTAINER) && "accessrules".equals(attrib.getKey())) {
                        return false;
                    }
                    if (attrib.getKey().equals("accessrules")) {
                        return ((IAccessRule[])attrib.getValue()).length > 0;
                    }
                    if (attrib.getValue() == null) {
                        return false;
                    }
                } else if (!this.canRemoveCustomAttribute(attrib)) {
                    return false;
                }
            } else if (elem instanceof CPListElement) {
                CPListElement curr = (CPListElement)elem;
                if (curr.isRootNodeForPath()) {
                    return false;
                }
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return elem instanceof ModuleEncapsulationDetail;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List<Object> selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        boolean canEdit = false;
        if (this.hasRootNodes()) {
            boolean bl = canEdit = ((RootCPListElement)this.fLibrariesList.getElement(0)).getChildren().indexOf(elem) != -1 || ((RootCPListElement)this.fLibrariesList.getElement(1)).getChildren().indexOf(elem) != -1;
        }
        if (canEdit || this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        CPListElement selElement = elem.getParent();
        CPListElementAttribute[] allAttributes = selElement.getAllAttributes();
        boolean canEditEncoding = false;
        int i = 0;
        while (i < allAttributes.length) {
            if ("source_encoding".equals(allAttributes[i].getKey())) {
                canEditEncoding = !allAttributes[i].isNonModifiable() && !allAttributes[i].isNotSupported();
            }
            ++i;
        }
        if (key.equals("sourcepath")) {
            IClasspathEntry result = BuildPathDialogAccess.configureSourceAttachment(this.getShell(), selElement.getClasspathEntry(), canEditEncoding);
            if (result != null) {
                selElement.setAttribute("sourcepath", result.getSourceAttachmentPath());
                selElement.setAttribute("source_encoding", SourceAttachmentBlock.getSourceAttachmentEncoding(result));
                String[] changedAttributes = new String[]{"sourcepath", "source_encoding"};
                this.attributeUpdated(selElement, changedAttributes);
                this.fLibrariesList.refresh(elem);
                this.fLibrariesList.update(selElement);
                this.fClassPathList.refresh();
                this.updateEnabledState();
            }
        } else if (key.equals("accessrules")) {
            AccessRulesDialog dialog = new AccessRulesDialog(this.getShell(), selElement, this.fCurrJProject, this.fPageContainer != null);
            int res = dialog.open();
            if (res == 0 || res == 10) {
                selElement.setAttribute("accessrules", dialog.getAccessRules());
                String[] changedAttributes = new String[]{"accessrules"};
                this.attributeUpdated(selElement, changedAttributes);
                this.fLibrariesList.refresh(elem);
                this.fClassPathList.dialogFieldChanged();
                this.updateEnabledState();
                if (res == 10) {
                    dialog.performPageSwitch(this.fPageContainer);
                }
            }
        } else if (key.equals("module")) {
            boolean wasModular;
            boolean bl = wasModular = selElement.getAttribute("module") != null;
            if (this.showModuleDialog(this.getShell(), elem)) {
                boolean isModular;
                RootCPListElement.RootNodeChange direction;
                String[] changedAttributes = new String[]{"module"};
                this.attributeUpdated(selElement, changedAttributes);
                if (this.hasRootNodes() && (direction = RootCPListElement.RootNodeChange.fromOldAndNew(wasModular, isModular = selElement.getAttribute("module") != null)) != RootCPListElement.RootNodeChange.NoChange) {
                    this.moveCPElementAcrossNode(this.fLibrariesList, selElement, direction);
                }
                this.fLibrariesList.refresh(elem);
                this.fClassPathList.dialogFieldChanged();
                this.updateEnabledState();
            }
        } else if (this.editCustomAttribute(this.getShell(), elem)) {
            String[] changedAttributes = new String[]{key};
            this.attributeUpdated(selElement, changedAttributes);
            this.fLibrariesList.refresh(elem);
            this.fClassPathList.dialogFieldChanged();
            this.updateEnabledState();
            if (key.equals("annotationpath") && this.fCurrJProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", true).equals("disabled")) {
                MessageDialog messageDialog = new MessageDialog(this.getShell(), NewWizardMessages.LibrariesWorkbookPage_externalAnnotationNeedsNullAnnotationEnabled_title, null, NewWizardMessages.LibrariesWorkbookPage_externalAnnotationNeedsNullAnnotationEnabled_message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                messageDialog.open();
            }
        }
    }

    private void attributeUpdated(CPListElement selElement, String[] changedAttributes) {
        Object parentContainer = selElement.getParentContainer();
        if (parentContainer instanceof CPListElement) {
            IClasspathEntry updatedEntry = selElement.getClasspathEntry();
            this.updateContainerEntry(updatedEntry, changedAttributes, this.fCurrJProject, ((CPListElement)parentContainer).getPath());
        }
    }

    private void updateContainerEntry(final IClasspathEntry newEntry, final String[] changedAttributes, final IJavaProject jproject, final IPath containerPath) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BuildPathSupport.modifyClasspathEntry(null, newEntry, changedAttributes, jproject, containerPath, false, monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 5: {
                res = this.openContainerSelectionDialog(elem);
                break;
            }
            case 1: {
                IResource resource = elem.getResource();
                if (resource == null) {
                    File file = elem.getPath().toFile();
                    if (file.isDirectory()) {
                        res = this.openExternalClassFolderDialog(elem);
                        break;
                    }
                    res = this.openExtJarFileDialog(elem);
                    break;
                }
                if (resource.getType() == 2) {
                    if (resource.exists()) {
                        res = this.openClassFolderDialog(elem);
                        break;
                    }
                    res = this.openNewClassFolderDialog(elem);
                    break;
                }
                if (resource.getType() != 1) break;
                res = this.openJarFileDialog(elem);
                break;
            }
            case 4: {
                res = this.openVariableSelectionDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            CPListElement curr = res[0];
            Object attrib = curr.getAttribute("module");
            curr.setExported(elem.isExported());
            curr.setAttributesFromExisting(elem);
            if (attrib != null) {
                curr.setAttribute("module", attrib);
            }
            if (this.hasRootNodes()) {
                int i = 0;
                while (i < this.fLibrariesList.getElements().size()) {
                    CPListElement cpe = this.fLibrariesList.getElement(i);
                    if (cpe.isRootNodeForPath() && ((RootCPListElement)cpe).getChildren().contains(elem)) {
                        int j = 0;
                        while (j < ((RootCPListElement)cpe).getChildren().size()) {
                            Object obj = ((RootCPListElement)cpe).getChildren().get(j);
                            if (obj.equals(elem)) {
                                ((RootCPListElement)cpe).getChildren().set(j, curr);
                                RootCPListElement.RootNodeChange changeNodeDirection = this.doesElementNeedNodeChange(elem, curr);
                                if (changeNodeDirection != RootCPListElement.RootNodeChange.NoChange) {
                                    ModuleEncapsulationDetail[] value;
                                    this.moveCPElementAcrossNode(this.fLibrariesList, curr, changeNodeDirection);
                                    CPListElementAttribute moduleAttr = curr.findAttributeElement("module");
                                    ModuleEncapsulationDetail[] moduleEncapsulationDetailArray = value = changeNodeDirection == RootCPListElement.RootNodeChange.ToModulepath ? new ModuleEncapsulationDetail[]{} : null;
                                    if (moduleAttr != null) {
                                        moduleAttr.setValue(value);
                                    } else {
                                        curr.setAttribute("module", value);
                                    }
                                }
                                this.fLibrariesList.dialogFieldChanged();
                                this.fLibrariesList.refresh();
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                this.fLibrariesList.replaceElement(elem, curr);
            }
            if (elem.getEntryKind() == 4) {
                this.fLibrariesList.refresh();
            }
        }
    }

    private RootCPListElement.RootNodeChange doesElementNeedNodeChange(CPListElement elem, CPListElement curr) {
        IVMInstall vm2;
        if (elem.getClasspathEntry().getEntryKind() != 5) {
            return RootCPListElement.RootNodeChange.NoChange;
        }
        if (curr.getClasspathEntry().getEntryKind() != 5) {
            return RootCPListElement.RootNodeChange.NoChange;
        }
        String v1 = null;
        String v2 = null;
        IVMInstall vm1 = JavaRuntime.getVMInstall((IPath)elem.getPath());
        if (vm1 instanceof AbstractVMInstall) {
            v1 = ((AbstractVMInstall)vm1).getJavaVersion();
        }
        if ((vm2 = JavaRuntime.getVMInstall((IPath)curr.getPath())) instanceof AbstractVMInstall) {
            v2 = ((AbstractVMInstall)vm2).getJavaVersion();
        }
        if (v1 != null && v2 != null) {
            boolean mod1 = JavaModelUtil.is9OrHigher((String)v1);
            boolean mod2 = JavaModelUtil.is9OrHigher((String)v2);
            if (mod1 && mod2) {
                return RootCPListElement.RootNodeChange.NoChange;
            }
            if (!mod1 && !mod2) {
                return RootCPListElement.RootNodeChange.NoChange;
            }
            if (mod1 && !mod2) {
                return RootCPListElement.RootNodeChange.ToClasspath;
            }
            if (!mod1 && mod2) {
                return RootCPListElement.RootNodeChange.ToModulepath;
            }
        }
        return RootCPListElement.RootNodeChange.NoChange;
    }

    private void libaryPageSelectionChanged(DialogField field) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        List<Object> selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(7, this.canEdit(selElements));
        this.fLibrariesList.enableButton(8, this.canRemove(selElements));
        this.fLibrariesList.enableButton(10, this.getSelectedPackageFragmentRoot() != null);
        boolean addEnabled = this.containsOnlyTopLevelEntries(selElements);
        this.fLibrariesList.enableButton(1, addEnabled);
        this.fLibrariesList.enableButton(4, addEnabled);
        this.fLibrariesList.enableButton(5, addEnabled);
        this.fLibrariesList.enableButton(0, addEnabled);
        this.fLibrariesList.enableButton(3, addEnabled);
        this.fLibrariesList.enableButton(2, addEnabled);
    }

    @Override
    protected boolean containsOnlyTopLevelEntries(List<?> selElements) {
        if (!this.hasRootNodes()) {
            return super.containsOnlyTopLevelEntries(selElements);
        }
        if (selElements.size() == 0 || selElements.size() > 1) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElement) {
                if (!((CPListElement)elem).isRootNodeForPath()) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List<?> selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            CPListElement curr = (CPListElement)elem;
            if (((CPListElement)elem).isRootNodeForPath()) {
                return false;
            }
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        if (elem instanceof CPListElementAttribute) {
            CPListElementAttribute attrib = (CPListElementAttribute)elem;
            if (attrib.isNonModifiable()) {
                return false;
            }
            if (!attrib.isBuiltIn()) {
                return this.canEditCustomAttribute(attrib);
            }
            if (this.hasRootNodes() && attrib.getKey().equals("module")) {
                return true;
            }
            return true;
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List<CPListElement> projelements = this.fLibrariesList.getElements();
        ArrayList<CPListElement> flattenedProjElements = new ArrayList<CPListElement>();
        int i = 0;
        while (i < projelements.size()) {
            CPListElement ele = projelements.get(i);
            if (ele.isRootNodeForPath()) {
                ArrayList<Object> children = ((RootCPListElement)ele).getChildren();
                for (Object object : children) {
                    if (!(object instanceof CPListElement)) continue;
                    flattenedProjElements.add((CPListElement)object);
                }
            } else {
                flattenedProjElements.add(ele);
            }
            ++i;
        }
        List<CPListElement> cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i2 = nEntries - 1;
        while (i2 >= 0) {
            CPListElement cpe = cpelements.get(i2);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !flattenedProjElements.remove(cpe)) {
                cpelements.remove(i2);
                lastRemovePos = i2;
            }
            --i2;
        }
        cpelements.addAll(lastRemovePos, flattenedProjElements);
        if (lastRemovePos != nEntries || !flattenedProjElements.isEmpty()) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement[] openNewClassFolderDialog(CPListElement existing) {
        String title = existing == null ? NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_new_title : NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_edit_title;
        IProject currProject = this.fCurrJProject.getProject();
        NewContainerDialog dialog = new NewContainerDialog(this.getShell(), title, currProject, this.getUsedContainers(existing), existing);
        IPath projpath = currProject.getFullPath();
        dialog.setMessage(Messages.format(NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_description, BasicElementLabels.getPathLabel((IPath)projpath, (boolean)false)));
        if (dialog.open() == 0) {
            IFolder folder = dialog.getFolder();
            return new CPListElement[]{this.newCPLibraryElement((IResource)folder)};
        }
        return null;
    }

    private CPListElement[] openClassFolderDialog(CPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseClassFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(existing))) != null) {
            IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = root.findMember(curr);
                if (resource instanceof IContainer) {
                    CPListElement newCPLibraryElement = this.newCPLibraryElement(resource);
                    newCPLibraryElement.setModuleAttributeIf9OrHigher(this.fCurrJProject);
                    res.add(newCPLibraryElement);
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openJarFileDialog(CPListElement existing) {
        IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseJAREntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedJARFiles(existing));
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = root.findMember(curr);
                    if (resource instanceof IFile) {
                        CPListElement newCPLibraryElement = this.newCPLibraryElement(resource);
                        newCPLibraryElement.setModuleAttributeIf9OrHigher(this.fCurrJProject);
                        res.add(newCPLibraryElement);
                    }
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildPathDialogAccess.configureJAREntry(this.getShell(), existing.getPath(), this.getUsedJARFiles(existing));
            if (configured != null && (resource = root.findMember(configured)) instanceof IFile) {
                return new CPListElement[]{this.newCPLibraryElement(resource)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        if (this.fCurrJProject.exists()) {
            try {
                IPath outputLocation = this.fCurrJProject.getOutputLocation();
                if (outputLocation != null && outputLocation.segmentCount() > 1) {
                    res.add(outputLocation);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e.getStatus());
            }
        }
        List<CPListElement> cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getUsedJARFiles(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List<CPListElement> cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    CPListElement cpListElement = new CPListElement(this.fCurrJProject, 1, selected[i], null);
                    cpListElement.setModuleAttributeIf9OrHigher(this.fCurrJProject);
                    res.add(cpListElement);
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPackageFragmentRoot[] roots = existing.getJavaProject().findPackageFragmentRoots(existing.getClasspathEntry());
            IPath path = roots.length == 1 ? roots[0].getPath() : existing.getPath();
            IPath configured = BuildPathDialogAccess.configureExternalJAREntry(this.getShell(), path);
            if (configured != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, configured, null)};
            }
        }
        return null;
    }

    private CPListElement[] openExternalClassFolderDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalClassFolderEntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    CPListElement cpListElement = new CPListElement(this.fCurrJProject, 1, selected[i], null);
                    cpListElement.setModuleAttributeIf9OrHigher(this.fCurrJProject);
                    res.add(cpListElement);
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalClassFolderEntries(this.getShell(), existing.getPath());
            if (configured != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, configured, null)};
            }
        }
        return null;
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement existing) {
        List<CPListElement> existingElements = this.fLibrariesList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            CPListElement elem = existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = BuildPathDialogAccess.chooseVariableEntries(this.getShell(), existingPathsArray);
            if (paths != null) {
                ArrayList<CPListElement> result = new ArrayList<CPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    IPath path = paths[i2];
                    CPListElement elem = this.createCPVariableElement(path);
                    if (!existingElements.contains(elem)) {
                        elem.setModuleAttributeIf9OrHigher(this.fCurrJProject);
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new CPListElement[result.size()]);
            }
        } else {
            IPath path = BuildPathDialogAccess.configureVariableEntry(this.getShell(), existing.getPath(), existingPathsArray);
            if (path != null) {
                return new CPListElement[]{this.createCPVariableElement(path)};
            }
        }
        return null;
    }

    private CPListElement createCPVariableElement(IPath path) {
        CPListElement elem = new CPListElement(this.fCurrJProject, 4, path, null);
        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
        elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
        return elem;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement existing) {
        Object obj;
        boolean shouldAddModule = false;
        if (this.getSelection().size() == 1 && (obj = this.getSelection().get(0)) instanceof RootCPListElement) {
            shouldAddModule = ((RootCPListElement)obj).isModulePathRootNode();
        }
        if (existing == null) {
            IClasspathEntry[] created = BuildPathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement[] res = new CPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = CPListElement.create(created[i], true, this.fCurrJProject);
                    if (res[i].getClasspathEntry().getEntryKind() == 5) {
                        if (!this.isJREContainer(res[i].getPath())) {
                            res[i].updateExtraAttributeOfClasspathEntry();
                        }
                        if (!shouldAddModule) {
                            res[i].setAttribute("module", null);
                        }
                    }
                    ++i;
                }
                return res;
            }
        } else {
            IClasspathEntry existingEntry = existing.getClasspathEntry();
            IClasspathEntry created = BuildPathDialogAccess.configureContainerEntry(this.getShell(), existingEntry, this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement elem = new CPListElement(null, this.fCurrJProject, created, 5, created.getPath(), null, !created.equals(existingEntry), null, null);
                IVMInstall vmInstall = JavaRuntime.getVMInstall((IPath)created.getPath());
                if (vmInstall != null && JavaRuntime.isModularJava((IVMInstall)vmInstall)) {
                    elem.updateExtraAttributeOfClasspathEntry();
                }
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] currEntries = new IClasspathEntry[this.fClassPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = this.fClassPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    @Override
    public List<?> getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    @Override
    public void setSelection(List<?> selElements, boolean expand) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fLibrariesList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    @Override
    public void setFocus() {
        this.fLibrariesList.setFocus();
    }

    private class LibrariesAdapter
    extends BuildPathBasePage.CPListAdapter {
        private LibrariesAdapter() {
            super(LibrariesWorkbookPage.this);
        }

        @Override
        public void customButtonPressed(TreeListDialogField<CPListElement> field, int index) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField<CPListElement> field) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField<CPListElement> field) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField<CPListElement> field, KeyEvent event) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField<CPListElement> field, Object element) {
            CPListElementAttribute attribute;
            if (element instanceof CPListElementAttribute && "accessrules".equals((attribute = (CPListElementAttribute)element).getKey())) {
                return (IAccessRule[])attribute.getValue();
            }
            return super.getChildren(field, element);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }
}

