/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=false, usage="usage_ServerSideBackendForJgitFetch")
class UploadPack
extends TextBuiltin {
    @Option(name="--timeout", metaVar="metaVar_seconds", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Argument(index=0, required=true, metaVar="metaVar_directory", usage="usage_RepositoryToReadFrom")
    File srcGitdir;

    UploadPack() {
    }

    @Override
    protected final boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() throws Exception {
        try {
            RepositoryCache.FileKey key = RepositoryCache.FileKey.lenient((File)this.srcGitdir, (FS)FS.DETECTED);
            this.db = key.open(true);
        }
        catch (RepositoryNotFoundException notFound) {
            throw UploadPack.die(MessageFormat.format(CLIText.get().notAGitRepository, this.srcGitdir.getPath()));
        }
        org.eclipse.jgit.transport.UploadPack up = new org.eclipse.jgit.transport.UploadPack(this.db);
        if (0 <= this.timeout) {
            up.setTimeout(this.timeout);
        }
        up.upload(this.ins, this.outs, this.errs);
    }
}

