/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaBaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.AbstractJavaConverter;
import org.eclipse.jpt.jpa.core.resource.java.BaseEnumeratedAnnotation;

public class GenericJavaBaseEnumeratedConverter
extends AbstractJavaConverter
implements JavaBaseEnumeratedConverter {
    protected final BaseEnumeratedAnnotation enumeratedAnnotation;
    protected EnumType specifiedEnumType;
    protected EnumType defaultEnumType;

    public GenericJavaBaseEnumeratedConverter(Converter.ParentAdapter<JavaAttributeMapping> parentAdapter, BaseEnumeratedAnnotation enumeratedAnnotation) {
        super(parentAdapter);
        this.enumeratedAnnotation = enumeratedAnnotation;
        this.specifiedEnumType = this.buildSpecifiedEnumType();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedEnumType_(this.buildSpecifiedEnumType());
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultEnumType(this.buildDefaultEnumType());
    }

    @Override
    public EnumType getEnumType() {
        return this.specifiedEnumType != null ? this.specifiedEnumType : this.defaultEnumType;
    }

    @Override
    public EnumType getSpecifiedEnumType() {
        return this.specifiedEnumType;
    }

    @Override
    public void setSpecifiedEnumType(EnumType enumType) {
        this.enumeratedAnnotation.setValue(EnumType.toJavaResourceModel(enumType));
        this.setSpecifiedEnumType_(enumType);
    }

    protected void setSpecifiedEnumType_(EnumType enumType) {
        EnumType old = this.specifiedEnumType;
        this.specifiedEnumType = enumType;
        this.firePropertyChanged("specifiedEnumType", (Object)old, (Object)enumType);
    }

    protected EnumType buildSpecifiedEnumType() {
        return EnumType.fromJavaResourceModel(this.enumeratedAnnotation.getValue());
    }

    @Override
    public EnumType getDefaultEnumType() {
        return this.defaultEnumType;
    }

    protected void setDefaultEnumType(EnumType enumType) {
        EnumType old = this.defaultEnumType;
        this.defaultEnumType = enumType;
        this.firePropertyChanged("defaultEnumType", (Object)old, (Object)enumType);
    }

    protected EnumType buildDefaultEnumType() {
        return DEFAULT_ENUM_TYPE;
    }

    @Override
    public Class<BaseEnumeratedConverter> getConverterType() {
        return BaseEnumeratedConverter.class;
    }

    @Override
    public BaseEnumeratedAnnotation getConverterAnnotation() {
        return this.enumeratedAnnotation;
    }
}

