/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentExportDataModelProperties;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.FlatComponentArchiver;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ComponentExportOperation
extends AbstractDataModelOperation {
    protected IProgressMonitor progressMonitor;
    private IVirtualComponent component;
    private IPath destinationPath;
    private boolean exportSource = false;
    public static String[] DOT_FILE_NAMES = new String[]{".project", ".classpath", ".cvsignore"};
    public static String[] DOT_SOURCE_FILES = new String[]{".java", ".sqlj"};
    protected final int REFRESH_WORK = 100;
    protected final int JAVA_BUILDER_WORK = 100;
    protected final int EXPORT_WORK = 1000;
    protected final int CLOSE_WORK = 10;
    protected final int SINGLE_PARTICIPANT_WORK = 200;

    public ComponentExportOperation() {
    }

    public ComponentExportOperation(IDataModel model) {
        super(model);
    }

    protected int computeTotalWork() {
        int totalWork = 100;
        if (this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
            totalWork += 100;
        }
        totalWork += 1010;
        IDataModel dm = this.getDataModel();
        if (dm.getProperty("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME") == Boolean.TRUE) {
            List extensions = (List)dm.getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS");
            totalWork += extensions.size() * 200;
        }
        return totalWork;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.setComponent((IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT"));
        this.setDestinationPath((IPath)new Path(this.model.getStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION")));
        this.setExportSource(this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES"));
        try {
            monitor.beginTask(ProjectSupportResourceHandler.getString(ProjectSupportResourceHandler.Exporting_archive, new Object[]{this.getDestinationPath().lastSegment()}), this.computeTotalWork());
            this.setProgressMonitor(monitor);
            try {
                this.component.getProject().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
                    IVirtualReference[] refs = this.component.getReferences();
                    int work = 100 / (refs.length + 1);
                    this.runNecessaryBuilders(this.component, (IProgressMonitor)new SubProgressMonitor(monitor, work));
                    int i = 0;
                    while (i < refs.length) {
                        IVirtualComponent refComp = refs[i].getReferencedComponent();
                        this.runNecessaryBuilders(refComp, (IProgressMonitor)new SubProgressMonitor(monitor, work));
                        ++i;
                    }
                }
                this.export();
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause().getCause() instanceof FlatComponentArchiver.UnderlyingFileNotFoundException) {
                    J2EEPlugin.logWarning("Refreshing referenced projects before trying to export again the project " + this.component.getDeployedName());
                    try {
                        this.refreshChildModules(this.component);
                        this.export();
                    }
                    catch (Exception exceptionWhileRetry) {
                        throw new ExecutionException(String.valueOf(EJBArchiveOpsResourceHandler.Error_exporting__UI_) + this.getDestinationPath(), (Throwable)exceptionWhileRetry);
                    }
                }
                throw new ExecutionException(String.valueOf(EJBArchiveOpsResourceHandler.Error_exporting__UI_) + this.getDestinationPath(), (Throwable)e);
            }
            IDataModel dm = this.getDataModel();
            if (dm.getProperty("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME") == Boolean.TRUE) {
                for (IJ2EEComponentExportDataModelProperties.IArchiveExportParticipantData extData : (List)dm.getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS")) {
                    IDataModelOperation op = extData.getParticipant().createOperation(extData.getDataModel());
                    op.execute(null, null);
                    monitor.worked(200);
                }
            }
        }
        finally {
            monitor.done();
        }
        return OK_STATUS;
    }

    public void export() throws ArchiveSaveFailureException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.progressMonitor, 1000);
        try {
            File writeFile = this.getDestinationPath().toFile();
            if (writeFile.exists()) {
                writeFile.delete();
            }
            File aFile = this.getDestinationPath().toFile();
            ArchiveUtil.checkWriteable((File)aFile);
            boolean fileExisted = aFile.exists();
            FlatComponentArchiver archiver = null;
            try {
                File destinationFile = fileExisted ? ArchiveUtil.createTempFile((String)this.getDestinationPath().toOSString(), (File)aFile.getCanonicalFile().getParentFile()) : aFile;
                OutputStream out = this.createOutputStream(destinationFile);
                archiver = this.createFlatComponentArchiver(out);
                subMonitor.beginTask(NLS.bind((String)CommonArchiveResourceHandler.ArchiveFactoryImpl_Saving_archive_to_0_, (Object)this.getDestinationPath().toOSString()), 200);
                archiver.saveArchive();
                subMonitor.worked(198);
                archiver.close();
                if (fileExisted) {
                    ArchiveUtil.cleanupAfterTempSave((String)this.getDestinationPath().toOSString(), (File)aFile, (File)destinationFile);
                }
                subMonitor.worked(2);
            }
            catch (IOException e) {
                throw new ArchiveSaveFailureException((Throwable)e);
            }
            catch (ArchiveSaveFailureException failure) {
                try {
                    archiver.close();
                }
                catch (IOException iOException) {}
                if (!fileExisted) {
                    aFile.delete();
                }
                throw failure;
            }
        }
        finally {
            subMonitor.done();
        }
    }

    protected OutputStream createOutputStream(File destinationFile) throws IOException, FileNotFoundException {
        if (destinationFile.exists() && destinationFile.isDirectory()) {
            throw new IOException(NLS.bind((String)CommonArchiveResourceHandler.ArchiveFactoryImpl_The_specified_file_0_exists_and_, (Object)destinationFile.getAbsolutePath()));
        }
        File parent = destinationFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(destinationFile);
        return out;
    }

    protected FlatComponentArchiver createFlatComponentArchiver(OutputStream out) {
        return new FlatComponentArchiver(this.getComponent(), out, this.getParticipants());
    }

    protected void setProgressMonitor(IProgressMonitor newProgressMonitor) {
        this.progressMonitor = newProgressMonitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private void setComponent(IVirtualComponent newComponent) {
        this.component = newComponent;
    }

    protected IVirtualComponent getComponent() {
        if (this.component == null) {
            this.component = (IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
        }
        return this.component;
    }

    protected IPath getDestinationPath() {
        return this.destinationPath;
    }

    protected void setDestinationPath(IPath newDestinationPath) {
        this.destinationPath = newDestinationPath;
    }

    protected boolean isExportSource() {
        return this.exportSource;
    }

    protected void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    protected void runNecessaryBuilders(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        try {
            IProject project;
            IProjectDescription description;
            ICommand javaBuilder;
            monitor.beginTask(null, 100);
            if (!component.isBinary() && (javaBuilder = this.getJavaCommand(description = (project = component.getProject()).getDescription())) != null) {
                project.build(10, "org.eclipse.jdt.core.javabuilder", javaBuilder.getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public ISchedulingRule getSchedulingRule() {
        Set projs = this.gatherDependentProjects(this.getComponent(), new HashSet());
        ISchedulingRule combinedRule = null;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        for (IProject proj : projs) {
            ISchedulingRule rule = ruleFactory.createRule((IResource)proj);
            combinedRule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)combinedRule);
        }
        combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.buildRule(), combinedRule);
        return combinedRule;
    }

    protected List<IFlattenParticipant> getParticipants() {
        return Collections.EMPTY_LIST;
    }

    protected String[] getFilteredExtensions() {
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.addAll(Arrays.asList(DOT_FILE_NAMES));
        if (!this.isExportSource()) {
            excludeList.addAll(Arrays.asList(DOT_SOURCE_FILES));
        }
        return excludeList.toArray(new String[excludeList.size()]);
    }

    private Set gatherDependentProjects(IVirtualComponent comp, Set projs) {
        if (!projs.contains(comp.getProject())) {
            projs.add(comp.getProject());
            IVirtualReference[] refs = comp.getReferences();
            int i = 0;
            while (i < refs.length) {
                IVirtualReference refComp = refs[i];
                projs.addAll(this.gatherDependentProjects(refComp.getReferencedComponent(), projs));
                ++i;
            }
        }
        return projs;
    }

    private void refreshProject(IVirtualComponent refComp) throws CoreException {
        if (!this.component.isBinary()) {
            IProject project = refComp.getProject();
            project.refreshLocal(2, null);
        }
    }

    private void refreshChildModules(IVirtualComponent component) throws CoreException {
        IVirtualReference[] refs = component.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualComponent refComp = refs[i].getReferencedComponent();
            this.refreshProject(refComp);
            ++i;
        }
    }
}

