/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.properties.extension;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

public class FeatureFullDescription {
    private String featureName;
    private String className;
    private String packageName;

    public FeatureFullDescription(String featureName, String className, String packageName) {
        this.featureName = featureName;
        this.className = className;
        this.packageName = packageName;
    }

    public FeatureFullDescription(Object eObject, IItemPropertyDescriptor propertyDescriptor) {
        if (!(eObject instanceof EObject)) {
            throw new ClassCastException("object [ " + eObject.toString() + "] is not an EObject");
        }
        this.featureName = propertyDescriptor.getId(eObject);
        this.className = ((EObject)eObject).eClass().getName();
        this.packageName = ((EObject)eObject).eClass().getEPackage().getNsURI();
    }

    public FeatureFullDescription(Object eObject, String featureName) {
        this.featureName = featureName;
        this.className = ((EObject)eObject).eClass().getName();
        this.packageName = ((EObject)eObject).eClass().getEPackage().getNsURI();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeatureFullDescription)) {
            return false;
        }
        FeatureFullDescription dest = (FeatureFullDescription)o;
        return dest.className == this.className && dest.packageName == this.packageName && dest.featureName == this.featureName;
    }

    public int hashCode() {
        return new String(String.valueOf(this.packageName) + this.className + this.featureName).hashCode();
    }

    public boolean isFeatureFromSuperclass(FeatureFullDescription baseFeature) {
        EPackage featurePackage;
        EClass baseFeatureEClass;
        EClass thisFeatureEClass;
        block3: {
            thisFeatureEClass = null;
            baseFeatureEClass = null;
            try {
                featurePackage = EPackage.Registry.INSTANCE.getEPackage(this.packageName);
                if (featurePackage != null) break block3;
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        thisFeatureEClass = (EClass)featurePackage.getEClassifier(this.className);
        baseFeatureEClass = (EClass)EPackage.Registry.INSTANCE.getEPackage(baseFeature.getPackageName()).getEClassifier(baseFeature.getClassName());
        return baseFeatureEClass.isSuperTypeOf(thisFeatureEClass) && this.featureName.equals(baseFeature.getFeatureName());
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

