/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.internal.konekimigration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.internal.Activator;
import org.eclipse.ldt.core.internal.buildpath.LuaExecutionEnvironmentManager;

public final class KonekiMigrationUtil {
    private static final Object KONEKI_CONTAINER_PATH_START = "org.eclipse.koneki.ldt.ExecutionEnvironmentContainer";

    private KonekiMigrationUtil() {
    }

    public static boolean isKonekiProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.koneki.ldt.nature");
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
            return false;
        }
    }

    public static boolean isValidKonekiExecutionEnvironmentBuildPath(IPath eePath) {
        if (eePath == null) {
            return false;
        }
        String[] segments = eePath.segments();
        return segments.length == 3 && KONEKI_CONTAINER_PATH_START.equals(segments[0]);
    }

    public static LuaExecutionEnvironment getKonekiExecutionEnvironment(IProject project) {
        try {
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            IBuildpathEntry[] rawBuildpath = scriptProject.getRawBuildpath();
            int i = 0;
            while (i < rawBuildpath.length) {
                Pattern p;
                Matcher m;
                IPath konekiPath = rawBuildpath[i].getPath();
                if (KonekiMigrationUtil.isValidKonekiExecutionEnvironmentBuildPath(konekiPath) && (m = (p = Pattern.compile("org\\.eclipse\\.koneki\\.ldt\\.ExecutionEnvironmentContainer/(.*)/(.*)")).matcher(konekiPath.toString())).find()) {
                    return LuaExecutionEnvironmentManager.getAvailableExecutionEnvironment(m.group(1), m.group(2));
                }
                ++i;
            }
        }
        catch (ModelException e) {
            Activator.logWarning("unable to get koneki buildpath for project", e);
        }
        catch (CoreException e) {
            Activator.logWarning("unable to ExecutionEnvironment for project", e);
        }
        return null;
    }
}

