/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.Messages;
import org.eclipse.libra.warproducts.core.WARProductUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.w3c.dom.Element;

public class WARProductExportOperation
extends FeatureExportOperation {
    private static final String STATUS_MESSAGE = "!MESSAGE";
    private static final String STATUS_ENTRY = "!ENTRY";
    private static final String STATUS_SUBENTRY = "!SUBENTRY";
    private static final String MAC_JAVA_FRAMEWORK = "/System/Library/Frameworks/JavaVM.framework";
    private String featureLocation;
    private String root;
    private IProduct product;
    protected static String errorMessage;

    public static void setErrorMessage(String message) {
        errorMessage = message;
    }

    public static String getErrorMessage() {
        return errorMessage;
    }

    public static IStatus parseErrorMessage(CoreException e) {
        MultiStatus result = null;
        if (errorMessage != null) {
            MultiStatus status = null;
            StringTokenizer tokenizer = new StringTokenizer(errorMessage, "\n");
            while (tokenizer.hasMoreTokens()) {
                String next;
                String line = tokenizer.nextToken().trim();
                if (line.startsWith(STATUS_ENTRY) && tokenizer.hasMoreElements()) {
                    next = tokenizer.nextToken();
                    if (!next.startsWith(STATUS_MESSAGE)) continue;
                    status = new MultiStatus("org.eclipse.pde.core", 0, next.substring(8), null);
                    continue;
                }
                if (!line.startsWith(STATUS_SUBENTRY) || !tokenizer.hasMoreElements() || status == null || !(next = tokenizer.nextToken()).startsWith(STATUS_MESSAGE)) continue;
                status.add((IStatus)new Status(4, "org.eclipse.pde.core", next.substring(8)));
            }
            result = status != null ? status : new MultiStatus("org.eclipse.pde.core", 0, new IStatus[]{e.getStatus()}, errorMessage, null);
        }
        return result;
    }

    public WARProductExportOperation(FeatureExportInfo info, String name, IProduct product, String root) {
        super(info, name);
        this.product = product;
        this.root = root;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        result = null;
        configurations = this.fInfo.targets;
        if (configurations == null) {
            configurations = new String[][]{{TargetPlatform.getOS(), TargetPlatform.getWS(), TargetPlatform.getOSArch(), TargetPlatform.getNL()}};
        }
        this.cleanupBuildRepo();
        WARProductExportOperation.errorMessage = null;
        try {
            monitor.beginTask("", 10);
            try {
                try {
                    featureID = "org.eclipse.pde.container.feature";
                    this.featureLocation = String.valueOf(this.fBuildTempLocation) + File.separator + featureID;
                    this.createFeature(featureID, this.featureLocation, configurations, this.product.includeLaunchers());
                    this.createBuildPropertiesFile(this.featureLocation, configurations);
                    this.doExport(featureID, null, this.featureLocation, configurations, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                }
                catch (IOException e) {
                    PDECore.log((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    problemMessage = Messages.FeatureBasedExportOperation_ProblemDuringExport;
                    result = new Status(4, "org.eclipse.pde.core", problemMessage, e.getTargetException());
                }
                catch (CoreException e) {
                    block19: {
                        if (WARProductExportOperation.errorMessage == null) break block19;
                        result = WARProductExportOperation.parseErrorMessage(e);
                        ** GOTO lbl-1000
                    }
                    result = e.getStatus();
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var7_9) {
                var6_10 = null;
                j = 0;
            }
            while (true) {
                if (j >= this.fInfo.items.length) {
                    this.cleanup(null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    throw var7_9;
                }
                try {
                    this.deleteBuildFiles(this.fInfo.items[j]);
                }
                catch (CoreException e) {
                    PDECore.log((Throwable)e);
                }
                ++j;
            }
lbl-1000:
            // 5 sources

            {
                var6_11 = null;
                j = 0;
            }
            while (true) {
                block21: {
                    block20: {
                        if (j < this.fInfo.items.length) break block20;
                        this.cleanup(null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (this.hasAntErrors()) {
                            compilationErrors = Messages.FeatureExportOperation_CompilationErrors;
                            bind = NLS.bind((String)compilationErrors, (Object)this.fInfo.destinationDirectory);
                            result = new Status(2, "org.eclipse.pde.core", bind);
                        }
                        break;
                    }
                    ** try [egrp 3[TRYBLOCK] [7 : 238->255)] { 
lbl59:
                    // 1 sources

                    this.deleteBuildFiles(this.fInfo.items[j]);
                    break block21;
lbl61:
                    // 1 sources

                    catch (CoreException e) {
                        PDECore.log((Throwable)e);
                    }
                }
                ++j;
            }
        }
        catch (Throwable var11_16) {
            var10_17 = null;
            monitor.done();
            WARProductExportOperation.errorMessage = null;
            throw var11_16;
        }
        {
            var10_18 = null;
        }
        monitor.done();
        WARProductExportOperation.errorMessage = null;
        if (result != null) return result;
        return Status.OK_STATUS;
    }

    protected boolean groupedConfigurations() {
        return false;
    }

    private void cleanupBuildRepo() {
        File metadataTemp = new File(this.fBuildTempMetadataLocation);
        if (metadataTemp.exists()) {
            this.deleteDir(metadataTemp);
        }
    }

    protected String[] getPaths() {
        String[] paths = super.getPaths();
        String[] all = new String[paths.length + 1];
        all[0] = String.valueOf(this.featureLocation) + File.separator + "feature.xml";
        System.arraycopy(paths, 0, all, 1, paths.length);
        return all;
    }

    private void createBuildPropertiesFile(String featureLocation, String[][] configurations) throws IOException {
        File file = new File(featureLocation);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        Properties properties = new Properties();
        this.handleRootFiles(configurations, properties);
        this.handleJREInfo(configurations, properties);
        this.handleExportSource(properties);
        File fileToSave = new File(file, "build.properties");
        this.save(fileToSave, properties, "Build Configuration");
    }

    private void handleRootFiles(String[][] configurations, Properties properties) throws IOException {
        if (configurations.length > 0) {
            String rootPrefix = "root." + configurations[0][0] + "." + configurations[0][1] + "." + configurations[0][2];
            properties.put(rootPrefix, this.getRootFileLocations(false));
            this.prepareWARFile(properties, rootPrefix);
        }
    }

    private void prepareWARFile(Properties properties, String rootPrefix) throws IOException {
        if (this.product instanceof IWARProduct) {
            IWARProduct warProduct = (IWARProduct)this.product;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile launchIni = wsRoot.getFile(warProduct.getLaunchIni());
            String launchIniPath = this.createWarContent(launchIni.getLocation(), "launch.ini");
            IFile webXml = wsRoot.getFile(warProduct.getWebXml());
            String webXmlPath = this.createWarContent(webXml.getLocation(), "web.xml");
            properties.put(rootPrefix, "absolute:file:" + webXmlPath + ",absolute:file:" + launchIniPath);
            String libDir = this.createLibDir();
            this.copyLibraries(libDir);
            properties.put(String.valueOf(rootPrefix) + ".folder." + "lib", "absolute:" + libDir);
        }
    }

    private String createLibDir() {
        String location = this.featureLocation;
        File dir = new File(location, "lib");
        dir.mkdirs();
        return dir.getAbsolutePath();
    }

    private void copyLibraries(String libDir) throws IOException {
        IWARProduct warProduct = (IWARProduct)this.product;
        IPath[] libraries = warProduct.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IPath lib = WARProductUtil.getAbsolutLibraryPath(libraries[i], warProduct);
            this.copyLibrary(libDir, lib);
            ++i;
        }
    }

    private void copyLibrary(String libDir, IPath filePath) throws IOException {
        String fileName = filePath.segment(filePath.segmentCount() - 1);
        File template = new File(filePath.toOSString());
        File destinationFile = new File(String.valueOf(libDir) + File.separator + fileName);
        CoreUtility.readFile((InputStream)new FileInputStream(template), (File)destinationFile);
    }

    private String createWarContent(IPath pathToContent, String fileName) throws IOException {
        File destinationFile = new File(this.featureLocation, fileName);
        File template = new File(pathToContent.toOSString());
        CoreUtility.readFile((InputStream)new FileInputStream(template), (File)destinationFile);
        return destinationFile.getAbsolutePath();
    }

    private void handleJREInfo(String[][] configurations, Properties properties) {
        IJREInfo jreInfo = this.product.getJREInfo();
        int i = 0;
        while (i < configurations.length) {
            File vm;
            String[] config = configurations[i];
            File file = vm = jreInfo != null ? jreInfo.getJVMLocation(config[0]) : null;
            if (!(vm == null || config[0].equals("macosx") && vm.getPath().startsWith(MAC_JAVA_FRAMEWORK))) {
                String rootPrefix = "root." + config[0] + "." + config[1] + "." + config[2];
                properties.put(String.valueOf(rootPrefix) + ".folder.jre", "absolute:" + vm.getAbsolutePath());
                String perms = (String)properties.get(String.valueOf(rootPrefix) + ".permissions.755");
                if (perms != null) {
                    StringBuffer buffer = new StringBuffer(perms);
                    buffer.append(",");
                    buffer.append("jre/bin/java");
                    properties.put(String.valueOf(rootPrefix) + ".permissions.755", buffer.toString());
                }
            }
            ++i;
        }
    }

    private void handleExportSource(Properties properties) {
        if (this.fInfo.exportSource && this.fInfo.exportSourceBundle) {
            properties.put("individualSourceBundles", "true");
            List<IPluginModelBase> workspacePlugins = Arrays.asList(PluginRegistry.getWorkspaceModels());
            int i = 0;
            while (i < this.fInfo.items.length) {
                if (this.fInfo.items[i] instanceof IFeatureModel) {
                    IFeature feature = ((IFeatureModel)this.fInfo.items[i]).getFeature();
                    properties.put("generate.feature@" + feature.getId().trim() + ".source", feature.getId());
                } else {
                    BundleDescription bundle = null;
                    if (this.fInfo.items[i] instanceof IPluginModelBase) {
                        IPluginModelBase baseItem = (IPluginModelBase)this.fInfo.items[i];
                        bundle = baseItem.getBundleDescription();
                    }
                    if (bundle == null && this.fInfo.items[i] instanceof BundleDescription) {
                        bundle = (BundleDescription)this.fInfo.items[i];
                    }
                    if (bundle != null && workspacePlugins.contains(PluginRegistry.findModel(bundle))) {
                        properties.put("generate.plugin@" + bundle.getSymbolicName().trim() + ".source", bundle.getSymbolicName());
                    }
                }
                ++i;
            }
        }
    }

    protected boolean publishingP2Metadata() {
        return this.fInfo.exportMetadata;
    }

    private String getRootFileLocations(boolean hasLaunchers) {
        File homeDir;
        StringBuffer buffer = new StringBuffer();
        if (!hasLaunchers && (homeDir = new File(TargetPlatform.getLocation())).exists() && homeDir.isDirectory()) {
            File file = new File(homeDir, "startup.jar");
            if (file.exists()) {
                this.appendAbsolutePath(buffer, file);
            }
            if ((file = new File(homeDir, "libXm.so.2")).exists()) {
                this.appendAbsolutePath(buffer, file);
            }
        }
        return buffer.toString();
    }

    private void appendAbsolutePath(StringBuffer buffer, File file) {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append("absolute:file:");
        buffer.append(file.getAbsolutePath());
    }

    protected HashMap createAntBuildProperties(String[][] configs) {
        HashMap properties = super.createAntBuildProperties(configs);
        this.fAntBuildProperties.put("collectingFolder", this.root);
        this.fAntBuildProperties.put("archivePrefix", this.root);
        return properties;
    }

    protected void setupGenerator(BuildScriptGenerator generator, String featureID, String versionId, String[][] configs, String featureLocation) throws CoreException {
        super.setupGenerator(generator, featureID, versionId, configs, featureLocation);
        generator.setGenerateVersionsList(true);
        if (this.product != null) {
            generator.setProduct(this.product.getModel().getInstallLocation());
        }
    }

    protected void setAdditionalAttributes(Element plugin, BundleDescription bundle) {
        String unpack = Boolean.toString(CoreUtility.guessUnpack((BundleDescription)bundle));
        plugin.setAttribute("unpack", unpack);
    }

    protected String getAssemblyScriptName(String featureID, String os, String ws, String arch, String featureLocation) {
        String configIni = String.valueOf(featureLocation) + '/' + "productRootFiles" + '/' + os + "." + ws + "." + arch + '/' + "configuration" + '/' + "config.ini";
        this.addExtensionbundleToConfigIni(configIni);
        return super.getAssemblyScriptName(featureID, os, ws, arch, featureLocation);
    }

    private void addExtensionbundleToConfigIni(String configIni) {
        try {
            File file = new File(configIni);
            if (file.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = "";
                String oldtext = "";
                while ((line = reader.readLine()) != null) {
                    oldtext = String.valueOf(oldtext) + line + "\n";
                }
                reader.close();
                String newtext = oldtext.replaceAll("org.eclipse.equinox.http.servlet@start", "org.eclipse.equinox.servletbridge.extensionbundle,\\\\\n  org.eclipse.equinox.http.servlet@start");
                FileWriter writer = new FileWriter(configIni);
                writer.write(newtext);
                writer.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

