/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers.RunScriptChartHandler;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers.RunScriptHandler;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapScriptGraphOptionsTab;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapScriptLaunch;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.RemoteScriptOptions;

public class SystemTapScriptLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    static final String LOCALHOST = "localhost";
    static final int DEFAULT_PORT = 22;
    static final String CONFIGURATION_TYPE = "org.eclipse.linuxtools.systemtap.ui.ide.SystemTapLaunchConfigurationType";
    private IProject[] scriptProject;

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) {
        return this.scriptProject;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) {
        return new SystemTapScriptLaunch(configuration, mode);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject[] iProjectArray;
        if (!configuration.getAttribute("process_factory_id", "").equals("org.eclipse.linuxtools.systemtap.ui.ide.SystemTapRuntimeProcessFactory")) {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute("process_factory_id", "org.eclipse.linuxtools.systemtap.ui.ide.SystemTapRuntimeProcessFactory");
            wc.doSave();
        }
        IPath path = Path.fromOSString((String)configuration.getAttribute("ScriptPath", null));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (file == null) {
            iProjectArray = null;
        } else {
            IProject[] iProjectArray2 = new IProject[1];
            iProjectArray = iProjectArray2;
            iProjectArray2[0] = file.getProject();
        }
        this.scriptProject = iProjectArray;
        if (this.scriptProject != null) {
            return super.preLaunchCheck(configuration, mode, monitor);
        }
        return true;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RunScriptHandler action;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = manager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch olaunch = iLaunchArray[n2];
            if (!olaunch.equals(launch) && olaunch instanceof SystemTapScriptLaunch && ((SystemTapScriptLaunch)olaunch).getConsole() == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", Messages.SystemTapScriptLaunchError_waitForConsoles));
            }
            ++n2;
        }
        if (!SystemTapScriptGraphOptionsTab.isValidLaunch(configuration)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", Messages.SystemTapScriptLaunchError_graph));
        }
        boolean runWithChart = configuration.getAttribute("runWithChart", false);
        int numGraphs = configuration.getAttribute("numberOfRegexs", 0);
        if (runWithChart && numGraphs > 0) {
            List<IDataSetParser> parsers = SystemTapScriptGraphOptionsTab.createDatasetParsers(configuration);
            List<IFilteredDataSet> dataSets = SystemTapScriptGraphOptionsTab.createDataset(configuration);
            List<String> names = SystemTapScriptGraphOptionsTab.createDatasetNames(configuration);
            List<LinkedList<GraphData>> graphs = SystemTapScriptGraphOptionsTab.createGraphsFromConfiguration(configuration);
            action = new RunScriptChartHandler(parsers, dataSets, names, graphs);
        } else {
            action = new RunScriptHandler();
        }
        Path scriptPath = new Path(configuration.getAttribute("ScriptPath", ""));
        if (!scriptPath.toFile().exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", MessageFormat.format(Messages.SystemTapScriptLaunchError_fileNotFound, scriptPath.toString())));
        }
        String extension = scriptPath.getFileExtension();
        if (extension == null || !extension.equals("stp")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", MessageFormat.format(Messages.SystemTapScriptLaunchError_fileNotStp, scriptPath.toString())));
        }
        action.setPath((IPath)scriptPath);
        action.setRemoteScriptOptions(configuration.getAttribute("executeAsCurrentUser", true) ? null : new RemoteScriptOptions(configuration.getAttribute("userName", ""), configuration.getAttribute("userPassword", ""), configuration.getAttribute("executeOnLocalHost", true) ? LOCALHOST : configuration.getAttribute("hostName", LOCALHOST), configuration.getAttribute("useDefaultPort", true) ? 22 : configuration.getAttribute("port", 22)));
        String value = configuration.getAttribute(IDEPreferenceConstants.STAP_CMD_OPTION[2], "");
        if (!value.isEmpty()) {
            action.addComandLineOptions(String.valueOf(IDEPreferenceConstants.STAP_CMD_OPTION[0]) + " " + value);
        }
        int i = 0;
        while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
            boolean flag = configuration.getAttribute(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], false);
            if (flag) {
                action.addComandLineOptions(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][0]);
            }
            ++i;
        }
        i = 0;
        while (i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
            value = configuration.getAttribute(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], "");
            if (!value.isEmpty()) {
                action.addComandLineOptions(String.valueOf(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][0]) + " " + value);
            }
            ++i;
        }
        value = configuration.getAttribute("MiscComandLineOptions", "");
        if (!value.isEmpty()) {
            action.addComandLineOptions(value);
        }
        action.setLaunch((SystemTapScriptLaunch)launch);
        try {
            action.execute(null);
        }
        catch (ExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", e.getMessage()));
        }
    }
}

