/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.osgi.model.eclipse;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.inspections.osgi.model.BundleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationElement {
    private int objectId;
    private Integer parentId;
    private String[] propertiesAndValues;
    private BundleDescriptor contributingBundle;
    private String name;
    private Integer elementId;
    private List<ConfigurationElement> configurationElements = new ArrayList<ConfigurationElement>();

    public ConfigurationElement(int objectId, String name, Integer parentId, Integer elementId, BundleDescriptor contributingBundle, String[] propertiesAndValues) {
        this.objectId = objectId;
        this.name = name;
        this.parentId = parentId;
        this.elementId = elementId;
        this.contributingBundle = contributingBundle;
        this.propertiesAndValues = propertiesAndValues;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public Integer getElementId() {
        return this.elementId;
    }

    public List<PropertyPair> getPropertiesAndValues() {
        int length = this.propertiesAndValues.length;
        if (length % 2 != 0) {
            --length;
        }
        ArrayList<PropertyPair> properties = new ArrayList<PropertyPair>(length / 2);
        int i = 0;
        while (i < length) {
            if (i % 2 == 0) {
                properties.add(new PropertyPair(this.propertiesAndValues[i], this.propertiesAndValues[i + 1]));
            }
            ++i;
        }
        return properties;
    }

    public BundleDescriptor getContributingBundle() {
        return this.contributingBundle;
    }

    public List<ConfigurationElement> getConfigurationElements() {
        return this.configurationElements;
    }

    public void addConfigurationElement(ConfigurationElement configurationElement) {
        if (!this.configurationElements.contains(configurationElement)) {
            this.configurationElements.add(configurationElement);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.elementId == null ? 0 : this.elementId.hashCode());
        result = 31 * result + (this.parentId == null ? 0 : this.parentId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationElement other = (ConfigurationElement)obj;
        if (this.elementId == null ? other.elementId != null : !this.elementId.equals(other.elementId)) {
            return false;
        }
        return !(this.parentId == null ? other.parentId != null : !this.parentId.equals(other.parentId));
    }

    public class PropertyPair {
        public String property;
        public String value;

        PropertyPair(String property, String value) {
            this.property = property;
            this.value = value;
        }
    }
}

