/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracClientData;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

public class TracClientManager
implements IRepositoryListener {
    private final Map<String, ITracClient> clientByUrl = new HashMap<String, ITracClient>();
    private final Map<String, TracClientData> clientDataByUrl = new HashMap<String, TracClientData>();
    private final File cacheFile;
    private volatile TaskRepositoryLocationFactory taskRepositoryLocationFactory;

    public TracClientManager(File cacheFile, TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.cacheFile = cacheFile;
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
        this.readCache();
    }

    public synchronized ITracClient getTracClient(TaskRepository taskRepository) {
        ITracClient repository = this.clientByUrl.get(taskRepository.getRepositoryUrl());
        if (repository == null) {
            AbstractWebLocation location = this.taskRepositoryLocationFactory.createWebLocation(taskRepository);
            repository = TracClientFactory.createClient(location, ITracClient.Version.fromVersion(taskRepository.getVersion()));
            this.clientByUrl.put(taskRepository.getRepositoryUrl(), repository);
            TracClientData data = this.clientDataByUrl.get(taskRepository.getRepositoryUrl());
            if (data == null) {
                data = new TracClientData();
                this.clientDataByUrl.put(taskRepository.getRepositoryUrl(), data);
            }
            repository.setData(data);
        }
        return repository;
    }

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        this.removeClient(repository);
        this.clientDataByUrl.remove(repository.getRepositoryUrl());
    }

    public synchronized void clearClients() {
        this.clientByUrl.clear();
    }

    private synchronized void removeClient(TaskRepository repository) {
        this.clientByUrl.remove(repository.getRepositoryUrl());
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        this.removeClient(repository);
        this.clientDataByUrl.remove(repository.getRepositoryUrl());
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.removeClient(repository);
    }

    public synchronized void readCache() {
        block15: {
            if (this.cacheFile == null || !this.cacheFile.exists()) {
                return;
            }
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(new FileInputStream(this.cacheFile));
                    int size = in.readInt();
                    int i = 0;
                    while (i < size) {
                        String url = (String)in.readObject();
                        TracClientData data = (TracClientData)in.readObject();
                        if (url != null && data != null) {
                            this.clientDataByUrl.put(url, data);
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.core", "The Trac respository configuration cache could not be read", e));
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public synchronized void writeCache() {
        block14: {
            if (this.cacheFile == null) {
                return;
            }
            ObjectOutputStream out = null;
            try {
                try {
                    out = new ObjectOutputStream(new FileOutputStream(this.cacheFile));
                    out.writeInt(this.clientDataByUrl.size());
                    for (String url : this.clientDataByUrl.keySet()) {
                        out.writeObject(url);
                        out.writeObject(this.clientDataByUrl.get(url));
                    }
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.core", "The Trac respository configuration cache could not be written", (Throwable)e));
                    if (out == null) break block14;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }
}

