/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ocl.examples.eventmanager.filters.AndFilter;
import org.eclipse.ocl.examples.eventmanager.framework.RegistrationSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Registration {
    private Set<RegistrationSet> registrationSets;
    private final int bitSetForTablesRegisteredWith;
    private final AndFilter andFilter;
    private int[] requiredMatchesPerTable;

    Registration(int bitSetForTablesRegisteredWith, AndFilter andFilter, int[] requiredMatchesPerTable) {
        this.bitSetForTablesRegisteredWith = bitSetForTablesRegisteredWith;
        this.andFilter = andFilter;
        this.registrationSets = new HashSet<RegistrationSet>();
        this.requiredMatchesPerTable = requiredMatchesPerTable;
    }

    public int getMatchesRequiredForTable(int i) {
        return this.requiredMatchesPerTable[i];
    }

    public int getBitSetForTablesRegisteredWith() {
        return this.bitSetForTablesRegisteredWith;
    }

    Set<RegistrationSet> getRegistrationSets() {
        return Collections.unmodifiableSet(this.registrationSets);
    }

    void addRegistrationSet(RegistrationSet registrationSet) {
        this.registrationSets.add(registrationSet);
    }

    boolean removeRegistrationSet(RegistrationSet registrationSet) {
        boolean result = false;
        if (this.registrationSets.remove(registrationSet)) {
            result = this.registrationSets.size() == 0;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " bitSet " + this.bitSetForTablesRegisteredWith;
    }

    public AndFilter getAndFilter() {
        return this.andFilter;
    }
}

