/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.validation;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.AbstractConstraintEvaluator;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class EcoreOCLEValidator
implements EValidator {
    public static final String UNKNOWN_DETAIL = "Unknown ''{0}'' detail for ''{1}''";
    public static final String MISSING_DELEGATE = "Missing ''{0}'' delegate for ''{1}''";
    public static final String EXTRA_CONSTRAINTS_ANNOTATION_ENTRY = "Extra ''constraints'' annotation entry for ''{0}'' in ''{1}''";
    public static final String MISSING_CONSTRAINTS_ANNOTATION_ENTRY = "Missing ''constraints'' annotation entry for ''{0}'' in ''{1}''";
    public static final String MISSING_CONSTRAINTS = "Missing constraints annotation for ''{0}''";
    public static final String PARSING_ERROR_2 = "Parsing error ''{0}'' for ''{1}'' ''{2}''";
    public static final String PARSING_ERROR_1 = "Parsing error ''{0}'' for ''{1}''";
    public static final String INCOMPATIBLE_TYPE_2 = "Incompatible type ''{0}'' for ''{1}'' ''{2}''";
    public static final String INCOMPATIBLE_TYPE_1 = "Incompatible type ''{0}'' for ''{1}''";
    public static final String NULL_EXPRESSION = "Null expression for ''{0}''";
    public static final String NULL_PROPERTY_KEY = "Non-null ''derivation'' or ''initial'' detail allowed for ''{0}''";
    public static final String EXTRA_PROPERTY_KEY = "Only ''derivation'' or ''initial'' detail allowed for ''{0}''";
    public static final String DOUBLE_PROPERTY_KEY = "Both ''derivation'' and ''initial'' detail for ''{0}''";
    public static final String MISSING_PROPERTY_KEY = "Missing ''derivation'' or ''initial'' detail for ''{0}''";
    public static final @NonNull EcoreOCLEValidator INSTANCE = new EcoreOCLEValidator(true);
    public static final @NonNull EcoreOCLEValidator NO_NEW_LINES = new EcoreOCLEValidator(false);
    public static final @NonNull TracingOption VALIDATE_INSTANCE = new TracingOption("org.eclipse.ocl.pivot", "validate/instance");
    public static final @NonNull TracingOption VALIDATE_OPAQUE_ELEMENT = new TracingOption("org.eclipse.ocl.pivot", "validate/opaqueElement");
    protected final boolean mayUseNewLines;

    protected static void gatherTypes(@NonNull Set<Class> allTypes, @NonNull Set<Constraint> allConstraints, @NonNull Class newType) {
        if (allTypes.add(newType)) {
            allConstraints.addAll(newType.getOwnedInvariants());
            for (Class superType : newType.getSuperClasses()) {
                if (superType == null) continue;
                EcoreOCLEValidator.gatherTypes(allTypes, allConstraints, superType);
            }
        }
    }

    public EcoreOCLEValidator(boolean mayUseNewLines) {
        this.mayUseNewLines = mayUseNewLines;
    }

    protected OCLInternal getOCL(@NonNull Map<Object, Object> context) {
        OCLInternal ocl = null;
        Object oclRef = context.get(WeakOCLReference.class);
        if (oclRef instanceof WeakOCLReference) {
            ocl = (OCLInternal)((WeakOCLReference)oclRef).get();
        }
        if (ocl == null) {
            ocl = OCLInternal.newInstance();
            context.put(WeakOCLReference.class, new WeakOCLReference(ocl));
        }
        return ocl;
    }

    protected boolean isOCL(List<String> someDelegates) {
        for (String aDelegate : someDelegates) {
            if (!OCLCommon.isDelegateURI((String)aDelegate)) continue;
            return true;
        }
        return false;
    }

    private boolean isStaleStereotypeContent(EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof EPackage) {
                EAnnotation eAnnotation;
                EObject eContainer = eObject.eContainer();
                if (!(eContainer instanceof EAnnotation) || !"http://www.eclipse.org/uml2/2.0.0/UML".equals((eAnnotation = (EAnnotation)eContainer).getSource())) break;
                int index = eAnnotation.getContents().indexOf((Object)eObject);
                return index != 0;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.isStaleStereotypeContent(eObject)) {
            return true;
        }
        assert (context != null);
        boolean allOk = true;
        if (eObject instanceof EPackage) {
            EPackage ePackage = (EPackage)eObject;
            allOk = this.validateEPackage(ePackage, diagnostics, context);
        } else if (eObject instanceof EClassifier) {
            EClassifier eClassifier = (EClassifier)eObject;
            allOk = this.validateEClassifier(eClassifier, diagnostics, context);
        } else if (eObject instanceof EOperation) {
            EOperation eOperation = (EOperation)eObject;
            allOk = this.validateEOperation(eOperation, diagnostics, context);
        } else if (eObject instanceof EStructuralFeature) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eObject;
            allOk = this.validateEStructuralFeature(eStructuralFeature, diagnostics, context);
        }
        return allOk;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    protected boolean validateEClassifier(@NonNull EClassifier eClassifier, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        boolean allOk = true;
        String constraintsAnnotation = EcoreUtil.getAnnotation((EModelElement)eClassifier, (String)"http://www.eclipse.org/emf/2002/Ecore", (String)"constraints");
        EAnnotation eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
        if (eAnnotation != null) {
            OCLInternal ocl = this.getOCL(context);
            MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
            StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
            EMap details = eAnnotation.getDetails();
            for (String constraintName : details.keySet()) {
                String value = (String)details.get((Object)constraintName);
                allOk = this.validateExpression(metamodelManager, (ENamedElement)eClassifier, value, standardLibrary.getBooleanType(), constraintName, diagnostics, context);
            }
            if (constraintsAnnotation == null) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eClassifier, context);
                    String message = StringUtil.bind(MISSING_CONSTRAINTS, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eClassifier}));
                } else {
                    allOk = false;
                }
            } else {
                String message;
                String objectLabel;
                HashSet ecoreConstraints = new HashSet(EcoreUtil.getConstraints((EModelElement)eClassifier));
                HashSet oclConstraints = new HashSet(details.keySet());
                oclConstraints.removeAll(ecoreConstraints);
                ecoreConstraints.removeAll(details.keySet());
                for (String aConstraint : oclConstraints) {
                    if (diagnostics != null) {
                        objectLabel = EObjectValidator.getObjectLabel((EObject)eClassifier, context);
                        message = StringUtil.bind(MISSING_CONSTRAINTS_ANNOTATION_ENTRY, aConstraint, objectLabel);
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eClassifier}));
                        continue;
                    }
                    allOk = false;
                }
                for (String aConstraint : ecoreConstraints) {
                    if (diagnostics != null) {
                        objectLabel = EObjectValidator.getObjectLabel((EObject)eClassifier, context);
                        message = StringUtil.bind(EXTRA_CONSTRAINTS_ANNOTATION_ENTRY, aConstraint, objectLabel);
                        diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eClassifier}));
                        continue;
                    }
                    allOk = false;
                }
            }
        }
        return allOk;
    }

    protected boolean validateEPackage(@NonNull EPackage ePackage, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        String message;
        String objectLabel;
        boolean allOk = true;
        boolean needsInvocationDelegates = false;
        boolean needsSettingDelegates = false;
        boolean needsValidationDelegates = false;
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (OCLCommon.getDelegateAnnotation((EModelElement)eClassifier) != null) {
                needsValidationDelegates = true;
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EOperation eOperation : eClass.getEOperations()) {
                if (EcoreUtil.isInvariant((EOperation)eOperation) || OCLCommon.getDelegateAnnotation((EModelElement)eOperation) == null) continue;
                needsInvocationDelegates = true;
            }
            for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
                if (OCLCommon.getDelegateAnnotation((EModelElement)eStructuralFeature) == null) continue;
                needsSettingDelegates = true;
            }
        }
        boolean hasInvocationDelegates = this.isOCL(EcoreUtil.getInvocationDelegates((EPackage)ePackage));
        boolean hasSettingDelegates = this.isOCL(EcoreUtil.getSettingDelegates((EPackage)ePackage));
        boolean hasValidationDelegates = this.isOCL(EcoreUtil.getValidationDelegates((EPackage)ePackage));
        if (needsInvocationDelegates && !hasInvocationDelegates) {
            if (diagnostics != null) {
                objectLabel = EObjectValidator.getObjectLabel((EObject)ePackage, context);
                message = StringUtil.bind(MISSING_DELEGATE, "invocationDelegates", objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{ePackage}));
            } else {
                allOk = false;
            }
        }
        if (needsSettingDelegates && !hasSettingDelegates) {
            if (diagnostics != null) {
                objectLabel = EObjectValidator.getObjectLabel((EObject)ePackage, context);
                message = StringUtil.bind(MISSING_DELEGATE, "settingDelegates", objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{ePackage}));
            } else {
                allOk = false;
            }
        }
        if (needsValidationDelegates && !hasValidationDelegates) {
            if (diagnostics != null) {
                objectLabel = EObjectValidator.getObjectLabel((EObject)ePackage, context);
                message = StringUtil.bind(MISSING_DELEGATE, "validationDelegates", objectLabel);
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{ePackage}));
            } else {
                allOk = false;
            }
        }
        return allOk;
    }

    protected boolean validateEOperation(@NonNull EOperation eOperation, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        boolean allOk = true;
        EAnnotation eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation);
        if (eAnnotation != null) {
            String value;
            OCLInternal ocl = this.getOCL(context);
            MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
            StandardLibraryInternal standardLibrary = ocl.getStandardLibrary();
            EMap details = eAnnotation.getDetails();
            HashSet<String> knownKeys = new HashSet<String>();
            if (details.containsKey((Object)"body")) {
                knownKeys.add("body");
                value = (String)details.get((Object)"body");
                Class requiredType = EcoreUtil.isInvariant((EOperation)eOperation) ? standardLibrary.getBooleanType() : null;
                allOk = this.validateExpression(metamodelManager, (ENamedElement)eOperation, value, requiredType, "body", diagnostics, context);
            }
            if (details.containsKey((Object)"pre")) {
                knownKeys.add("pre");
                value = (String)details.get((Object)"pre");
                allOk = this.validateExpression(metamodelManager, (ENamedElement)eOperation, value, standardLibrary.getBooleanType(), "pre", diagnostics, context);
            }
            if (details.containsKey((Object)"post")) {
                knownKeys.add("post");
                value = (String)details.get((Object)"post");
                allOk = this.validateExpression(metamodelManager, (ENamedElement)eOperation, value, standardLibrary.getBooleanType(), "post", diagnostics, context);
            }
            Set actualKeys = details.keySet();
            HashSet unknownKeys = new HashSet(actualKeys);
            unknownKeys.removeAll(knownKeys);
            if (unknownKeys.size() > 0) {
                if (diagnostics != null) {
                    for (String unknownKey : unknownKeys) {
                        String objectLabel = EObjectValidator.getObjectLabel((EObject)eOperation, context);
                        String message = StringUtil.bind(UNKNOWN_DETAIL, unknownKey, objectLabel);
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eOperation}));
                    }
                } else {
                    allOk = false;
                }
            }
        }
        return allOk;
    }

    protected boolean validateEStructuralFeature(@NonNull EStructuralFeature eStructuralFeature, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        boolean allOk = true;
        EAnnotation eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eStructuralFeature);
        if (eAnnotation != null) {
            EMap details = eAnnotation.getDetails();
            int entries = 0;
            String value = null;
            if (details.containsKey((Object)"derivation")) {
                ++entries;
                value = (String)details.get((Object)"derivation");
            }
            if (details.containsKey((Object)"initial")) {
                ++entries;
                value = (String)details.get((Object)"initial");
            }
            if (entries == 0) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eStructuralFeature, context);
                    String message = StringUtil.bind(MISSING_PROPERTY_KEY, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eStructuralFeature}));
                } else {
                    allOk = false;
                }
            } else if (entries == 2) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eStructuralFeature, context);
                    String message = StringUtil.bind(DOUBLE_PROPERTY_KEY, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eStructuralFeature}));
                } else {
                    allOk = false;
                }
            } else if (details.size() != 1) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eStructuralFeature, context);
                    String message = StringUtil.bind(EXTRA_PROPERTY_KEY, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eStructuralFeature}));
                } else {
                    allOk = false;
                }
            } else if (value == null) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eStructuralFeature, context);
                    String message = StringUtil.bind(NULL_PROPERTY_KEY, objectLabel);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eStructuralFeature}));
                } else {
                    allOk = false;
                }
            } else {
                OCLInternal ocl = this.getOCL(context);
                MetamodelManagerInternal metamodelManager = ocl.getMetamodelManager();
                allOk = this.validateExpression(metamodelManager, (ENamedElement)eStructuralFeature, value, null, null, diagnostics, context);
            }
        }
        return allOk;
    }

    protected boolean validateExpression(@NonNull MetamodelManagerInternal metamodelManager, @NonNull ENamedElement eNamedElement, @Nullable String expression, @Nullable Type requiredType, @Nullable String role, DiagnosticChain diagnostics, @NonNull Map<Object, Object> context) {
        block13: {
            ExpressionInOCL expressionInOCL;
            block14: {
                if (expression == null) {
                    if (diagnostics != null) {
                        String objectLabel = EObjectValidator.getObjectLabel((EObject)eNamedElement, context);
                        String message = StringUtil.bind(NULL_EXPRESSION, objectLabel);
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eNamedElement}));
                        return true;
                    }
                    return false;
                }
                NamedElement asNamedElement = metamodelManager.getASOf(NamedElement.class, (EObject)eNamedElement);
                if (asNamedElement == null) break block13;
                ParserContext parserContext = metamodelManager.createParserContext(asNamedElement, new Object[0]);
                if (parserContext == null) {
                    throw new ParserException(PivotMessagesInternal.UnknownContextType_ERROR_, NameUtil.qualifiedNameFor(asNamedElement), "constraint");
                }
                expressionInOCL = parserContext.parse(asNamedElement, expression);
                Type asExpressionType = expressionInOCL.getType();
                Type asType = requiredType != null ? requiredType : (asNamedElement instanceof TypedElement ? ((TypedElement)asNamedElement).getType() : null);
                assert (asType != null);
                assert (asExpressionType != null);
                if (metamodelManager.conformsTo(asExpressionType, TemplateParameterSubstitutions.EMPTY, asType, TemplateParameterSubstitutions.EMPTY)) break block14;
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eNamedElement, context);
                    String message = role == null ? StringUtil.bind(INCOMPATIBLE_TYPE_1, asExpressionType, objectLabel) : StringUtil.bind(INCOMPATIBLE_TYPE_2, asExpressionType, objectLabel, role);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eNamedElement}));
                    break block14;
                }
                return false;
            }
            try {
                Diagnostician nestedDiagnostician = Diagnostician.INSTANCE;
                BasicDiagnostic nestedDiagnostic = nestedDiagnostician.createDefaultDiagnostic((EObject)eNamedElement);
                HashMap<Object, Object> nestedContext = new HashMap<Object, Object>(context);
                nestedContext.remove("org.eclipse.emf.ecore.EObject_NoCircularContainment");
                if (!nestedDiagnostician.validate((EObject)expressionInOCL, (DiagnosticChain)nestedDiagnostic, nestedContext)) {
                    if (diagnostics != null) {
                        StringBuilder s = new StringBuilder();
                        s.append("OCL Validation error for \"" + expressionInOCL.getBody() + "\"");
                        for (Diagnostic childDiagnostic : nestedDiagnostic.getChildren()) {
                            if (childDiagnostic == null) continue;
                            s.append("\n\t");
                            s.append(childDiagnostic.getMessage());
                        }
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, s.toString(), new Object[]{eNamedElement}));
                    }
                    return false;
                }
                return true;
            }
            catch (ParserException e) {
                if (diagnostics != null) {
                    String objectLabel = EObjectValidator.getObjectLabel((EObject)eNamedElement, context);
                    String message = role == null ? StringUtil.bind(PARSING_ERROR_1, e, objectLabel) : StringUtil.bind(PARSING_ERROR_2, e, objectLabel, role);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{eNamedElement}));
                    break block13;
                }
                return false;
            }
        }
        return true;
    }

    public static class ConstraintEvaluatorWithDiagnostics
    extends AbstractConstraintEvaluator<Boolean> {
        protected final @NonNull EObject eObject;
        protected final @NonNull DiagnosticChain diagnostics;
        protected final @NonNull EObject diagnosticEObject;
        protected final boolean mayUseNewLines;

        public ConstraintEvaluatorWithDiagnostics(@NonNull ExpressionInOCL expression, @NonNull EObject eObject, @NonNull DiagnosticChain diagnostics, @NonNull EObject diagnosticEObject, boolean mayUseNewLines) {
            super(expression);
            this.diagnosticEObject = diagnosticEObject;
            this.eObject = eObject;
            this.diagnostics = diagnostics;
            this.mayUseNewLines = mayUseNewLines;
        }

        @Override
        protected String getObjectLabel() {
            return NameUtil.qualifiedNameFor(this.eObject);
        }

        @Override
        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            String message = StringUtil.bind(PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.toString());
            if (!this.mayUseNewLines) {
                message = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleFailureResult(@Nullable Object result) {
            int severity = this.getConstraintResultSeverity(result);
            String message = this.getConstraintResultMessage(result);
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore.model", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidExpression(@NonNull String message) {
            String message2 = message;
            if (!this.mayUseNewLines) {
                message2 = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message2.replace("\n", " - "), new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            String message = StringUtil.bind(PivotMessagesInternal.ValidationResultIsInvalid_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage());
            if (!this.mayUseNewLines) {
                message = message.replace("\n", "");
            }
            this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore.model", 0, message, new Object[]{this.diagnosticEObject}));
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }

    public static class ConstraintEvaluatorWithoutDiagnostics
    extends AbstractConstraintEvaluator<Boolean> {
        public ConstraintEvaluatorWithoutDiagnostics(@NonNull ExpressionInOCL expression) {
            super(expression);
        }

        @Override
        protected String getObjectLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Boolean handleExceptionResult(@NonNull Throwable e) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleFailureResult(@Nullable Object result) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidExpression(@NonNull String message) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleInvalidResult(@NonNull InvalidValueException e) {
            return Boolean.FALSE;
        }

        @Override
        protected Boolean handleSuccessResult() {
            return Boolean.TRUE;
        }
    }

    protected static final class WeakOCLReference
    extends WeakReference<OCLInternal> {
        protected final @NonNull OCLInternal ocl;

        protected WeakOCLReference(@NonNull OCLInternal ocl) {
            super(ocl);
            this.ocl = ocl;
        }

        public void finalize() {
            new Thread("OCL-Finalizer"){

                @Override
                public void run() {
                    ocl.dispose();
                }
            }.start();
        }
    }
}

