/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies.NavigationEditPolicy;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.ui.HyperLinkManagerShell;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkException;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ManageHyperLinksHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NavigationEditPolicy navigationEditPolicy = (NavigationEditPolicy)this.getEditPolicy("NavigationEditPolicy");
        if (navigationEditPolicy == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EditPart target = navigationEditPolicy.getHost();
        while (!(target instanceof IPrimaryEditPart) && target != null) {
            target = target.getParent();
        }
        if (!(target instanceof IGraphicalEditPart)) {
            return UnexecutableCommand.INSTANCE;
        }
        IGraphicalEditPart gep = (IGraphicalEditPart)target;
        Shell parentShell = EditorHelper.getActiveShell();
        try {
            IPageIconsRegistry iconsregistry = (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)navigationEditPolicy.getHost());
            ArrayList hyperLinkHelpers = new ArrayList();
            hyperLinkHelpers.addAll(HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper());
            HyperLinkHelperFactory hyperlinkHelperFactory = new HyperLinkHelperFactory(hyperLinkHelpers);
            ArrayList hyperLinkObjectList = hyperlinkHelperFactory.getAllreferenced((EModelElement)gep.getNotationView());
            HyperLinkManagerShell hyperLinkManagerShell = new HyperLinkManagerShell(parentShell, iconsregistry, ((IGraphicalEditPart)navigationEditPolicy.getHost()).getEditingDomain(), (EModelElement)((IGraphicalEditPart)navigationEditPolicy.getHost()).getNotationView().getElement(), (EModelElement)((IGraphicalEditPart)navigationEditPolicy.getHost()).getNotationView(), hyperlinkHelperFactory);
            hyperLinkManagerShell.setInput((List)hyperLinkObjectList);
            hyperLinkManagerShell.open();
        }
        catch (ServiceException | HyperLinkException e) {
            Activator.log.error("Error in opening HyperLink Management Shell", e);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public EditPolicy getEditPolicy(String editPolicyName) {
        ISelectionService selectionService;
        ISelection selectionTmp;
        EditPolicy lookupEditPolicy = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (selectionTmp = (selectionService = activeWorkbenchWindow.getSelectionService()).getSelection()) != null && !selectionTmp.isEmpty() && selectionTmp instanceof StructuredSelection) {
            for (Object current : (StructuredSelection)selectionTmp) {
                EditPolicy editpolicy;
                if (!(current instanceof IGraphicalEditPart) || (editpolicy = ((IGraphicalEditPart)current).getEditPolicy((Object)editPolicyName)) == null) continue;
                lookupEditPolicy = editpolicy;
                break;
            }
        }
        return lookupEditPolicy;
    }
}

