/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.constraints;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;

public class IsProfileAppliedConstraint
extends AbstractConstraint {
    public static final String PROFILE_URI = "profileURI";
    protected String profileURI;
    protected Element umlElement;

    public boolean match(Object selection) {
        this.umlElement = UMLUtil.resolveUMLElement((Object)selection);
        if (this.umlElement == null) {
            return false;
        }
        EList allAppliedProfiles = this.umlElement.getNearestPackage().getAllAppliedProfiles();
        for (Profile profile : allAppliedProfiles) {
            String uri = profile.getURI();
            if (!this.profileURI.equals(uri)) continue;
            return true;
        }
        return false;
    }

    public void setDescriptor(SimpleConstraint descriptor) {
        this.profileURI = this.getValue(PROFILE_URI);
    }

    public String toString() {
        return String.format("IsProfileApplied %s (%s)", this.profileURI, this.getDisplayUnit().getElementMultiplicity() == 1 ? "Single" : "Multiple");
    }

    protected boolean equivalent(Constraint constraint) {
        if (this == constraint) {
            return true;
        }
        if (constraint == null) {
            return false;
        }
        if (!(constraint instanceof IsProfileAppliedConstraint)) {
            return false;
        }
        IsProfileAppliedConstraint other = (IsProfileAppliedConstraint)constraint;
        return !(this.profileURI == null ? other.profileURI != null : !this.profileURI.equals(other.profileURI));
    }
}

