/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.ExternalSiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class CategoryInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "category-context";
    private boolean storageModel = false;

    public CategoryInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    @Override
    protected IBaseModel createModel(IEditorInput input) {
        IBaseModel model = null;
        InputStream is = null;
        try {
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                is = new BufferedInputStream(file.getContents());
                model = this.createWorkspaceModel(file, is, true);
            } else if (input instanceof IStorageEditorInput) {
                is = new BufferedInputStream(((IStorageEditorInput)input).getStorage().getContents());
                model = this.createStorageModel(is);
            } else if (input instanceof IURIEditorInput) {
                IFileStore store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
                is = store.openInputStream(4096, (IProgressMonitor)new NullProgressMonitor());
                model = this.createStorageModel(is);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
        return model;
    }

    private IBaseModel createWorkspaceModel(IFile file, InputStream stream, boolean editable) {
        WorkspaceSiteModel model = new WorkspaceSiteModel(file);
        try {
            model.setEditable(editable);
            model.load(stream, false);
        }
        catch (CoreException coreException) {}
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        return model;
    }

    private IBaseModel createStorageModel(InputStream stream) {
        ExternalSiteModel model;
        block11: {
            model = new ExternalSiteModel();
            try {
                try {
                    model.load(stream, true);
                }
                catch (CoreException coreException) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return model;
    }

    @Override
    public void dispose() {
        ISiteModel model = (ISiteModel)this.getModel();
        if (this.storageModel) {
            model.dispose();
        }
        super.dispose();
    }

    @Override
    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isEditable()) {
            return;
        }
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            String content = swriter.toString();
            content = AbstractModel.fixLineDelimiter((String)content, (IFile)((IFile)((IModel)this.getModel()).getUnderlyingResource()));
            doc.set(content);
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    protected boolean synchronizeModel(IDocument doc) {
        ISiteModel model = (ISiteModel)this.getModel();
        boolean cleanModel = true;
        String text = doc.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> ops, IModelChangedEvent event) {
    }

    @Override
    protected void reorderInsertEdits(ArrayList<TextEdit> ops) {
    }

    @Override
    protected String getPartitionName() {
        return "___category_partition";
    }
}

