/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.core.sessions.CoreSession;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.mappings.AnyCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.internal.oxm.record.deferred.AnyMappingContentHandler;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLAnyCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private AnyCollectionMapping xmlAnyCollectionMapping;
    private int index = -1;
    private static XPathFragment SIMPLE_FRAGMENT = new XPathFragment();

    public XMLAnyCollectionMappingNodeValue(AnyCollectionMapping xmlAnyCollectionMapping) {
        this.xmlAnyCollectionMapping = xmlAnyCollectionMapping;
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment == null;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlAnyCollectionMapping.isReadOnly()) {
            return false;
        }
        Object cp = this.xmlAnyCollectionMapping.getContainerPolicy();
        Object collection = this.xmlAnyCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            AbstractNullPolicy wrapperNP = this.xmlAnyCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation().equals((Object)XMLNullRepresentationType.XSI_NIL)) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (iterator == null || !cp.hasNext(iterator)) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlAnyCollectionMapping.getWrapperNullPolicy() != null);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON()) {
            ArrayList<XPathFragment> frags = new ArrayList<XPathFragment>();
            ArrayList values = new ArrayList();
            ArrayList<Object> mixedValues = new ArrayList<Object>();
            while (cp.hasNext(iterator)) {
                Object nextValue = cp.next(iterator, (CoreAbstractSession)session);
                XPathFragment frag = this.getXPathFragmentForValue(nextValue = this.xmlAnyCollectionMapping.convertObjectValueToDataValue(nextValue, session, marshalRecord.getMarshaller()), marshalRecord, (Marshaller)marshalRecord.getMarshaller());
                if (frag == null) continue;
                if (frag == SIMPLE_FRAGMENT) {
                    mixedValues.add(nextValue);
                    continue;
                }
                int index = frags.indexOf(frag);
                if (index > -1) {
                    ((List)values.get(index)).add(nextValue);
                    continue;
                }
                frags.add(frag);
                ArrayList<Object> valuesList = new ArrayList<Object>();
                valuesList.add(nextValue);
                values.add(valuesList);
            }
            if (mixedValues.size() > 0) {
                frags.add(SIMPLE_FRAGMENT);
                values.add(mixedValues);
            }
            int i = 0;
            while (i < frags.size()) {
                XPathFragment nextFragment = (XPathFragment)frags.get(i);
                List listValue = (List)values.get(i);
                if (nextFragment != null) {
                    int valueSize = listValue.size();
                    if (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays()) {
                        marshalRecord.startCollection();
                    }
                    int j = 0;
                    while (j < valueSize) {
                        this.marshalSingleValue(nextFragment, marshalRecord, object, listValue.get(j), session, namespaceResolver, ObjectMarshalContext.getInstance());
                        ++j;
                    }
                    if (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays()) {
                        marshalRecord.endCollection();
                    }
                }
                ++i;
            }
            return true;
        }
        marshalRecord.startCollection();
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, (CoreAbstractSession)session);
            objectValue = this.xmlAnyCollectionMapping.convertObjectValueToDataValue(objectValue, session, marshalRecord.getMarshaller());
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        marshalRecord.endCollection();
        return true;
    }

    private XPathFragment getXPathFragmentForValue(Object value, MarshalRecord marshalRecord, Marshaller marshaller) {
        Descriptor descriptor;
        String defaultRootElementString;
        if (this.xmlAnyCollectionMapping.usesXMLRoot() && value instanceof Root) {
            Root xmlRootValue = (Root)value;
            XPathFragment xmlRootFragment = new XPathFragment(xmlRootValue.getLocalName(), marshalRecord.getNamespaceSeparator(), marshalRecord.isNamespaceAware());
            xmlRootFragment.setNamespaceURI(xmlRootValue.getNamespaceURI());
            return xmlRootFragment;
        }
        if (value instanceof Node) {
            XPathFragment frag = null;
            Node n = (Node)value;
            if (n.getNodeType() == 1) {
                String prefix;
                Element elem = (Element)n;
                String local = elem.getLocalName();
                if (local == null) {
                    local = elem.getNodeName();
                }
                frag = (prefix = elem.getPrefix()) != null && !prefix.equals("") ? new XPathFragment(String.valueOf(prefix) + marshalRecord.getNamespaceSeparator() + elem.getLocalName(), marshalRecord.getNamespaceSeparator(), marshalRecord.isNamespaceAware()) : new XPathFragment(local, marshalRecord.getNamespaceSeparator(), marshalRecord.isNamespaceAware());
            } else if (n.getNodeType() == 2) {
                Attr attr = (Attr)n;
                attr.getLocalName();
                String prefix = attr.getPrefix();
                frag = prefix != null && prefix.equals("") ? new XPathFragment(String.valueOf(prefix) + marshalRecord.getNamespaceSeparator() + attr.getLocalName(), marshalRecord.getNamespaceSeparator(), marshalRecord.isNamespaceAware()) : new XPathFragment(attr.getLocalName(), marshalRecord.getNamespaceSeparator(), marshalRecord.isNamespaceAware());
            } else if (n.getNodeType() == 3) {
                return SIMPLE_FRAGMENT;
            }
            return frag;
        }
        CoreSession childSession = null;
        try {
            childSession = (CoreSession)((Context)marshaller.getContext()).getSession(value);
        }
        catch (XMLMarshalException xMLMarshalException) {
            return SIMPLE_FRAGMENT;
        }
        if (childSession != null && (defaultRootElementString = (descriptor = (Descriptor)childSession.getDescriptor(value)).getDefaultRootElement()) != null) {
            return new XPathFragment(defaultRootElementString);
        }
        return null;
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        block7: {
            try {
                Object policy;
                XPathQName qname;
                Object collection = unmarshalRecord.getContainerInstance(this);
                this.startElementProcessText(unmarshalRecord, collection);
                Object xmlContext = ((Unmarshaller)unmarshalRecord.getUnmarshaller()).getContext();
                Descriptor workingDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlAnyCollectionMapping, (UnmarshalKeepAsElementPolicy)this.xmlAnyCollectionMapping.getKeepAsElementPolicy());
                if (workingDescriptor == null && (workingDescriptor = ((Context)xmlContext).getDescriptor(qname = new XPathQName(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), unmarshalRecord.isNamespaceAware()))) != null && workingDescriptor.isWrapper()) {
                    workingDescriptor = null;
                }
                if ((policy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy()) != null && workingDescriptor == null && policy.isKeepUnknownAsElement() || policy.isKeepAllAsElement()) {
                    if (!this.xmlAnyCollectionMapping.isMixedContent() || unmarshalRecord.getTextWrapperFragment() == null || !unmarshalRecord.getTextWrapperFragment().equals(xPathFragment)) {
                        this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                    }
                    break block7;
                }
                if (workingDescriptor != null) {
                    this.processChild(xPathFragment, unmarshalRecord, atts, workingDescriptor, this.xmlAnyCollectionMapping);
                    break block7;
                }
                AnyMappingContentHandler handler = new AnyMappingContentHandler(unmarshalRecord, this.xmlAnyCollectionMapping.usesXMLRoot());
                String qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = String.valueOf(xPathFragment.getPrefix()) + ':' + qnameString;
                }
                handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                XMLReader xmlReader = unmarshalRecord.getXMLReader();
                xmlReader.setContentHandler(handler);
                xmlReader.setLexicalHandler(handler);
                return true;
            }
            catch (SAXException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        return true;
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        this.endElement(xPathFragment, unmarshalRecord, null);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        UnmarshalRecord childRecord = unmarshalRecord.getChildRecord();
        if (childRecord != null) {
            if (!this.xmlAnyCollectionMapping.usesXMLRoot()) {
                Object objectValue = childRecord.getCurrentObject();
                objectValue = this.xmlAnyCollectionMapping.convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
                unmarshalRecord.addAttributeValue(this, objectValue);
            } else {
                Object childObject = childRecord.getCurrentObject();
                Descriptor workingDescriptor = childRecord.getDescriptor();
                if (workingDescriptor != null) {
                    String prefix = xPathFragment.getPrefix();
                    if (prefix == null && xPathFragment.getNamespaceURI() != null) {
                        prefix = unmarshalRecord.resolveNamespaceUri(xPathFragment.getNamespaceURI());
                    }
                    childObject = workingDescriptor.wrapObjectInXMLRoot(childObject, xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), prefix, false, unmarshalRecord.isNamespaceAware(), unmarshalRecord.getUnmarshaller());
                    childObject = this.xmlAnyCollectionMapping.convertDataValueToObjectValue(childObject, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
                    unmarshalRecord.addAttributeValue(this, childObject);
                }
            }
            unmarshalRecord.setChildRecord(null);
        } else {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            if (this.xmlAnyCollectionMapping.isMixedContent() && unmarshalRecord.getTextWrapperFragment() != null && unmarshalRecord.getTextWrapperFragment().equals(xPathFragment)) {
                this.endElementProcessText(unmarshalRecord, this.xmlAnyCollectionMapping, xPathFragment, null);
                return;
            }
            Object keepAsElementPolicy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy();
            if (keepAsElementPolicy != null && (keepAsElementPolicy.isKeepUnknownAsElement() || keepAsElementPolicy.isKeepAllAsElement()) && builder.getNodes().size() > 1) {
                this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlAnyCollectionMapping, this.xmlAnyCollectionMapping, unmarshalRecord, true, collection);
            } else if (this.xmlAnyCollectionMapping.isMixedContent()) {
                this.endElementProcessText(unmarshalRecord, this.xmlAnyCollectionMapping, xPathFragment, null);
            } else {
                unmarshalRecord.resetStringBuffer();
            }
        }
    }

    private void startElementProcessText(UnmarshalRecord unmarshalRecord, Object collection) {
        String value = unmarshalRecord.getCharacters().toString();
        unmarshalRecord.resetStringBuffer();
        if (value.length() > 0 && this.xmlAnyCollectionMapping.isMixedContent()) {
            unmarshalRecord.addAttributeValue(this, value);
        }
    }

    @Override
    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        if (!this.xmlAnyCollectionMapping.usesXMLRoot() || xPathFragment.getLocalName() == null || this.xmlAnyCollectionMapping.isMixedContent() && unmarshalRecord.getTextWrapperFragment() != null && unmarshalRecord.getTextWrapperFragment().equals(xPathFragment)) {
            unmarshalRecord.addAttributeValue(this, value);
        } else {
            Root xmlRoot = unmarshalRecord.createRoot();
            xmlRoot.setNamespaceURI(xPathFragment.getNamespaceURI());
            xmlRoot.setSchemaType(unmarshalRecord.getTypeQName());
            xmlRoot.setLocalName(xPathFragment.getLocalName());
            xmlRoot.setObject(value);
            unmarshalRecord.addAttributeValue(this, xmlRoot);
        }
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlAnyCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlAnyCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    private Namespace setupFragment(Root originalValue, XPathFragment xmlRootFragment, MarshalRecord marshalRecord) {
        Namespace generatedNamespace = null;
        String xpath = originalValue.getLocalName();
        if (originalValue.getNamespaceURI() != null) {
            xmlRootFragment.setNamespaceURI(originalValue.getNamespaceURI());
            String prefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).resolveNamespaceURI(originalValue.getNamespaceURI());
            if (prefix == null || prefix.length() == 0) {
                prefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).generatePrefix();
                generatedNamespace = new Namespace(prefix, xmlRootFragment.getNamespaceURI());
                xmlRootFragment.setGeneratedPrefix(true);
            }
            xpath = String.valueOf(prefix) + ':' + xpath;
        }
        xmlRootFragment.setXPath(xpath);
        return generatedNamespace;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (value == null) {
            return false;
        }
        boolean wasXMLRoot = false;
        XPathFragment xmlRootFragment = null;
        Object originalValue = value;
        Object marshaller = marshalRecord.getMarshaller();
        if (this.xmlAnyCollectionMapping.usesXMLRoot() && value instanceof Root) {
            xmlRootFragment = new XPathFragment();
            xmlRootFragment.setNamespaceAware(marshalRecord.isNamespaceAware());
            wasXMLRoot = true;
            value = ((Root)value).getObject();
            if (value == null) {
                this.setupFragment((Root)originalValue, xmlRootFragment, marshalRecord);
                marshalRecord.nilComplex(xmlRootFragment, namespaceResolver);
                return true;
            }
        }
        Object keepAsElementPolicy = this.xmlAnyCollectionMapping.getKeepAsElementPolicy();
        if (value instanceof String) {
            this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, value, session, namespaceResolver);
        } else if (keepAsElementPolicy != null && (keepAsElementPolicy.isKeepUnknownAsElement() || keepAsElementPolicy.isKeepAllAsElement()) && value instanceof Node) {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
        } else {
            XPathFragment rootFragment;
            Object childSession;
            try {
                childSession = ((Context)((Marshaller)marshaller).getContext()).getSession(value);
            }
            catch (XMLMarshalException xMLMarshalException) {
                this.marshalSimpleValue(xmlRootFragment, marshalRecord, originalValue, object, value, session, namespaceResolver);
                return true;
            }
            Descriptor descriptor = (Descriptor)childSession.getDescriptor(value);
            this.pushAttributeGroup(marshalRecord, descriptor, this.getMapping().getAttributeName());
            ObjectBuilder objectBuilder = (ObjectBuilder)descriptor.getObjectBuilder();
            List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session, true, true);
            if (wasXMLRoot) {
                this.setupFragment((Root)originalValue, xmlRootFragment, marshalRecord);
            }
            String defaultRootElementString = descriptor.getDefaultRootElement();
            if (!wasXMLRoot && defaultRootElementString == null) {
                throw XMLMarshalException.defaultRootElementNotSpecified(descriptor);
            }
            marshalRecord.beforeContainmentMarshal(value);
            if (xmlRootFragment != null) {
                rootFragment = xmlRootFragment;
            } else {
                rootFragment = new XPathFragment(defaultRootElementString);
                if (rootFragment.getNamespaceURI() == null) {
                    String uri = ((NamespaceResolver)descriptor.getNonNullNamespaceResolver()).resolveNamespacePrefix(rootFragment.getPrefix());
                    rootFragment.setNamespaceURI(uri);
                }
            }
            if (!wasXMLRoot) {
                marshalRecord.setLeafElementType(descriptor.getDefaultRootElementType());
            }
            this.getXPathNode().startElement(marshalRecord, rootFragment, object, (CoreAbstractSession)childSession, (NamespaceResolver)marshalRecord.getNamespaceResolver(), objectBuilder, value);
            this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
            this.pushAttributeGroup(marshalRecord, descriptor, rootFragment.getLocalName());
            marshalRecord.addXsiTypeAndClassIndicatorIfRequired(descriptor, descriptor, (Field)this.xmlAnyCollectionMapping.getField(), originalValue, value, wasXMLRoot, false);
            objectBuilder.buildRow(marshalRecord, value, session, marshaller, null);
            marshalRecord.afterContainmentMarshal(object, value);
            marshalRecord.endElement(rootFragment, namespaceResolver);
            marshalRecord.removeExtraNamespacesFromNamespaceResolver(extraNamespaces, session);
            marshalRecord.popAttributeGroup();
            marshalRecord.popAttributeGroup();
        }
        return true;
    }

    private void pushAttributeGroup(MarshalRecord marshalRecord, Descriptor descriptor, String attributeName) {
        CoreAttributeGroup group = marshalRecord.getCurrentAttributeGroup();
        Object item = group.getItem(attributeName);
        CoreAttributeGroup nestedGroup = XMLRecord.DEFAULT_ATTRIBUTE_GROUP;
        if (item != null) {
            if (((CoreAttributeItem)item).getGroups() != null) {
                nestedGroup = ((CoreAttributeItem)item).getGroup(descriptor.getJavaClass());
            }
            if (nestedGroup == null) {
                nestedGroup = ((CoreAttributeItem)item).getGroup() == null ? XMLRecord.DEFAULT_ATTRIBUTE_GROUP : ((CoreAttributeItem)item).getGroup();
            }
        }
        marshalRecord.pushAttributeGroup(nestedGroup);
    }

    private void marshalSimpleValue(XPathFragment xmlRootFragment, MarshalRecord marshalRecord, Object originalValue, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        QName qname = null;
        if (xmlRootFragment != null) {
            qname = ((Root)originalValue).getSchemaType();
            this.setupFragment((Root)originalValue, xmlRootFragment, marshalRecord);
            CoreAttributeGroup group = marshalRecord.getCurrentAttributeGroup();
            Object item = group.getItem(this.getMapping().getAttributeName());
            if (item != null && ((CoreAttributeItem)item).getGroup() != null && xmlRootFragment.getLocalName() != null) {
                Object nestedItem = ((CoreAttributeGroup)((CoreAttributeItem)item).getGroup()).getItem(xmlRootFragment.getLocalName());
                if (nestedItem != null) {
                    ((CoreAttributeItem)item).getGroup();
                } else {
                    return;
                }
            }
            this.getXPathNode().startElement(marshalRecord, xmlRootFragment, object, session, namespaceResolver, null, null);
            this.updateNamespaces(qname, marshalRecord, null);
        }
        marshalRecord.characters(qname, value, null, false);
        if (xmlRootFragment != null) {
            marshalRecord.endElement(xmlRootFragment, namespaceResolver);
        }
    }

    @Override
    public AnyCollectionMapping getMapping() {
        return this.xmlAnyCollectionMapping;
    }

    @Override
    public boolean isWhitespaceAware() {
        return this.xmlAnyCollectionMapping.isMixedContent() && this.xmlAnyCollectionMapping.isWhitespacePreservedForMixedContent();
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return false;
    }

    @Override
    public boolean isAnyMappingNodeValue() {
        return true;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    @Override
    public boolean isMixedContentNodeValue() {
        return this.xmlAnyCollectionMapping.isMixedContent();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

