/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.profile.core.data.ProfilerClassData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.views.TreeElement;
import org.eclipse.swt.graphics.Image;

public class ExecutionStatisticsLabelProvider
implements ITableLabelProvider {
    private Image fFileImage;
    private Image fClassImage;
    private Image fFunctionImage;
    private IPreferenceStore fStore;
    private NumberFormat fNumberFormatter = new DecimalFormat("0.000000");

    public ExecutionStatisticsLabelProvider() {
        this.fFileImage = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_CUNIT);
        this.fClassImage = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.png");
        this.fFunctionImage = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_MISC_PUBLIC);
        this.fStore = ProfilerUiPlugin.getDefault().getPreferenceStore();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        TreeElement item = (TreeElement)element;
        if (columnIndex == 0) {
            Object data = item.getData();
            if (data instanceof ProfilerFileData) {
                return this.fFileImage;
            }
            if (data instanceof ProfilerFunctionData) {
                return this.fFunctionImage;
            }
            if (data instanceof ProfilerClassData) {
                return this.fClassImage;
            }
        }
        return null;
    }

    private String getPercents(double sum, double val) {
        val = val / sum * 100.0;
        val = (double)Math.round(val * 100.0) / 100.0;
        return NLS.bind((String)PHPProfileUIMessages.getString("ExecutionStatisticsLabelProvider_0"), (Object)Double.toString(val));
    }

    public String getColumnText(Object element, int columnIndex) {
        TreeElement item = (TreeElement)element;
        Object data = item.getData();
        boolean showAsPercentage = this.fStore.getBoolean("executionViewShowAsPercentage");
        if (data instanceof ProfilerFileData) {
            ProfilerFileData fileData = (ProfilerFileData)data;
            switch (columnIndex) {
                case 0: {
                    return new File(fileData.getName()).getName();
                }
                case 5: {
                    return this.fNumberFormatter.format(fileData.getTotalOwnTime());
                }
            }
        } else if (data instanceof ProfilerFunctionData) {
            ProfilerFunctionData funcData = (ProfilerFunctionData)data;
            switch (columnIndex) {
                case 0: {
                    return funcData.getFunctionName();
                }
                case 1: {
                    return Integer.toString(funcData.getCallsCount());
                }
                case 2: {
                    if (funcData.getCallsCount() > 0) {
                        double averageOwnTime = funcData.getOwnTime() / (double)funcData.getCallsCount();
                        if (showAsPercentage) {
                            return this.getPercents(funcData.getTotalTime(), averageOwnTime);
                        }
                        return this.fNumberFormatter.format(averageOwnTime);
                    }
                }
                case 3: {
                    double ownTime = funcData.getOwnTime();
                    if (showAsPercentage) {
                        return this.getPercents(funcData.getTotalTime(), ownTime);
                    }
                    return this.fNumberFormatter.format(ownTime);
                }
                case 4: {
                    double othersTime = funcData.getTotalTime() - funcData.getOwnTime();
                    if (showAsPercentage) {
                        return this.getPercents(funcData.getTotalTime(), othersTime);
                    }
                    return this.fNumberFormatter.format(othersTime);
                }
                case 5: {
                    return this.fNumberFormatter.format(funcData.getTotalTime());
                }
            }
        } else if (data instanceof ProfilerClassData) {
            ProfilerClassData classData = (ProfilerClassData)data;
            switch (columnIndex) {
                case 0: {
                    return classData.getName();
                }
                case 5: {
                    return this.fNumberFormatter.format(classData.getTotalOwnTime());
                }
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

