/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.compiler.AbstractCompilerStep;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtc2qvtu.QVTc2QVTu;
import org.eclipse.qvtd.compiler.internal.qvtc2qvtu.QVTuConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTi;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.QVTs2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtu2qvtm.QVTu2QVTm;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.compiler.internal.utilities.JavaSourceFileObject;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.runtime.evaluation.Transformer;

public abstract class AbstractCompilerChain
extends CompilerUtil
implements CompilerChain {
    private static final @NonNull Map<@NonNull String, @NonNull String> step2extension = new HashMap<String, String>();
    protected final @NonNull QVTiEnvironmentFactory environmentFactory;
    protected final @NonNull ResourceSet asResourceSet;
    protected final @NonNull Map<@NonNull String, @Nullable Map<@NonNull CompilerChain.Key<Object>, @Nullable Object>> options;
    protected final @NonNull URI txURI;
    protected final @NonNull URI prefixURI;
    private @Nullable List<@NonNull CompilerChain.Listener> listeners = null;
    protected final @NonNull Java2ClassCompilerStep java2classCompilerStep;
    protected final @NonNull QVTc2QVTuCompilerStep qvtc2qvtuCompilerStep;
    protected final @NonNull QVTu2QVTmCompilerStep qvtu2qvtmCompilerStep;
    protected final @NonNull QVTm2QVTsCompilerStep qvtm2qvtsCompilerStep;
    protected final @NonNull QVTs2QVTiCompilerStep qvts2qvtiCompilerStep;
    protected final @NonNull QVTi2JavaCompilerStep qvti2javaCompilerStep;

    static {
        step2extension.put("UMLX", "umlx");
        step2extension.put("QVTr", "qvtras");
        step2extension.put("Trace", "trace.ecore");
        step2extension.put("GenModel", "genmodel");
        step2extension.put("QVTc", "qvtcas");
        step2extension.put("QVTu", "qvtu.qvtcas");
        step2extension.put("QVTm", "qvtm.qvtcas");
        step2extension.put("QVTs", "qvtsas");
        step2extension.put("QVTi", "qvtias");
        step2extension.put("Java", "java");
        step2extension.put("Class", "class");
    }

    @Override
    public @Nullable URI basicGetURI(@NonNull String stepKey, @NonNull CompilerChain.Key<URI> uriKey) {
        return (URI)this.getOption(stepKey, URI_KEY);
    }

    public static @Nullable String getDefaultExtension(@NonNull String key) {
        return step2extension.get(key);
    }

    public static <T> @Nullable T getOption(@NonNull Map<@NonNull String, @NonNull Map<@NonNull CompilerChain.Key<Object>, @Nullable Object>> options, @NonNull String stepKey, @NonNull CompilerChain.Key<T> optionKey) {
        Map<CompilerChain.Key<Object>, Object> defaultOptions;
        Map<@NonNull String, @NonNull Map<@NonNull CompilerChain.Key<Object>, @Nullable Object>> castOptions = options;
        Map<@NonNull CompilerChain.Key<Object>, @Nullable Object> stepOptions = castOptions.get(stepKey);
        if (stepOptions == null && !options.containsKey(stepOptions)) {
            stepOptions = castOptions.get("default");
        }
        Object optionValue = null;
        if (stepOptions != null && (optionValue = stepOptions.get(optionKey)) == null && !options.containsKey(optionKey) && (defaultOptions = options.get("default")) != null) {
            optionValue = defaultOptions.get(optionKey);
        }
        Object castValue = optionValue;
        return (T)castValue;
    }

    public static @NonNull Transformation getTransformation(Resource resource) throws IOException {
        ArrayList<@NonNull E> asTransformations = new ArrayList();
        for (EObject eContent : resource.getContents()) {
            if (!(eContent instanceof BaseModel)) continue;
            QVTbaseUtil.getAllTransformations((List)ClassUtil.nullFree((List)((BaseModel)eContent).getOwnedPackages()), asTransformations);
        }
        if (asTransformations.size() == 1) {
            return (Transformation)asTransformations.get(0);
        }
        if (asTransformations.size() == 1) {
            throw new IOException("No Transformation element in " + resource.getURI());
        }
        throw new IOException("Multiple Transformation elements in " + resource.getURI());
    }

    public static <T> void setOption(@NonNull Map<@NonNull String, @Nullable Map<@NonNull CompilerChain.Key<Object>, @Nullable Object>> options, @NonNull String stepKey, @NonNull CompilerChain.Key<T> optionsKey, @Nullable T optionValue) {
        Map<@NonNull String, @NonNull Map<@NonNull CompilerChain.Key<Object>, @Nullable Object>> castOptions = options;
        Map<@NonNull CompilerChain.Key<Object>, @Nullable Object> stepOptions = castOptions.get(stepKey);
        if (stepOptions == null) {
            stepOptions = new HashMap<CompilerChain.Key<Object>, Object>();
            castOptions.put(stepKey, stepOptions);
        }
        stepOptions.put(optionsKey, optionValue);
    }

    protected AbstractCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @Nullable Map<@NonNull String, @Nullable Map<@NonNull CompilerChain.Key<Object>, @Nullable Object>> options) {
        this.environmentFactory = environmentFactory;
        this.asResourceSet = environmentFactory.getMetamodelManager().getASResourceSet();
        this.txURI = txURI;
        this.prefixURI = txURI.trimSegments(1).appendSegment("temp").appendSegment(txURI.trimFileExtension().lastSegment());
        this.options = options != null ? options : new HashMap();
        this.java2classCompilerStep = this.createJava2ClassCompilerStep();
        this.qvtc2qvtuCompilerStep = this.createQVTc2QVTuCompilerStep();
        this.qvtu2qvtmCompilerStep = this.createQVTu2QVTmCompilerStep();
        this.qvtm2qvtsCompilerStep = this.createQVTm2QVTsCompilerStep();
        this.qvts2qvtiCompilerStep = this.createQVTs2QVTiCompilerStep();
        this.qvti2javaCompilerStep = this.createQVTi2JavaCompilerStep();
    }

    @Override
    public void addListener(@NonNull CompilerChain.Listener listener) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 == null) {
            this.listeners = listeners2 = new ArrayList<CompilerChain.Listener>();
        }
        if (!listeners2.contains(listener)) {
            listeners2.add(listener);
        }
    }

    @Override
    public @NonNull Class<? extends Transformer> build(@NonNull String enforcedOutputName, String ... genModelFiles) throws Exception {
        ImperativeTransformation asTransformation = this.compile(enforcedOutputName);
        return this.generate(asTransformation, genModelFiles);
    }

    @Override
    public abstract @NonNull ImperativeTransformation compile(@NonNull String var1) throws IOException;

    @Override
    public void compiled(@NonNull String stepKey, @NonNull Object object) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 != null) {
            for (CompilerChain.Listener listener : listeners2) {
                listener.compiled(stepKey, object);
            }
        }
    }

    protected @NonNull Java2ClassCompilerStep createJava2ClassCompilerStep() {
        return new Java2ClassCompilerStep(this);
    }

    protected @NonNull QVTc2QVTuCompilerStep createQVTc2QVTuCompilerStep() {
        return new QVTc2QVTuCompilerStep(this);
    }

    protected @NonNull QVTi2JavaCompilerStep createQVTi2JavaCompilerStep() {
        return new QVTi2JavaCompilerStep(this);
    }

    protected @NonNull QVTm2QVTsCompilerStep createQVTm2QVTsCompilerStep() {
        return new QVTm2QVTsCompilerStep(this);
    }

    protected @NonNull QVTs2QVTiCompilerStep createQVTs2QVTiCompilerStep() {
        return new QVTs2QVTiCompilerStep(this);
    }

    protected @NonNull QVTu2QVTmCompilerStep createQVTu2QVTmCompilerStep() {
        return new QVTu2QVTmCompilerStep(this);
    }

    protected @NonNull QVTuConfiguration createQVTuConfiguration(@NonNull Resource cResource, QVTuConfiguration.Mode mode, @NonNull String enforcedOutputName) throws IOException {
        Transformation transformation = AbstractCompilerChain.getTransformation(cResource);
        ArrayList<@NonNull TypedModel> inputTypedModels = new ArrayList<TypedModel>();
        ArrayList<@NonNull TypedModel> outputTypedModels = new ArrayList<TypedModel>();
        ArrayList<@NonNull TypedModel> intermediateTypedModels = new ArrayList<TypedModel>();
        for (TypedModel typedModel : QVTcoreUtil.getModelParameters((Transformation)transformation)) {
            String modelName = typedModel.getName();
            if (modelName == null) continue;
            if (modelName.equals(enforcedOutputName)) {
                if (outputTypedModels.size() > 1) {
                    throw new CompilerChainException("Ambiguous output domain ''{0}''", enforcedOutputName);
                }
                outputTypedModels.add(typedModel);
            } else {
                inputTypedModels.add(typedModel);
            }
            for (TypedModel dependsOn : QVTcoreUtil.getDependsOns((TypedModel)typedModel)) {
                if (intermediateTypedModels.contains(dependsOn)) continue;
                intermediateTypedModels.add(dependsOn);
            }
        }
        if (outputTypedModels.isEmpty()) {
            throw new CompilerChainException("Unknown output domain ''{0}''", enforcedOutputName);
        }
        inputTypedModels.removeAll(intermediateTypedModels);
        return new QVTuConfiguration(QVTuConfiguration.Mode.ENFORCE, inputTypedModels, intermediateTypedModels, outputTypedModels);
    }

    @Override
    public @NonNull Resource createResource(@NonNull URI uri) throws IOException {
        Resource resource = this.asResourceSet.createResource(uri);
        if (resource == null) {
            throw new IOException("Failed to create " + uri);
        }
        return resource;
    }

    @Override
    public void dispose() {
    }

    public @NonNull Class<? extends Transformer> generate(@NonNull ImperativeTransformation asTransformation, String ... genModelFiles) throws Exception {
        JavaResult javaResult = this.qvti2java((Transformation)asTransformation, genModelFiles);
        return this.java2class(javaResult);
    }

    public @NonNull QVTiEnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public <T> @Nullable T getOption(@NonNull String stepKey, @NonNull CompilerChain.Key<T> optionKey) {
        Map<CompilerChain.Key<Object>, Object> defaultOptions;
        Map<@NonNull CompilerChain.Key<Object>, @Nullable Object> stepOptions = this.options.get(stepKey);
        if (stepOptions == null && !this.options.containsKey(stepOptions)) {
            stepOptions = this.options.get("default");
        }
        Object optionValue = null;
        if (stepOptions != null && (optionValue = stepOptions.get(optionKey)) == null && !this.options.containsKey(optionKey) && (defaultOptions = this.options.get("default")) != null) {
            optionValue = defaultOptions.get(optionKey);
        }
        Object castValue = optionValue;
        return (T)castValue;
    }

    @Override
    public @NonNull URI getURI(@NonNull String stepKey, @NonNull CompilerChain.Key<URI> uriKey) {
        URI uri = (URI)this.getOption(stepKey, URI_KEY);
        return uri != null ? uri : this.prefixURI.appendFileExtension(step2extension.get(stepKey));
    }

    protected @NonNull Class<? extends Transformer> java2class(@NonNull JavaResult javaResult) throws Exception {
        return this.java2classCompilerStep.execute(this.txURI, javaResult);
    }

    protected @NonNull Resource qvtc2qvtm(@NonNull Resource cResource, @NonNull QVTuConfiguration qvtuConfiguration) throws IOException {
        Resource uResource = this.qvtc2qvtuCompilerStep.execute(cResource, qvtuConfiguration);
        return this.qvtu2qvtmCompilerStep.execute(uResource);
    }

    protected @NonNull JavaResult qvti2java(@NonNull Transformation asTransformation, String ... genModelFiles) throws Exception {
        return this.qvti2javaCompilerStep.execute(this.txURI, asTransformation, genModelFiles);
    }

    protected @NonNull ImperativeTransformation qvtm2qvti(@NonNull Resource pResource) throws IOException {
        ScheduledRegion rootRegion = this.qvtm2qvtsCompilerStep.execute(pResource);
        return this.qvts2qvtiCompilerStep.execute(rootRegion);
    }

    @Override
    public void removeListener(@NonNull CompilerChain.Listener listener) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 != null) {
            listeners2.remove(listener);
        }
    }

    @Override
    public void saveResource(@NonNull Resource asResource, @NonNull String stepKey) throws IOException {
        Map<Object, Object> saveOptions = this.getOption(stepKey, CompilerChain.SAVE_OPTIONS_KEY);
        if (saveOptions != null) {
            asResource.save(saveOptions);
        }
        AbstractCompilerChain.assertNoResourceSetErrors(stepKey, asResource);
        if (this.getOption(stepKey, CompilerChain.VALIDATE_KEY) == Boolean.TRUE) {
            AbstractCompilerChain.assertNoValidationErrors(stepKey, asResource);
        }
    }

    @Override
    public <T> void setOption(@NonNull String stepKey, @NonNull CompilerChain.Key<T> optionKey, @Nullable T object) {
        Map<@NonNull CompilerChain.Key<Object>, @Nullable Object> stepOptions = this.options.get(stepKey);
        if (stepOptions == null) {
            stepOptions = new HashMap<CompilerChain.Key<Object>, Object>();
            this.options.put(stepKey, stepOptions);
        }
        Map<@NonNull CompilerChain.Key<Object>, @Nullable Object> stepOptions2 = stepOptions;
        stepOptions2.put(optionKey, object);
    }

    protected static class Java2ClassCompilerStep
    extends AbstractCompilerStep {
        public Java2ClassCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "Class");
        }

        public @NonNull Class<? extends Transformer> execute(@NonNull URI txURI, @NonNull JavaResult javaResult) throws Exception {
            List<String> classpathProjects;
            if (EcorePlugin.IS_ECLIPSE_RUNNING) {
                String projectName = txURI.segment(1);
                classpathProjects = JavaSourceFileObject.createClasspathProjectList(projectName, "org.eclipse.emf.common", "org.eclipse.emf.ecore", "org.eclipse.jdt.annotation", "org.eclipse.ocl.pivot", "org.eclipse.osgi", "org.eclipse.qvtd.runtime");
            } else {
                classpathProjects = null;
            }
            String problemMessage = JavaSourceFileObject.compileClass(javaResult.qualifiedClassName, javaResult.code, javaResult.classPath, classpathProjects);
            if (problemMessage != null) {
                throw new CompilerChainException(problemMessage, new Object[0]);
            }
            File explicitClassPath = new File(javaResult.classPath);
            Class<?> txClass = JavaSourceFileObject.loadExplicitClass(explicitClassPath, javaResult.qualifiedClassName);
            assert (txClass != null);
            this.compiled(txClass);
            return txClass;
        }
    }

    protected static class JavaResult {
        @NonNull File file;
        @NonNull String code;
        @NonNull String qualifiedClassName;
        @NonNull String classPath;

        public JavaResult(@NonNull File file, @NonNull String code, @NonNull String qualifiedClassName, @NonNull String classPath) {
            this.file = file;
            this.code = code;
            this.qualifiedClassName = qualifiedClassName;
            this.classPath = classPath;
        }
    }

    protected static class QVTc2QVTuCompilerStep
    extends AbstractCompilerStep {
        public QVTc2QVTuCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTu");
        }

        public @NonNull Resource execute(@NonNull Resource cResource, @NonNull QVTuConfiguration qvtuConfiguration) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTcEnvironmentFactory.CREATE_STRATEGY);
            try {
                Resource uResource = this.createResource();
                QVTc2QVTu tx = new QVTc2QVTu((EnvironmentFactory)this.environmentFactory, qvtuConfiguration);
                tx.transform(cResource, uResource);
                Resource resource = this.saveResource(uResource);
                return resource;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }

    protected static class QVTi2JavaCompilerStep
    extends AbstractCompilerStep {
        public QVTi2JavaCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "Java");
        }

        protected @NonNull JavaResult execute(@NonNull URI txURI, @NonNull Transformation asTransformation, String ... genModelFiles) throws Exception {
            File explicitClassPath;
            String javaFileName;
            String javaCodeSource;
            Boolean javaIsGeneratedDebug;
            URI genModelURI;
            URI javaURI = this.compilerChain.getURI("Java", URI_KEY);
            URI classURI = this.compilerChain.getURI("Class", URI_KEY);
            ResourceSet resourceSet = this.environmentFactory.getResourceSet();
            resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
            if (genModelFiles != null) {
                String[] stringArray = genModelFiles;
                int n = genModelFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String genModelFile = stringArray[n2];
                    URI resolvedURI = URI.createURI((String)genModelFile).resolve(txURI);
                    this.loadGenModel(resolvedURI);
                    ++n2;
                }
            }
            if ((genModelURI = this.compilerChain.basicGetURI("GenModel", URI_KEY)) != null) {
                URI resolvedURI = genModelURI.resolve(txURI);
                this.loadGenModel(resolvedURI);
            }
            QVTiCodeGenerator cg = new QVTiCodeGenerator(this.environmentFactory, asTransformation);
            QVTiCodeGenOptions options = cg.getOptions();
            options.setUseNullAnnotations(true);
            String javaExtraPrefix = (String)this.compilerChain.getOption("Java", JAVA_EXTRA_PREFIX_KEY);
            if (javaExtraPrefix != null) {
                options.setPackagePrefix(javaExtraPrefix);
            }
            options.setIsGeneratedDebug((javaIsGeneratedDebug = (Boolean)this.compilerChain.getOption("Java", JAVA_GENERATED_DEBUG_KEY)) == Boolean.TRUE);
            Boolean javaIsIncremental = (Boolean)this.compilerChain.getOption("Java", JAVA_INCREMENTAL_KEY);
            options.setIsIncremental(javaIsIncremental == Boolean.TRUE);
            try {
                javaCodeSource = cg.generateClassFile();
            }
            catch (Exception e) {
                CompilerUtil.throwExceptionWithProblems((CodeGenerator)cg, e);
                javaCodeSource = "";
            }
            URI normalizedURI = resourceSet.getURIConverter().normalize(javaURI);
            if (EcorePlugin.IS_ECLIPSE_RUNNING) {
                File binFolder;
                URI createPlatformResourceURI = URI.createPlatformResourceURI((String)"", (boolean)false);
                URI dURI = normalizedURI.deresolve(createPlatformResourceURI);
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(dURI.toString()));
                File file = URIUtil.toFile((java.net.URI)iFile.getLocationURI());
                javaFileName = (String)ClassUtil.nonNullState((Object)file.toString());
                IFile iBinFolder = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(classURI.deresolve(createPlatformResourceURI).toString()));
                explicitClassPath = binFolder = URIUtil.toFile((java.net.URI)iBinFolder.getLocationURI());
            } else {
                javaFileName = (String)ClassUtil.nonNullState((Object)normalizedURI.toFileString());
                URI normalizedClassURI = resourceSet.getURIConverter().normalize(classURI);
                explicitClassPath = new File(normalizedClassURI.toFileString());
            }
            File javaFile = cg.saveSourceFile(javaFileName);
            this.compiled(javaFile);
            return new JavaResult(javaFile, javaCodeSource, cg.getQualifiedName(), String.valueOf(explicitClassPath));
        }

        private void loadGenModel(@NonNull URI genModelURI) {
            ResourceSet resourceSet = this.environmentFactory.getResourceSet();
            PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
            Resource csGenResource = resourceSet.getResource(genModelURI, true);
            for (EObject eObject : csGenResource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                GenModel genModel = (GenModel)eObject;
                genModel.reconcile();
                metamodelManager.addGenModel(genModel);
            }
        }
    }

    protected static class QVTm2QVTsCompilerStep
    extends AbstractCompilerStep {
        public QVTm2QVTsCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTs");
            QVTm2QVTs.DEBUG_GRAPHS.setState(this.getOption(CompilerChain.DEBUG_KEY) == Boolean.TRUE);
        }

        public @NonNull ScheduledRegion execute(@NonNull Resource pResource) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTcEnvironmentFactory.CREATE_STRATEGY);
            try {
                Resource sResource = this.createResource();
                Map<@NonNull CompilerChain.Key<? extends Object>, @Nullable Object> schedulerOptions = this.getOption(CompilerChain.SCHEDULER_OPTIONS_KEY);
                Transformation asTransformation = AbstractCompilerChain.getTransformation(pResource);
                QVTm2QVTs qvtm2qvts = new QVTm2QVTs(this, (EnvironmentFactory)this.environmentFactory, asTransformation, schedulerOptions);
                List<@NonNull Region> activeRegions = qvtm2qvts.transform();
                this.throwCompilerChainExceptionForErrors();
                String rootName = (String)ClassUtil.nonNullState((Object)asTransformation.eResource().getURI().trimFileExtension().trimFileExtension().lastSegment());
                QVTs2QVTs qvts2qvts = new QVTs2QVTs(this, qvtm2qvts, rootName);
                ScheduledRegion scheduledRegion = qvts2qvts.transform(qvtm2qvts, activeRegions);
                ScheduleManager scheduleManager = RegionUtil.getScheduleManager((Region)scheduledRegion);
                this.throwCompilerChainExceptionForErrors();
                sResource.getContents().add((Object)scheduleManager.getScheduleModel());
                this.saveResource(sResource);
                ScheduledRegion scheduledRegion2 = scheduledRegion;
                return scheduledRegion2;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }

    protected static class QVTs2QVTiCompilerStep
    extends AbstractCompilerStep {
        public QVTs2QVTiCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTi");
        }

        public @NonNull ImperativeTransformation execute(@NonNull ScheduledRegion rootRegion) throws IOException {
            Resource iResource = this.createResource();
            QVTs2QVTi tx = new QVTs2QVTi(this, this.environmentFactory);
            Model model = tx.transform(rootRegion);
            iResource.getContents().add((Object)model);
            this.saveResource(iResource);
            ImperativeTransformation transformation = (ImperativeTransformation)AbstractCompilerChain.getTransformation(iResource);
            this.throwCompilerChainExceptionForErrors();
            return transformation;
        }
    }

    protected static class QVTu2QVTmCompilerStep
    extends AbstractCompilerStep {
        public QVTu2QVTmCompilerStep(@NonNull CompilerChain compilerChain) {
            super(compilerChain, "QVTm");
        }

        public @NonNull Resource execute(@NonNull Resource uResource) throws IOException {
            QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = this.environmentFactory.setCreateStrategy(QVTcEnvironmentFactory.CREATE_STRATEGY);
            try {
                Resource mResource = this.createResource();
                QVTu2QVTm tx = new QVTu2QVTm((EnvironmentFactory)this.environmentFactory);
                tx.transform(uResource, mResource);
                Resource resource = this.saveResource(mResource);
                return resource;
            }
            finally {
                this.environmentFactory.setCreateStrategy(savedStrategy);
            }
        }
    }
}

