/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching.aut;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.launching.events.AutBundleState;
import org.eclipse.rcptt.internal.launching.aut.BaseAut;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.launching.aut.BaseAutManager;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchListener;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.AutListener;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.ui.launching.aut.AutElement;
import org.eclipse.rcptt.ui.launching.aut.AutLaunchElement;
import org.eclipse.swt.widgets.Control;

public class AutContentProvider
implements ITreeContentProvider,
AutListener,
AutLaunchListener {
    private Viewer viewer;
    private List<AutElement> elements = new ArrayList<AutElement>();

    public AutContentProvider() {
        AutManager.INSTANCE.addListener((AutListener)this);
        this.build();
    }

    public void dispose() {
        AutManager.INSTANCE.removeListener((AutListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (this.elements.size() > 0) {
            viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AutContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection(AutContentProvider.this.elements.get(0)));
                }
            });
        }
    }

    public void autAdded(Aut aut) {
        this.refresh();
    }

    public void autRemoved(Aut aut) {
        this.refresh();
    }

    public void autChanged(Aut aut) {
        this.refresh();
    }

    public void launchAdded(AutLaunch launch) {
        this.refresh();
    }

    public void launchRemoved(AutLaunch launch) {
        this.refresh();
    }

    public void stateChanged(AutLaunch launch, AutLaunchState state) {
        this.refresh();
    }

    private void refresh() {
        final Control control = this.viewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        AutElement prevElement = AutContentProvider.this.getElement();
                        AutContentProvider.this.build();
                        AutContentProvider.this.viewer.refresh();
                        if (prevElement != null) {
                            ILaunchConfiguration config = prevElement.getAut().getConfig();
                            for (AutElement element : AutContentProvider.this.elements) {
                                if (!config.equals(element.getAut().getConfig())) continue;
                                AutContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
                                break;
                            }
                        }
                    }
                }
            });
        }
    }

    private void build() {
        for (AutElement element : this.elements) {
            if (!(element instanceof AutLaunchElement)) continue;
            ((AutLaunchElement)element).getLaunch().removeListener((AutLaunchListener)this);
        }
        this.elements.clear();
        List auts = AutManager.INSTANCE.getAuts();
        for (Aut aut : auts) {
            List launches = aut.getLaunches();
            boolean haveLaunches = false;
            for (AutLaunch launch : launches) {
                if (launch.getState() == AutLaunchState.TERMINATE) continue;
                this.elements.add(new AutLaunchElement(launch));
                launch.addListener((AutLaunchListener)this);
                haveLaunches = true;
            }
            if (haveLaunches) continue;
            this.elements.add(new AutElement(aut));
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.elements.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (Q7Features.supportBundlesInApplications) {
            if (parentElement instanceof AutElement) {
                List bundles;
                AutElement ale = (AutElement)parentElement;
                Aut aut = ale.getAut();
                ArrayList<Bundles> result = new ArrayList<Bundles>();
                BaseAutLaunch launch = BaseAutManager.INSTANCE.getCurrentLaunch((BaseAut)aut);
                if (launch != null && (bundles = launch.getBundles()) != null) {
                    Bundles bb = new Bundles();
                    bb.launch = launch;
                    result.add(bb);
                }
                if (result.size() > 0) {
                    return result.toArray();
                }
            }
            if (parentElement instanceof Bundles) {
                List bndls = ((Bundles)parentElement).launch.getBundles();
                return bndls != null ? bndls.toArray() : null;
            }
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element) != null;
    }

    private AutElement getElement() {
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof AutElement) {
            return (AutElement)element;
        }
        return null;
    }

    public void autStarted(AutLaunch baseAutLaunch, int eclPort, int teslaPort) {
        this.refresh();
    }

    public void autInit(AutLaunch baseAutLaunch, List<AutBundleState> bundleState) {
    }

    public void autLocationChange(BaseAutLaunch baseAutLaunch, String location) {
    }

    public static class Bundles {
        BaseAutLaunch launch;
    }
}

