/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.text.NumberFormat;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ValueKeyword;

public final class DoubleValueKeyword
extends ValueKeyword {
    public DoubleValueKeyword(String keyword, String value) {
        super(keyword, value);
    }

    @Override
    protected String createDisplayString(String keyword, String value) {
        String formattedValue = value;
        try {
            double parsedValue = Double.parseDouble(value);
            formattedValue = NumberFormat.getInstance().format(parsedValue);
        }
        catch (NumberFormatException e) {
            Sapphire.service(LoggingService.class).log(e);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(keyword);
        buf.append(" (");
        buf.append(formattedValue);
        buf.append(")");
        return buf.toString();
    }
}

