/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.io.File;
import java.net.URI;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class RelativePathJumpActionHandler
extends JumpActionHandler {
    public static final String ID = "Sapphire.Jump.Path.Relative";

    public RelativePathJumpActionHandler() {
        this.setId(ID);
    }

    @Override
    protected boolean computeEnablementState() {
        File absoluteFile;
        Path absolutePath;
        Property property;
        Path relativePath;
        return super.computeEnablementState() && (relativePath = (Path)((Value)(property = this.property())).content()) != null && (absolutePath = ((RelativePathService)property.service(RelativePathService.class)).convertToAbsolute(relativePath)) != null && (absoluteFile = absolutePath.toFile()).exists() && absoluteFile.isFile();
    }

    @Override
    protected Object run(Presentation context) {
        IWorkbenchWindow window;
        File file;
        Path absolutePath;
        Property property = this.property();
        Path relativePath = (Path)((Value)property).content();
        if (relativePath != null && (absolutePath = ((RelativePathService)property.service(RelativePathService.class)).convertToAbsolute(relativePath)) != null && (file = absolutePath.toFile()).exists() && file.isFile() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage page = window.getActivePage();
            IEditorDescriptor editorDescriptor = null;
            try {
                editorDescriptor = IDE.getEditorDescriptor((String)file.getName());
            }
            catch (PartInitException partInitException) {}
            if (editorDescriptor != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)page, (URI)file.toURI(), (String)editorDescriptor.getId(), (boolean)true);
                }
                catch (PartInitException e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
        }
        return null;
    }
}

