/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure;

import com.google.common.collect.Iterables;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.description.StateMapping;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.LifelineNodeFigure;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.LayoutEditPartConstants;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;

public class ExecutionItemLocator
extends DBorderItemLocator {
    private final IGraphicalEditPart owner;

    public ExecutionItemLocator(IGraphicalEditPart owner, IFigure parentFigure) {
        super(parentFigure);
        this.owner = owner;
        this.setCurrentSideOfParent(16);
        this.setPreferredSideOfParent(16);
    }

    public void relocate(IFigure borderItem) {
        super.relocate(borderItem);
        if (this.isFigureForStateElement(borderItem)) {
            this.centerFigureOnParent(borderItem);
        }
        borderItem.setSize(this.getCollapsedSize(borderItem));
        this.unfix();
    }

    private void centerFigureOnParent(IFigure borderItem) {
        Rectangle parentBounds = this.getParentFigure().getBounds();
        int parentCenter = parentBounds.getCenter().x;
        Rectangle myBounds = borderItem.getBounds().getCopy();
        int x = parentCenter - myBounds.width / 2;
        borderItem.setLocation(new Point(x, myBounds.getLocation().y));
    }

    private boolean isFigureForStateElement(IFigure borderItem) {
        for (IGraphicalEditPart childPart : Iterables.filter((Iterable)this.owner.getChildren(), IGraphicalEditPart.class)) {
            if (childPart.getFigure() != borderItem) continue;
            return this.isStateElement(childPart);
        }
        return false;
    }

    private boolean isStateElement(IGraphicalEditPart childPart) {
        EObject obj = childPart.resolveSemanticElement();
        if (obj instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)obj;
            return dde.getMapping() instanceof StateMapping;
        }
        return false;
    }

    public void setBorderItemOffset(Dimension borderItemOffset) {
        super.setBorderItemOffset(this.getExecutionOffset());
    }

    private Dimension getExecutionOffset() {
        Dimension offset = new Dimension(LayoutEditPartConstants.EXECUTION_BORDER_ITEM_OFFSET);
        Rectangle currentBounds = this.getConstraint();
        IFigure parentFigure = this.getParentFigure();
        if (parentFigure instanceof LifelineNodeFigure) {
            Rectangle parentBounds = parentFigure.getBounds();
            offset.width = parentBounds.width / 2 + currentBounds.width / 2;
        } else if (currentBounds.width == 0) {
            offset.width = 0;
        }
        return offset;
    }

    public void setCurrentSideOfParent(int side) {
        super.setCurrentSideOfParent(16);
    }

    public void setPreferredSideOfParent(int side) {
        super.setPreferredSideOfParent(16);
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Point locateOnParent = super.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        return new Point(locateOnParent.x, suggestedLocation.y);
    }

    protected final Dimension getCollapsedSize(IFigure borderItem) {
        Dimension size = this.getConstraint().getSize().getCopy();
        if (size.height == 0) {
            Dimension preferredSize = borderItem.getPreferredSize();
            size.height = preferredSize != null ? preferredSize.height : 0;
        }
        return size;
    }
}

