/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.steps;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.core.steps.AbstractPeerStep;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.services.FileTransferService;

public class FileTransferStep
extends AbstractPeerStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CorePlugin.getUniqueIdentifier(), "missing or closed channel"));
        }
        Object item = StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.filesystem.core.file_transfer_item", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (!(item instanceof IFileTransferItem)) {
            throw new CoreException((IStatus)new Status(4, CorePlugin.getUniqueIdentifier(), "missing file transfer item"));
        }
    }

    public void execute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        IFileTransferItem item = (IFileTransferItem)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.filesystem.core.file_transfer_item", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (item.isEnabled()) {
            FileTransferService.transfer(this.getActivePeerContext(context, data, fullQualifiedId), channel, item, monitor, callback);
        } else {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    public int getTotalWork(IStepContext context, IPropertiesContainer data) {
        return 1000;
    }
}

