/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filehistory;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSLocalFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;

public class CVSFileHistory
extends FileHistory {
    public static final int REFRESH_LOCAL = 1;
    public static final int REFRESH_REMOTE = 2;
    public static final int REFRESH_ALL = 3;
    private final ICVSFile cvsFile;
    protected IFileRevision[] revisions;
    protected IFileRevision[] remoteRevisions;
    protected IFileRevision[] localRevisions;
    protected boolean includeLocalRevisions;
    protected boolean includeRemoteRevisions;
    protected boolean includesExists;
    protected boolean refetchRevisions;
    private int flag;

    public CVSFileHistory(ICVSFile file) {
        Assert.isNotNull((Object)file);
        this.cvsFile = file;
        this.includeLocalRevisions = false;
        this.includeRemoteRevisions = true;
        this.refetchRevisions = true;
        this.flag = 0;
    }

    public CVSFileHistory(ICVSFile file, int flag) {
        Assert.isNotNull((Object)file);
        this.cvsFile = file;
        this.includeLocalRevisions = false;
        this.includeRemoteRevisions = true;
        this.refetchRevisions = true;
        this.flag = flag;
    }

    public IFileRevision[] getFileRevisions() {
        if (this.revisions == null) {
            return new IFileRevision[0];
        }
        return this.revisions;
    }

    public void refresh(int flags, IProgressMonitor monitor) throws TeamException {
        if (flags == 1) {
            this.fetchLocalOnly(monitor);
            return;
        }
        if (this.refetchRevisions) {
            monitor.beginTask(NLS.bind((String)CVSMessages.CVSFileHistory_0, (Object)this.cvsFile.getRepositoryRelativePath()), 300);
            try {
                String remoteFolderLocation;
                ICVSFolder folder;
                ILogEntry[] entries = this.cvsFile.getLogEntries((IProgressMonitor)new SubProgressMonitor(monitor, 200));
                if (entries.length == 0 && (folder = this.cvsFile.getParent()).isManaged() && (remoteFolderLocation = folder.getRemoteLocation(folder)) != null) {
                    String remoteFileName = remoteFolderLocation.concat("/" + this.cvsFile.getName());
                    CVSTeamProvider pro = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.cvsFile.getIResource().getProject());
                    if (pro != null) {
                        CVSWorkspaceRoot root = pro.getCVSWorkspaceRoot();
                        CVSRepositoryLocation location = CVSRepositoryLocation.fromString(root.getRemoteLocation().getLocation(false));
                        RemoteFile remFile = RemoteFile.create(remoteFileName, location);
                        entries = remFile.getLogEntries(monitor);
                    }
                }
                if (this.flag == 1) {
                    String revisionNumber = this.cvsFile.getSyncInfo().getRevision();
                    int i = 0;
                    while (i < entries.length) {
                        if (entries[i].getRevision().equals(revisionNumber)) {
                            this.remoteRevisions = new IFileRevision[]{new CVSFileRevision(entries[i])};
                            this.revisions = new IFileRevision[1];
                            System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                        }
                        ++i;
                    }
                }
                if (this.flag == 2) {
                    CVSTag tempTag = this.cvsFile.getSyncInfo().getTag();
                    ArrayList<ILogEntry> entriesOfInterest = new ArrayList<ILogEntry>();
                    int i = 0;
                    while (i < entries.length) {
                        CVSTag[] tags = entries[i].getTags();
                        int j = 0;
                        while (j < tags.length) {
                            if (tags[j].getType() == tempTag.getType()) {
                                if (tempTag.getType() == 1 && tempTag.getName().equals(tags[j].getName())) {
                                    entriesOfInterest.add(entries[i]);
                                    break;
                                }
                                entriesOfInterest.add(entries[i]);
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    this.remoteRevisions = new IFileRevision[entriesOfInterest.size()];
                    Iterator iter = entriesOfInterest.iterator();
                    int i2 = 0;
                    while (iter.hasNext()) {
                        this.remoteRevisions[i2++] = new CVSFileRevision((ILogEntry)iter.next());
                    }
                    this.revisions = new IFileRevision[this.remoteRevisions.length];
                    System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                }
                this.localRevisions = new IFileRevision[0];
                IResource localResource = this.cvsFile.getIResource();
                this.includesExists = false;
                if (localResource != null && localResource instanceof IFile) {
                    try {
                        IFileState[] localHistoryState = ((IFile)localResource).getHistory((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        this.localRevisions = this.convertToFileRevision(localHistoryState, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        this.includesExists = this.localRevisions.length > 0;
                    }
                    catch (CoreException e) {
                        TeamException.asTeamException((CoreException)e);
                    }
                }
                this.remoteRevisions = new IFileRevision[entries.length];
                int i = 0;
                while (i < entries.length) {
                    this.remoteRevisions[i] = new CVSFileRevision(entries[i]);
                    ++i;
                }
                this.revisions = new IFileRevision[0];
                this.arrangeRevisions();
            }
            finally {
                monitor.done();
            }
        } else {
            this.arrangeRevisions();
        }
    }

    private void arrangeRevisions() {
        if (this.revisions != null) {
            if (this.includeLocalRevisions && this.includeRemoteRevisions) {
                this.revisions = new IFileRevision[this.remoteRevisions.length + this.localRevisions.length];
                System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                System.arraycopy(this.localRevisions, 0, this.revisions, this.remoteRevisions.length, this.localRevisions.length);
            } else if (this.includeLocalRevisions) {
                this.revisions = new IFileRevision[this.localRevisions.length];
                System.arraycopy(this.localRevisions, 0, this.revisions, 0, this.localRevisions.length);
            } else if (this.includeRemoteRevisions) {
                this.revisions = new IFileRevision[this.remoteRevisions.length];
                System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
            }
        }
    }

    public IFileRevision getFileRevision(String id) {
        IFileRevision[] revisions = this.getFileRevisions();
        int i = 0;
        while (i < revisions.length) {
            if (revisions[i].getContentIdentifier().equals(id)) {
                return revisions[i];
            }
            ++i;
        }
        return null;
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        IFileRevision[] revisions = this.getFileRevisions();
        IFileRevision fileRevision = null;
        int i = 0;
        while (i < revisions.length) {
            if (((CVSFileRevision)revisions[i]).isPredecessorOf(revision)) {
                if (fileRevision == null) {
                    fileRevision = revisions[i];
                }
                if (revisions[i].getTimestamp() > fileRevision.getTimestamp()) {
                    fileRevision = revisions[i];
                }
            }
            ++i;
        }
        if (fileRevision == null) {
            return new IFileRevision[0];
        }
        return new IFileRevision[]{fileRevision};
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        IFileRevision[] revisions = this.getFileRevisions();
        ArrayList<IFileRevision> directDescendents = new ArrayList<IFileRevision>();
        int i = 0;
        while (i < revisions.length) {
            if (((CVSFileRevision)revisions[i]).isDescendentOf(revision)) {
                directDescendents.add(revisions[i]);
            }
            ++i;
        }
        return directDescendents.toArray(new IFileRevision[directDescendents.size()]);
    }

    private IFileRevision[] convertToFileRevision(IFileState[] localRevisions, IProgressMonitor monitor) {
        boolean modified = false;
        try {
            modified = this.cvsFile.isModified(monitor);
        }
        catch (CVSException cVSException) {}
        IFile localFile = (IFile)this.cvsFile.getIResource();
        boolean localFileExists = localFile != null && localFile.exists();
        int arrayLength = 0;
        if (modified && localFileExists) {
            ++arrayLength;
        }
        IFileRevision[] fileRevisions = new IFileRevision[arrayLength += localRevisions.length];
        int i = 0;
        while (i < localRevisions.length) {
            IFileState localFileState = localRevisions[i];
            CVSLocalFileRevision localRevision = new CVSLocalFileRevision(localFileState);
            fileRevisions[i] = localRevision;
            ++i;
        }
        if (modified && localFileExists) {
            CVSLocalFileRevision currentFile = new CVSLocalFileRevision(localFile);
            CVSFileHistoryProvider provider = new CVSFileHistoryProvider();
            currentFile.setBaseRevision(provider.getWorkspaceFileRevision((IResource)localFile));
            fileRevisions[localRevisions.length] = currentFile;
        }
        return fileRevisions;
    }

    public void includeLocalRevisions(boolean flag) {
        this.includeLocalRevisions = flag;
    }

    public boolean getIncludesExists() {
        return this.includesExists;
    }

    public void setRefetchRevisions(boolean refetch) {
        this.refetchRevisions = refetch;
    }

    public void includeRemoteRevisions(boolean flag) {
        this.includeRemoteRevisions = flag;
    }

    public void fetchLocalOnly(IProgressMonitor monitor) {
        try {
            try {
                this.localRevisions = new IFileRevision[0];
                IResource localResource = this.cvsFile.getIResource();
                this.includesExists = false;
                if (localResource != null && localResource instanceof IFile) {
                    IFileState[] localHistoryState = ((IFile)localResource).getHistory((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.localRevisions = this.convertToFileRevision(localHistoryState, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    boolean bl = this.includesExists = this.localRevisions.length > 0;
                }
                if (this.remoteRevisions == null) {
                    this.remoteRevisions = new IFileRevision[0];
                }
                this.revisions = new IFileRevision[0];
                this.arrangeRevisions();
            }
            catch (CoreException coreException) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isInitialized() {
        return this.revisions != null;
    }

    public boolean isIncludeLocal() {
        return this.includeLocalRevisions;
    }
}

