/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;

public class SingleFileTagSource
extends TagSource {
    private ICVSFile file;
    private TagSource parentFolderTagSource;

    public static CVSTag[] fetchTagsFor(ICVSFile file, IProgressMonitor monitor) throws TeamException {
        HashSet<CVSTag> tagSet = new HashSet<CVSTag>();
        ILogEntry[] entries = file.getLogEntries(monitor);
        int j = 0;
        while (j < entries.length) {
            CVSTag[] tags = entries[j].getTags();
            int k = 0;
            while (k < tags.length) {
                tagSet.add(tags[k]);
                ++k;
            }
            ++j;
        }
        return tagSet.toArray(new CVSTag[tagSet.size()]);
    }

    public SingleFileTagSource(ICVSFile file) {
        this.file = file;
        this.parentFolderTagSource = TagSource.create(new ICVSResource[]{file.getParent()});
    }

    @Override
    public CVSTag[] getTags(int type) {
        return this.parentFolderTagSource.getTags(type);
    }

    @Override
    public CVSTag[] refresh(boolean bestEffort, IProgressMonitor monitor) throws TeamException {
        CVSTag[] tags = SingleFileTagSource.fetchTagsFor(this.file, monitor);
        this.commit(tags, false, monitor);
        this.fireChange();
        return tags;
    }

    @Override
    public ICVSRepositoryLocation getLocation() {
        RepositoryManager mgr = CVSUIPlugin.getPlugin().getRepositoryManager();
        ICVSRepositoryLocation location = mgr.getRepositoryLocationFor((ICVSResource)this.file);
        return location;
    }

    @Override
    public String getShortDescription() {
        return this.file.getName();
    }

    @Override
    public void commit(CVSTag[] tags, boolean replace, IProgressMonitor monitor) throws CVSException {
        this.parentFolderTagSource.commit(tags, replace, monitor);
        this.fireChange();
    }

    @Override
    public ICVSResource[] getCVSResources() {
        return new ICVSResource[]{this.file};
    }
}

