/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.ui.SVNUIMessages;

public class TagModifyWarningDialog
extends MessageDialog {
    protected final IProject[] projects;
    protected boolean dontAskAnyMore;

    public TagModifyWarningDialog(Shell parentShell, IProject[] projects) {
        super(parentShell, SVNUIMessages.TagModifyWarningDialog_Title, null, SVNUIMessages.TagModifyWarningDialog_Message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.projects = projects;
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        final Button dontAskButton = new Button(composite, 32);
        dontAskButton.setLayoutData((Object)new GridData());
        dontAskButton.setText(SVNUIMessages.TagModifyWarningDialog_CustomText);
        dontAskButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TagModifyWarningDialog.this.dontAskAnyMore = dontAskButton.getSelection();
            }
        });
        this.dontAskAnyMore = false;
        dontAskButton.setSelection(false);
        return composite;
    }

    public boolean close() {
        if (this.dontAskAnyMore) {
            IProject[] iProjectArray = this.projects;
            int n = this.projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.svn.core.svnnature");
                try {
                    provider.setVerifyTagOnCommit(!this.dontAskAnyMore);
                }
                catch (CoreException e) {
                    LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)e);
                }
                ++n2;
            }
        }
        return super.close();
    }
}

