/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JavaCodeGenerator;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.ObjectData;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.SlowParser;

class FieldLoader {
    private final String fieldName;
    private final int fieldPosInArray;
    private final SlowParser<?> slowParser;
    private final boolean isOptional;

    FieldLoader(int fieldPosInArray, String fieldName, SlowParser<?> slowParser, boolean isOptional) {
        this.fieldName = fieldName;
        this.fieldPosInArray = fieldPosInArray;
        this.slowParser = slowParser;
        this.isOptional = isOptional;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void parse(boolean hasValue, Object value, ObjectData objectData) throws JsonProtocolParseException {
        if (hasValue) {
            try {
                objectData.getFieldArray()[this.fieldPosInArray] = this.slowParser.parseValue(value, objectData);
            }
            catch (JsonProtocolParseException e) {
                throw new JsonProtocolParseException("Failed to parse field " + this.getFieldName(), e);
            }
        } else if (!this.isOptional) {
            throw new JsonProtocolParseException("Field is not optional: " + this.getFieldName());
        }
    }

    public void writeFieldDeclarationJava(JavaCodeGenerator.ClassScope scope) {
        scope.startLine("private final ");
        this.slowParser.appendFinishedValueTypeNameJava(scope);
        scope.append(" field_" + this.fieldName + ";\n");
    }

    public void writeFieldLoadJava(JavaCodeGenerator.MethodScope scope, String valueRef, String hasValueRef) {
        scope.startLine("if (" + hasValueRef + ") {\n");
        scope.indentRight();
        if (this.slowParser.javaCodeThrowsException()) {
            scope.startLine("try {\n");
            scope.indentRight();
            String parsedValueRef = scope.newMethodScopedName("parsedValue");
            this.slowParser.writeParseCode(scope, valueRef, "this", parsedValueRef);
            scope.startLine("this.field_" + this.fieldName + " = " + parsedValueRef + ";\n");
            scope.indentLeft();
            scope.startLine("} catch (org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException e) {\n");
            scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Failed to parse field " + this.getFieldName() + "\", e);\n");
            scope.startLine("}\n");
        } else {
            String parsedValueRef = scope.newMethodScopedName("parsedValue");
            this.slowParser.writeParseCode(scope, valueRef, "this", parsedValueRef);
            scope.startLine("this.field_" + this.fieldName + " = " + parsedValueRef + ";\n");
        }
        scope.indentLeft();
        scope.startLine("} else {\n");
        if (this.isOptional) {
            scope.startLine("  this.field_" + this.fieldName + " = null;\n");
        } else {
            scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Field is not optional: " + this.getFieldName() + "\");\n");
        }
        scope.startLine("}\n");
    }
}

