/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.labeling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImages2;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XbaseLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private XbaseImages2 images;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    private CommonTypeComputationServices services;

    @Inject
    public XbaseLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected ImageDescriptor _imageDescriptor(XImportSection importSection) {
        return this.images.forImportContainer();
    }

    protected ImageDescriptor _imageDescriptor(XImportDeclaration importDeclaration) {
        return this.images.forImport();
    }

    protected ImageDescriptor _imageDescriptor(JvmGenericType genericType) {
        ImageDescriptor _xifexpression = null;
        boolean _isInterface = genericType.isInterface();
        _xifexpression = _isInterface ? this.images.forInterface(genericType.getVisibility(), this.adornments.get((JvmIdentifiableElement)genericType)) : this.images.forClass(genericType.getVisibility(), this.adornments.get((JvmIdentifiableElement)genericType));
        return _xifexpression;
    }

    protected ImageDescriptor _imageDescriptor(JvmEnumerationType enumerationType) {
        return this.images.forEnum(enumerationType.getVisibility(), this.adornments.get((JvmIdentifiableElement)enumerationType));
    }

    protected ImageDescriptor _imageDescriptor(JvmAnnotationType annotationType) {
        return this.images.forAnnotation(annotationType.getVisibility(), this.adornments.get((JvmIdentifiableElement)annotationType));
    }

    protected String text(JvmGenericType genericType) {
        return genericType.getSimpleName();
    }

    protected ImageDescriptor _imageDescriptor(JvmOperation operation) {
        return this.images.forOperation(operation.getVisibility(), this.adornments.get((JvmIdentifiableElement)operation));
    }

    protected ImageDescriptor _imageDescriptor(IResolvedOperation operation) {
        return this.imageDescriptor(operation.getDeclaration());
    }

    protected Object text(JvmOperation element) {
        return this.signature(element.getSimpleName(), (JvmIdentifiableElement)element);
    }

    protected Object text(IResolvedOperation element) {
        boolean _not;
        String returnTypeString = element.getResolvedReturnType().getSimpleName();
        String decoratedPart = " : " + returnTypeString;
        boolean _isEmpty = element.getTypeParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _plus_2;
            String _string = this.uiStrings.toString((Iterable)element.getTypeParameters());
            String _plus = " <" + _string;
            String _plus_1 = String.valueOf(_plus) + "> : ";
            decoratedPart = _plus_2 = String.valueOf(_plus_1) + returnTypeString;
        }
        String _simpleName = element.getDeclaration().getSimpleName();
        String _plus_3 = String.valueOf(_simpleName) + "(";
        Functions.Function1 _function = it -> it.getHumanReadableName();
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)element.getResolvedParameterTypes(), (Functions.Function1)_function), (CharSequence)", ");
        String _plus_4 = String.valueOf(_plus_3) + _join;
        String _plus_5 = String.valueOf(_plus_4) + ")";
        StyledString _styledString = new StyledString(_plus_5);
        StyledString _styledString_1 = new StyledString(decoratedPart, StyledString.DECORATIONS_STYLER);
        return _styledString.append(_styledString_1);
    }

    protected ImageDescriptor _imageDescriptor(JvmConstructor constructor) {
        return this.images.forConstructor(constructor.getVisibility(), this.adornments.get((JvmIdentifiableElement)constructor));
    }

    protected String text(JvmConstructor constructor) {
        String _parameters = this.uiStrings.parameters((JvmIdentifiableElement)constructor);
        return "new" + _parameters;
    }

    protected ImageDescriptor _imageDescriptor(IResolvedConstructor constructor) {
        return this._imageDescriptor(constructor.getDeclaration());
    }

    protected Object text(IResolvedConstructor constructor) {
        Functions.Function1 _function = it -> it.getHumanReadableName();
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)constructor.getResolvedParameterTypes(), (Functions.Function1)_function), (CharSequence)", ");
        String _plus = "new(" + _join;
        String _plus_1 = String.valueOf(_plus) + ")";
        return new StyledString(_plus_1);
    }

    protected ImageDescriptor _imageDescriptor(IResolvedField field) {
        return this._imageDescriptor(field.getDeclaration());
    }

    protected Object text(IResolvedField field) {
        String _simpleSignature = field.getSimpleSignature();
        String _plus = String.valueOf(_simpleSignature) + " : ";
        String _humanReadableName = field.getResolvedType().getHumanReadableName();
        String _plus_1 = String.valueOf(_plus) + _humanReadableName;
        return new StyledString(_plus_1);
    }

    protected ImageDescriptor _imageDescriptor(JvmField field) {
        return this.images.forField(field.getVisibility(), this.adornments.get((JvmIdentifiableElement)field));
    }

    protected Object text(JvmField field) {
        String _simpleName = field.getSimpleName();
        String _plus = String.valueOf(_simpleName) + " : ";
        String _simpleName_1 = field.getType().getSimpleName();
        return String.valueOf(_plus) + _simpleName_1;
    }

    protected ImageDescriptor _imageDescriptor(JvmFormalParameter parameter) {
        return this.images.forLocalVariable(this.adornments.get((JvmIdentifiableElement)parameter));
    }

    protected String text(JvmFormalParameter parameter) {
        String _xblockexpression = null;
        JvmTypeReference parameterType = parameter.getParameterType();
        String _xifexpression = null;
        if (parameterType == null) {
            _xifexpression = parameter.getName();
        } else {
            String _simpleName = parameterType.getSimpleName();
            String _plus = String.valueOf(_simpleName) + " ";
            String _name = parameter.getName();
            _xifexpression = String.valueOf(_plus) + _name;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ImageDescriptor _imageDescriptor(XVariableDeclaration variableDeclaration) {
        return this.images.forLocalVariable(this.adornments.get((JvmIdentifiableElement)variableDeclaration));
    }

    protected String text(XImportDeclaration it) {
        StringConcatenation _builder = new StringConcatenation();
        String _importedTypeName = it.getImportedTypeName();
        _builder.append(_importedTypeName);
        boolean _isWildcard = it.isWildcard();
        if (_isWildcard) {
            _builder.append(".*");
        } else {
            boolean _tripleNotEquals;
            String _memberName = it.getMemberName();
            boolean bl = _tripleNotEquals = _memberName != null;
            if (_tripleNotEquals) {
                _builder.append(".");
                String _memberName_1 = it.getMemberName();
                _builder.append(_memberName_1);
            }
        }
        return _builder.toString();
    }

    protected String text(XImportSection importSection) {
        return "import declarations";
    }

    protected String text(XVariableDeclaration variableDeclaration) {
        String _xblockexpression = null;
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)variableDeclaration);
        LightweightTypeReference type = resolvedTypes.getActualType((JvmIdentifiableElement)variableDeclaration);
        String _xifexpression = null;
        if (type != null) {
            String _humanReadableName = type.getHumanReadableName();
            String _plus = String.valueOf(_humanReadableName) + " ";
            String _name = variableDeclaration.getName();
            _xifexpression = String.valueOf(_plus) + _name;
        } else {
            _xifexpression = variableDeclaration.getName();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ImageDescriptor _imageDescriptor(JvmTypeParameter parameter) {
        return this.images.forTypeParameter(this.adornments.get((JvmIdentifiableElement)parameter));
    }

    protected StyledString signature(String simpleName, JvmIdentifiableElement element) {
        boolean _notEquals;
        JvmTypeReference _xifexpression = null;
        if (element instanceof JvmOperation) {
            _xifexpression = ((JvmOperation)element).getReturnType();
        } else {
            JvmTypeReference _xifexpression_1 = null;
            _xifexpression_1 = element instanceof JvmField ? ((JvmField)element).getType() : null;
            _xifexpression = _xifexpression_1;
        }
        JvmTypeReference returnType = _xifexpression;
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)element);
        String _xifexpression_2 = null;
        _xifexpression_2 = returnType == null ? "void" : owner.toLightweightTypeReference(returnType).getHumanReadableName();
        String returnTypeString = _xifexpression_2;
        String decoratedPart = " : " + returnTypeString;
        String _elvis = null;
        String _typeParameters = this.uiStrings.typeParameters(element);
        _elvis = _typeParameters != null ? _typeParameters : "";
        String typeParam = _elvis;
        boolean bl = _notEquals = !Objects.equal((Object)typeParam, (Object)"");
        if (_notEquals) {
            decoratedPart = " " + typeParam + " : " + returnTypeString;
        }
        String _parameters = this.uiStrings.parameters(element);
        String _plus = String.valueOf(simpleName) + _parameters;
        StyledString _styledString = new StyledString(_plus);
        StyledString _styledString_1 = new StyledString(decoratedPart, StyledString.DECORATIONS_STYLER);
        return _styledString.append(_styledString_1);
    }

    protected ImageDescriptor _imageDescriptor(Object element) {
        return null;
    }

    protected Object doGetImage(Object element) {
        Object _elvis = null;
        ImageDescriptor _imageDescriptor = null;
        if (element != null) {
            _imageDescriptor = this.imageDescriptor(element);
        }
        if (_imageDescriptor != null) {
            _elvis = _imageDescriptor;
        } else {
            Object _doGetImage = super.doGetImage(element);
            _elvis = _doGetImage;
        }
        return _elvis;
    }

    protected IBatchTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    protected ImageDescriptor imageDescriptor(Object constructor) {
        if (constructor instanceof JvmConstructor) {
            return this._imageDescriptor((JvmConstructor)constructor);
        }
        if (constructor instanceof JvmOperation) {
            return this._imageDescriptor((JvmOperation)constructor);
        }
        if (constructor instanceof JvmAnnotationType) {
            return this._imageDescriptor((JvmAnnotationType)constructor);
        }
        if (constructor instanceof JvmEnumerationType) {
            return this._imageDescriptor((JvmEnumerationType)constructor);
        }
        if (constructor instanceof JvmField) {
            return this._imageDescriptor((JvmField)constructor);
        }
        if (constructor instanceof JvmGenericType) {
            return this._imageDescriptor((JvmGenericType)constructor);
        }
        if (constructor instanceof JvmTypeParameter) {
            return this._imageDescriptor((JvmTypeParameter)constructor);
        }
        if (constructor instanceof JvmFormalParameter) {
            return this._imageDescriptor((JvmFormalParameter)constructor);
        }
        if (constructor instanceof XVariableDeclaration) {
            return this._imageDescriptor((XVariableDeclaration)constructor);
        }
        if (constructor instanceof IResolvedConstructor) {
            return this._imageDescriptor((IResolvedConstructor)constructor);
        }
        if (constructor instanceof IResolvedOperation) {
            return this._imageDescriptor((IResolvedOperation)constructor);
        }
        if (constructor instanceof XImportDeclaration) {
            return this._imageDescriptor((XImportDeclaration)constructor);
        }
        if (constructor instanceof XImportSection) {
            return this._imageDescriptor((XImportSection)constructor);
        }
        if (constructor instanceof IResolvedField) {
            return this._imageDescriptor((IResolvedField)constructor);
        }
        if (constructor != null) {
            return this._imageDescriptor(constructor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(constructor).toString());
    }
}

