/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.xml;

import java.io.ByteArrayInputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.xwt.IDataProvider;
import org.eclipse.xwt.dataproviders.AbstractDataProvider;
import org.eclipse.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.xwt.xml.IXmlDataProvider;
import org.eclipse.xwt.xml.XmlObservableValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlDataProvider
extends AbstractDataProvider
implements IXmlDataProvider {
    static IDataProvider.DataModelService dataModelService = new IDataProvider.DataModelService(){

        public Object toModelType(Object data) {
            throw new UnsupportedOperationException();
        }

        public Object loadModelType(String className) {
            throw new UnsupportedOperationException();
        }

        public Object toModelPropertyType(Object object, String propertyName) {
            throw new UnsupportedOperationException();
        }
    };
    static final String XDATA = "XData";
    private URL source;
    private String path;
    private Document document;

    public Document getDocument() {
        if (this.document == null) {
            try {
                String xdata;
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                if (this.source != null) {
                    this.document = builder.parse(this.source.openStream());
                }
                if ((xdata = this.getXDataContent()) != null) {
                    try {
                        this.document = builder.parse(new ByteArrayInputStream(xdata.getBytes()));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.document;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setSource(URL xmlSource) {
        this.source = xmlSource;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    private Object getRoot() {
        Document doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        if (this.path != null) {
            return this.selectSingleNode(doc, this.path);
        }
        return doc;
    }

    private Object selectSingleNode(Node node, String path) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile(path);
            return expr.evaluate(node, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getData(Object object, String path) {
        if (object == null || path == null) {
            return null;
        }
        if (object instanceof Node) {
            Object selectObject = this.selectSingleNode((Node)object, path);
            return selectObject;
        }
        return object;
    }

    public Object getData(String path) {
        return this.getData(this.getRoot(), path);
    }

    public void setData(Object object, String path, Object value) {
    }

    public void setData(String path, Object value) {
    }

    public Class<?> getDataType(String path) {
        Object data = this.getData(path);
        if (data == null) {
            return null;
        }
        return data.getClass();
    }

    public IValueProperty observeValueProperty(Object valueType, String path, UpdateSourceTrigger updateSourceTrigger) {
        return null;
    }

    protected IObservableValue observeValue(Object bean, String propertyName) {
        Object data = this.getData(propertyName);
        if (data != null && data instanceof Node) {
            Class<?> valueType = data.getClass();
            return new XmlObservableValue(valueType, (Node)data, this.path);
        }
        return null;
    }

    protected IObservableValue observeDetailValue(IObservableValue bean, Object ownerType, String propertyName, Object propertyType) {
        return null;
    }

    protected String getXDataContent() {
        Object xDataProperty = this.getProperty(XDATA);
        if (xDataProperty != null) {
            return xDataProperty.toString();
        }
        return null;
    }

    protected void setXDataContent(Object content) {
        this.setProperty(XDATA, content);
    }

    public IDataProvider.DataModelService getModelService() {
        return dataModelService;
    }
}

