/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.tab;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.tab.EntryPointTypeSelectionDialog;
import org.eclipse.rap.ui.internal.launch.rwt.tab.HelpContextIds;
import org.eclipse.rap.ui.internal.launch.rwt.tab.RWTLaunchTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class EntryPointSection
extends RWTLaunchTab {
    private static final int MARGIN = 20;
    private Button rbWebXml;
    private Button rbEntryPoint;
    private Label lblWebXmlLocation;
    private Text txtWebXmlLocation;
    private Label lblServletName;
    private Text txtServletName;
    private Button btnSelectWebXml;
    private Label lblEntryPointClass;
    private Text txtEntryPointClass;
    private Button btnSelectEntryPointClass;

    public String getName() {
        return "Application entry eoint";
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Application entry point");
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        this.rbEntryPoint = this.createRadioButton((Composite)group, "Run entry point class");
        this.rbEntryPoint.setLayoutData((Object)EntryPointSection.newGridData(3, 0));
        this.rbEntryPoint.addSelectionListener((SelectionListener)new EntryPointSelectionListener());
        this.lblEntryPointClass = this.createLabel((Composite)group, "Class name");
        this.lblEntryPointClass.setLayoutData((Object)EntryPointSection.newGridData(0, 20));
        this.txtEntryPointClass = new Text((Composite)group, 2048);
        this.txtEntryPointClass.setLayoutData((Object)EntryPointSection.newFillHorizontalGridData());
        this.txtEntryPointClass.addModifyListener((ModifyListener)new TextModifyListener());
        this.btnSelectEntryPointClass = this.createPushButton((Composite)group, "Search...", null);
        EntryPointClassSelectionListener listener = new EntryPointClassSelectionListener();
        this.btnSelectEntryPointClass.addSelectionListener((SelectionListener)listener);
        this.rbWebXml = this.createRadioButton((Composite)group, "Run from web.xml");
        this.rbWebXml.setLayoutData((Object)EntryPointSection.newGridData(3, 0));
        this.rbWebXml.addSelectionListener((SelectionListener)new EntryPointSelectionListener());
        this.rbWebXml.setSelection(true);
        this.lblWebXmlLocation = this.createLabel((Composite)group, "Location");
        this.lblWebXmlLocation.setLayoutData((Object)EntryPointSection.newGridData(0, 20));
        this.txtWebXmlLocation = new Text((Composite)group, 2048);
        this.txtWebXmlLocation.setLayoutData((Object)EntryPointSection.newFillHorizontalGridData());
        this.txtWebXmlLocation.addModifyListener((ModifyListener)new TextModifyListener());
        this.btnSelectWebXml = this.createPushButton((Composite)group, "Search...", null);
        this.btnSelectWebXml.addSelectionListener((SelectionListener)new WebXmlSelectionListener());
        this.lblServletName = this.createLabel((Composite)group, "Servlet path");
        this.lblServletName.setLayoutData((Object)EntryPointSection.newGridData(0, 20));
        this.txtServletName = new Text((Composite)group, 2048);
        this.txtServletName.setLayoutData((Object)EntryPointSection.newFillHorizontalGridData());
        this.txtServletName.addModifyListener((ModifyListener)new ComboModifyListener());
        Dialog.applyDialogFont((Control)group);
        this.setControl((Control)group);
        HelpContextIds.assign(this.getControl(), "org.eclipse.ra.ui.launch.rwt.launch_configuration_dialog_main_tab");
        this.updateEnablement();
    }

    public void initializeFrom(RWTLaunchConfig launchConfig) {
        this.rbWebXml.setSelection(launchConfig.getUseWebXml());
        this.rbEntryPoint.setSelection(!launchConfig.getUseWebXml());
        this.txtWebXmlLocation.setText(launchConfig.getWebXmlLocation());
        this.txtServletName.setText(launchConfig.getServletPath());
        this.txtEntryPointClass.setText(launchConfig.getEntryPoint());
        this.updateEnablement();
    }

    public void performApply(RWTLaunchConfig launchConfig) {
        launchConfig.setUseWebXml(this.rbWebXml.getSelection());
        launchConfig.setWebXmlLocation(this.txtWebXmlLocation.getText().trim());
        launchConfig.setServletPath(this.txtServletName.getText().trim());
        launchConfig.setEntryPoint(this.txtEntryPointClass.getText().trim());
    }

    private void updateEnablement() {
        boolean enabled = this.rbWebXml.getSelection();
        this.lblWebXmlLocation.setEnabled(enabled);
        this.txtWebXmlLocation.setEnabled(enabled);
        this.btnSelectWebXml.setEnabled(enabled);
        this.lblServletName.setEnabled(enabled);
        this.txtServletName.setEnabled(enabled);
        enabled = this.rbEntryPoint.getSelection();
        this.lblEntryPointClass.setEnabled(enabled);
        this.txtEntryPointClass.setEnabled(enabled);
        this.btnSelectEntryPointClass.setEnabled(enabled);
    }

    private void selectWebXml() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int file = 1;
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)root, file);
        dialog.setTitle("Web.xml Selection");
        if (dialog.open() == 0 && dialog.getResult().length > 0) {
            IResource selection = (IResource)dialog.getResult()[0];
            this.txtWebXmlLocation.setText(selection.getFullPath().toPortableString());
        }
    }

    private void selectEntryPointClass() {
        EntryPointTypeSelectionDialog dialog = new EntryPointTypeSelectionDialog(this.getShell());
        if (dialog.open()) {
            this.txtEntryPointClass.setText(dialog.getSelection().getFullyQualifiedName());
        }
    }

    private static GridData newFillHorizontalGridData() {
        return new GridData(4, 128, true, false);
    }

    private static GridData newGridData(int horizontalSpan, int horizontalIndent) {
        GridData result = new GridData();
        result.horizontalSpan = horizontalSpan;
        result.horizontalIndent = horizontalIndent;
        return result;
    }

    private class ComboModifyListener
    implements ModifyListener {
        private ComboModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            EntryPointSection.this.updateLaunchConfigurationDialog();
        }
    }

    private final class EntryPointClassSelectionListener
    extends SelectionAdapter {
        private EntryPointClassSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            EntryPointSection.this.selectEntryPointClass();
            EntryPointSection.this.updateLaunchConfigurationDialog();
        }
    }

    private final class EntryPointSelectionListener
    extends SelectionAdapter {
        private EntryPointSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            EntryPointSection.this.updateEnablement();
            EntryPointSection.this.updateLaunchConfigurationDialog();
        }
    }

    private final class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            EntryPointSection.this.updateLaunchConfigurationDialog();
        }
    }

    private final class WebXmlSelectionListener
    extends SelectionAdapter {
        private WebXmlSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            EntryPointSection.this.selectWebXml();
            EntryPointSection.this.updateLaunchConfigurationDialog();
        }
    }
}

