/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TrimPaneLayout
extends Layout {
    private static final long serialVersionUID = 1L;
    private static int BORDER_WIDTH = 4;
    private int fixedCorner;
    public Rectangle hSizingRect;
    public Rectangle vSizingRect;
    public Rectangle cornerRect;
    private Rectangle clientRect;
    private boolean resizeInstalled = false;
    int trackState = 0;
    protected Point curPos;

    public TrimPaneLayout(MToolControl toolControl, int barSide) {
        this.fixedCorner = barSide;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(600, 400);
    }

    protected void layout(Composite composite, boolean flushCache) {
        this.installResize(composite);
        if (composite.getChildren().length != 1) {
            return;
        }
        if (this.fixedCorner == 0) {
            return;
        }
        Rectangle bounds = composite.getBounds();
        if (this.isFixed(128)) {
            if (this.isFixed(131072)) {
                this.hSizingRect = new Rectangle(0, 0, BORDER_WIDTH, bounds.height - BORDER_WIDTH);
                this.vSizingRect = new Rectangle(BORDER_WIDTH, bounds.height - BORDER_WIDTH, bounds.width - BORDER_WIDTH, BORDER_WIDTH);
                this.cornerRect = new Rectangle(0, bounds.height - BORDER_WIDTH, BORDER_WIDTH, BORDER_WIDTH);
                this.clientRect = new Rectangle(BORDER_WIDTH, 0, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH);
            } else {
                this.hSizingRect = new Rectangle(bounds.width - BORDER_WIDTH, 0, BORDER_WIDTH, bounds.height - BORDER_WIDTH);
                this.vSizingRect = new Rectangle(0, bounds.height - BORDER_WIDTH, bounds.width - BORDER_WIDTH, BORDER_WIDTH);
                this.cornerRect = new Rectangle(bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH, BORDER_WIDTH, BORDER_WIDTH);
                this.clientRect = new Rectangle(0, 0, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH);
            }
        } else if (this.isFixed(1024)) {
            if (this.isFixed(131072)) {
                this.hSizingRect = new Rectangle(0, BORDER_WIDTH, BORDER_WIDTH, bounds.height - BORDER_WIDTH);
                this.vSizingRect = new Rectangle(BORDER_WIDTH, 0, bounds.width - BORDER_WIDTH, BORDER_WIDTH);
                this.cornerRect = new Rectangle(0, 0, BORDER_WIDTH, BORDER_WIDTH);
                this.clientRect = new Rectangle(BORDER_WIDTH, BORDER_WIDTH, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH);
            } else {
                this.hSizingRect = new Rectangle(bounds.width - BORDER_WIDTH, BORDER_WIDTH, BORDER_WIDTH, bounds.height - BORDER_WIDTH);
                this.vSizingRect = new Rectangle(0, 0, bounds.width - BORDER_WIDTH, BORDER_WIDTH);
                this.cornerRect = new Rectangle(bounds.width - BORDER_WIDTH, 0, BORDER_WIDTH, BORDER_WIDTH);
                this.clientRect = new Rectangle(0, BORDER_WIDTH, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH);
            }
        }
        Control child = composite.getChildren()[0];
        child.setBounds(this.clientRect);
    }

    private void installResize(Composite composite) {
        if (this.resizeInstalled) {
            return;
        }
    }

    protected void setCursor(Composite composite, Point p) {
        if (this.hSizingRect.contains(p)) {
            composite.setCursor(composite.getDisplay().getSystemCursor(9));
        } else if (this.vSizingRect.contains(p)) {
            composite.setCursor(composite.getDisplay().getSystemCursor(7));
        } else if (this.cornerRect.contains(p)) {
            if (this.isFixed(128)) {
                if (this.isFixed(131072)) {
                    composite.setCursor(composite.getDisplay().getSystemCursor(16));
                } else {
                    composite.setCursor(composite.getDisplay().getSystemCursor(15));
                }
            } else if (this.isFixed(1024)) {
                if (this.isFixed(131072)) {
                    composite.setCursor(composite.getDisplay().getSystemCursor(15));
                } else {
                    composite.setCursor(composite.getDisplay().getSystemCursor(16));
                }
            }
        } else {
            composite.setCursor(null);
        }
    }

    protected void dragCorner(Composite composite, Point p) {
        int dx = p.x - this.curPos.x;
        int dy = p.y - this.curPos.y;
        Rectangle bounds = composite.getBounds();
        if (this.isFixed(131072)) {
            bounds.x += dx;
            bounds.width -= dx;
        } else {
            bounds.width += dx;
        }
        if (this.isFixed(1024)) {
            bounds.y += dy;
            bounds.height -= dy;
        } else {
            bounds.height += dy;
        }
        composite.setBounds(bounds);
        composite.getDisplay().update();
        this.curPos = p;
    }

    protected void dragVertical(Composite composite, Point p) {
        int dy = p.y - this.curPos.y;
        Rectangle bounds = composite.getBounds();
        if (this.isFixed(1024)) {
            bounds.y += dy;
            bounds.height -= dy;
        } else {
            bounds.height += dy;
        }
        composite.setBounds(bounds);
        composite.getDisplay().update();
        this.curPos = p;
    }

    protected void dragHorizontal(Composite composite, Point p) {
        int dx = p.x - this.curPos.x;
        Rectangle bounds = composite.getBounds();
        if (this.isFixed(131072)) {
            bounds.x += dx;
            bounds.width -= dx;
        } else {
            bounds.width += dx;
        }
        composite.setBounds(bounds);
        composite.getDisplay().update();
        this.curPos = p;
    }

    private boolean isFixed(int swtSide) {
        return (this.fixedCorner & swtSide) != 0;
    }
}

