/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IDateTimeAdapter;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeLCA;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    private static final int V_PADDING = 1;
    private static final int H_PADDING = 6;
    private static final int CALENDAR_HEADER_HEIGHT = 24;
    private static final int MIN_CELL_WIDTH = 24;
    private static final int MIN_CELL_HEIGHT = 16;
    private static final int CELL_PADDING = 2;
    private final String[] monthNames;
    private final String[] weekdayNames;
    private final String[] weekdayShortNames;
    private final String dateSeparator;
    private final String datePattern;
    private final Point cellSize;
    private transient IDateTimeAdapter dateTimeAdapter;
    private final Calendar rightNow = Calendar.getInstance();
    private Date minimum;
    private Date maximum;
    private boolean ignoreLimits;
    private Rectangle weekdayTextFieldBounds;
    private Rectangle dayTextFieldBounds;
    private Rectangle monthTextFieldBounds;
    private Rectangle yearTextFieldBounds;
    private Rectangle separator0Bounds;
    private Rectangle separator1Bounds;
    private Rectangle separator2Bounds;
    private Rectangle spinnerBounds;
    private Rectangle hoursTextFieldBounds;
    private Rectangle minutesTextFieldBounds;
    private Rectangle secondsTextFieldBounds;
    private Rectangle separator3Bounds;
    private Rectangle separator4Bounds;
    private Rectangle dropDownButtonBounds;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
        DateFormatSymbols symbols = new DateFormatSymbols(RWT.getLocale());
        this.monthNames = symbols.getMonths();
        this.weekdayNames = symbols.getWeekdays();
        this.weekdayShortNames = symbols.getShortWeekdays();
        this.dateSeparator = DateTime.getDateSeparator();
        this.datePattern = DateTime.getDatePattern(this.dateSeparator);
        this.cellSize = this.computeCellSize();
        this.computeSubWidgetsBounds();
    }

    @Override
    void initState() {
        this.removeState(256);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public int getHours() {
        this.checkWidget();
        return this.rightNow.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        return this.rightNow.get(12);
    }

    public int getSeconds() {
        this.checkWidget();
        return this.rightNow.get(13);
    }

    public int getDay() {
        this.checkWidget();
        return this.rightNow.get(5);
    }

    public int getMonth() {
        this.checkWidget();
        return this.rightNow.get(2);
    }

    public int getYear() {
        this.checkWidget();
        return this.rightNow.get(1);
    }

    public Date getMinimum() {
        this.checkWidget();
        return this.minimum == null ? null : (Date)this.minimum.clone();
    }

    public Date getMaximum() {
        this.checkWidget();
        return this.maximum == null ? null : (Date)this.maximum.clone();
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (DateTime.checkTime(hours, this.getMinutes(), this.getSeconds())) {
            this.rightNow.set(11, hours);
            this.applyLimits();
        }
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (DateTime.checkTime(this.getHours(), minutes, this.getSeconds())) {
            this.rightNow.set(12, minutes);
            this.applyLimits();
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (DateTime.checkTime(this.getHours(), this.getMinutes(), seconds)) {
            this.rightNow.set(13, seconds);
            this.applyLimits();
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        int month = this.rightNow.get(2);
        int year = this.rightNow.get(1);
        if (DateTime.checkDate(year, month, day)) {
            this.rightNow.set(5, day);
            this.applyLimits();
        }
    }

    public void setMonth(int month) {
        this.checkWidget();
        int day = this.rightNow.get(5);
        int year = this.rightNow.get(1);
        if (DateTime.checkDate(year, month, day)) {
            this.rightNow.set(2, month);
            this.applyLimits();
        }
    }

    public void setYear(int year) {
        this.checkWidget();
        int day = this.rightNow.get(5);
        int month = this.rightNow.get(2);
        if (DateTime.checkDate(year, month, day)) {
            this.rightNow.set(1, year);
            this.applyLimits();
        }
    }

    public void setMinimum(Date date) {
        this.checkWidget();
        if (date == null) {
            this.minimum = null;
            this.applyLimits();
        } else if (this.maximum == null || date.getTime() < this.maximum.getTime()) {
            this.minimum = (Date)date.clone();
            this.applyLimits();
        }
    }

    public void setMaximum(Date date) {
        this.checkWidget();
        if (date == null) {
            this.maximum = null;
            this.applyLimits();
        } else if (this.minimum == null || date.getTime() > this.minimum.getTime()) {
            this.maximum = (Date)date.clone();
            this.applyLimits();
        }
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (DateTime.checkDate(year, month, day)) {
            this.ignoreLimits = true;
            this.setYear(9996);
            this.setMonth(0);
            this.setDay(1);
            this.setYear(year);
            this.setMonth(month);
            this.setDay(day);
            this.ignoreLimits = false;
            this.applyLimits();
        }
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (DateTime.checkTime(hours, minutes, seconds)) {
            this.setHours(hours);
            this.setMinutes(minutes);
            this.setSeconds(seconds);
        }
    }

    @Override
    public void setFont(Font font) {
        if (font != this.getFont()) {
            super.setFont(font);
        }
        this.computeSubWidgetsBounds();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IDateTimeAdapter.class) {
            if (this.dateTimeAdapter == null) {
                this.dateTimeAdapter = new DateTimeAdapter();
            }
            return (T)this.dateTimeAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)DateTimeLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            Point size = this.computeSubWidgetsBounds();
            width = size.x;
            height = size.y;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.computeSubWidgetsBounds();
    }

    private Point computeCellSize() {
        int width = 24;
        int height = 16;
        int i = 0;
        while (i < this.weekdayShortNames.length) {
            Point nameSize = TextSizeUtil.stringExtent(this.getFont(), this.weekdayShortNames[i]);
            width = Math.max(width, nameSize.x + 2);
            height = Math.max(height, nameSize.y + 2);
            ++i;
        }
        return new Point(width, height);
    }

    private Point computeSubWidgetsBounds() {
        Font font = this.getFont();
        int width = 0;
        int height = 0;
        BoxDimensions padding = this.getFieldPadding();
        BoxDimensions border = this.getBorder();
        if ((this.style & 0x400) != 0) {
            width = this.cellSize.x * 8 + border.left + border.right;
            height = this.cellSize.y * 7 + 24 + border.top + border.bottom;
        } else if ((this.style & 0x20) != 0) {
            Point prefSize = new Point(0, 0);
            prefSize = this.datePattern.equals("MDY") ? this.computeMDYBounds() : (this.datePattern.equals("DMY") ? this.computeDMYBounds() : ((this.style & 0x10000) != 0 ? this.computeYMDBounds() : this.computeMDYBounds()));
            width = prefSize.x + border.left + border.right;
            height = prefSize.y + border.top + border.bottom;
        } else if ((this.style & 0x80) != 0) {
            this.hoursTextFieldBounds = new Rectangle(padding.left, padding.top, 0, 0);
            this.hoursTextFieldBounds.width = TextSizeUtil.stringExtent((Font)font, (String)"88").x + 6;
            this.hoursTextFieldBounds.height = TextSizeUtil.stringExtent((Font)font, (String)"88").y + 1;
            this.separator3Bounds = new Rectangle(0, padding.top, 0, 0);
            this.separator3Bounds.x = this.hoursTextFieldBounds.x + this.hoursTextFieldBounds.width;
            this.separator3Bounds.width = TextSizeUtil.stringExtent((Font)font, (String)":").x;
            this.separator3Bounds.height = this.hoursTextFieldBounds.height;
            this.minutesTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
            this.minutesTextFieldBounds.x = this.separator3Bounds.x + this.separator3Bounds.width;
            this.minutesTextFieldBounds.width = this.hoursTextFieldBounds.width;
            this.minutesTextFieldBounds.height = this.hoursTextFieldBounds.height;
            this.separator4Bounds = new Rectangle(0, padding.top, 0, 0);
            this.separator4Bounds.x = this.minutesTextFieldBounds.x + this.minutesTextFieldBounds.width;
            this.separator4Bounds.width = this.separator3Bounds.width;
            this.separator4Bounds.height = this.hoursTextFieldBounds.height;
            this.secondsTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
            this.secondsTextFieldBounds.x = this.separator4Bounds.x + this.separator4Bounds.width;
            this.secondsTextFieldBounds.width = this.hoursTextFieldBounds.width;
            this.secondsTextFieldBounds.height = this.hoursTextFieldBounds.height;
            this.spinnerBounds = new Rectangle(0, 0, 0, 0);
            this.spinnerBounds.x = this.minutesTextFieldBounds.x + this.minutesTextFieldBounds.width + padding.left;
            if ((this.style & 0x10000) != 0 || (this.style & 0x10000000) != 0) {
                this.spinnerBounds.x = this.secondsTextFieldBounds.x + this.secondsTextFieldBounds.width + padding.left;
            }
            this.spinnerBounds.width = this.getSpinnerButtonWidth();
            this.spinnerBounds.height = this.hoursTextFieldBounds.height + padding.top + padding.bottom;
            width = this.spinnerBounds.x + this.spinnerBounds.width + border.left + border.right;
            height = this.spinnerBounds.height + border.top + border.bottom;
        }
        this.adjustButtonsBounds();
        return new Point(width, height);
    }

    private Point computeMDYBounds() {
        Font font = this.getFont();
        BoxDimensions padding = this.getFieldPadding();
        this.weekdayTextFieldBounds = new Rectangle(padding.left, padding.top, 0, 0);
        if ((this.style & 0x10000000) != 0) {
            this.weekdayTextFieldBounds.width = this.getMaxWidth(this.weekdayNames) + 6 + 2;
        }
        this.weekdayTextFieldBounds.height = TextSizeUtil.stringExtent((Font)font, (String)this.weekdayNames[1]).y + 1;
        this.separator0Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator0Bounds.x = this.weekdayTextFieldBounds.x + this.weekdayTextFieldBounds.width;
        if ((this.style & 0x10000000) != 0) {
            this.separator0Bounds.width = TextSizeUtil.stringExtent((Font)font, (String)",").x;
        }
        this.separator0Bounds.height = this.weekdayTextFieldBounds.height;
        this.monthTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.monthTextFieldBounds.x = this.separator0Bounds.x + this.separator0Bounds.width;
        this.monthTextFieldBounds.width = (this.style & 0x10000) != 0 ? TextSizeUtil.stringExtent((Font)font, (String)"88").x + 6 : this.getMaxWidth(this.monthNames) + 6 + 2;
        this.monthTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator1Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator1Bounds.x = this.monthTextFieldBounds.x + this.monthTextFieldBounds.width;
        if ((this.style & 0x10000) != 0) {
            this.separator1Bounds.width = TextSizeUtil.stringExtent((Font)font, (String)this.dateSeparator).x;
        }
        this.separator1Bounds.height = this.weekdayTextFieldBounds.height;
        this.dayTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.dayTextFieldBounds.x = this.separator1Bounds.x + this.separator1Bounds.width;
        if ((this.style & 0x8000) == 0) {
            this.dayTextFieldBounds.width = TextSizeUtil.stringExtent((Font)font, (String)"88").x + 6;
        }
        this.dayTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator2Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator2Bounds.x = this.dayTextFieldBounds.x + this.dayTextFieldBounds.width;
        this.separator2Bounds.width = (this.style & 0x10000) != 0 ? TextSizeUtil.stringExtent((Font)font, (String)this.dateSeparator).x : TextSizeUtil.stringExtent((Font)font, (String)",").x;
        this.separator2Bounds.height = this.weekdayTextFieldBounds.height;
        this.yearTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.yearTextFieldBounds.x = this.separator2Bounds.x + this.separator2Bounds.width;
        this.yearTextFieldBounds.width = TextSizeUtil.stringExtent((Font)font, (String)"8888").x + 6;
        this.yearTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.spinnerBounds = new Rectangle(0, 0, 0, 0);
        this.spinnerBounds.x = this.yearTextFieldBounds.x + this.yearTextFieldBounds.width + padding.left;
        this.spinnerBounds.width = this.getSpinnerButtonWidth();
        this.spinnerBounds.height = this.weekdayTextFieldBounds.height + padding.top + padding.bottom;
        this.dropDownButtonBounds = new Rectangle(this.spinnerBounds.x, this.spinnerBounds.y, this.getDropDownButtonWidth(), this.spinnerBounds.height);
        int width = this.spinnerBounds.x;
        int height = this.spinnerBounds.height;
        width = (this.style & 4) == 0 ? (width += this.spinnerBounds.width) : (width += this.dropDownButtonBounds.width);
        return new Point(width, height);
    }

    private Point computeDMYBounds() {
        Font font = this.getFont();
        BoxDimensions padding = this.getFieldPadding();
        this.weekdayTextFieldBounds = new Rectangle(padding.left, padding.top, 0, 0);
        if ((this.style & 0x10000000) != 0) {
            this.weekdayTextFieldBounds.width = this.getMaxWidth(this.weekdayNames) + 6 + 2;
        }
        this.weekdayTextFieldBounds.height = TextSizeUtil.stringExtent((Font)font, (String)this.weekdayNames[1]).y + 1;
        this.separator0Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator0Bounds.x = this.weekdayTextFieldBounds.x + this.weekdayTextFieldBounds.width;
        if ((this.style & 0x10000000) != 0) {
            this.separator0Bounds.width = TextSizeUtil.stringExtent((Font)font, (String)",").x;
        }
        this.separator0Bounds.height = this.weekdayTextFieldBounds.height;
        this.dayTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.dayTextFieldBounds.x = this.separator0Bounds.x + this.separator0Bounds.width;
        if ((this.style & 0x8000) == 0) {
            this.dayTextFieldBounds.width = TextSizeUtil.stringExtent((Font)font, (String)"88").x + 6;
        }
        this.dayTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator1Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator1Bounds.x = this.dayTextFieldBounds.x + this.dayTextFieldBounds.width;
        if ((this.style & 0x10000) != 0) {
            this.separator1Bounds.width = TextSizeUtil.stringExtent((Font)font, (String)this.dateSeparator).x;
        }
        this.separator1Bounds.height = this.weekdayTextFieldBounds.height;
        this.monthTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.monthTextFieldBounds.x = this.separator1Bounds.x + this.separator1Bounds.width;
        this.monthTextFieldBounds.width = (this.style & 0x10000) != 0 ? TextSizeUtil.stringExtent((Font)font, (String)"88").x + 6 : this.getMaxWidth(this.monthNames) + 6 + 2;
        this.monthTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator2Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator2Bounds.x = this.monthTextFieldBounds.x + this.monthTextFieldBounds.width;
        this.separator2Bounds.width = (this.style & 0x10000) != 0 ? TextSizeUtil.stringExtent((Font)font, (String)this.dateSeparator).x : TextSizeUtil.stringExtent((Font)font, (String)",").x;
        this.separator2Bounds.height = this.weekdayTextFieldBounds.height;
        this.yearTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.yearTextFieldBounds.x = this.separator2Bounds.x + this.separator2Bounds.width;
        this.yearTextFieldBounds.width = TextSizeUtil.stringExtent((Font)font, (String)"8888").x + 6;
        this.yearTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.spinnerBounds = new Rectangle(0, 0, 0, 0);
        this.spinnerBounds.x = this.yearTextFieldBounds.x + this.yearTextFieldBounds.width + padding.left;
        this.spinnerBounds.width = this.getSpinnerButtonWidth();
        this.spinnerBounds.height = this.weekdayTextFieldBounds.height + padding.top + padding.bottom;
        this.dropDownButtonBounds = new Rectangle(this.spinnerBounds.x, this.spinnerBounds.y, this.getDropDownButtonWidth(), this.spinnerBounds.height);
        int width = this.spinnerBounds.x;
        int height = this.spinnerBounds.height;
        width = (this.style & 4) == 0 ? (width += this.spinnerBounds.width) : (width += this.dropDownButtonBounds.width);
        return new Point(width, height);
    }

    private Point computeYMDBounds() {
        Font font = this.getFont();
        BoxDimensions padding = this.getFieldPadding();
        this.weekdayTextFieldBounds = new Rectangle(padding.left, padding.top, 0, 0);
        if ((this.style & 0x10000000) != 0) {
            this.weekdayTextFieldBounds.width = this.getMaxWidth(this.weekdayNames) + 6 + 2;
        }
        this.weekdayTextFieldBounds.height = TextSizeUtil.stringExtent((Font)font, (String)this.weekdayNames[1]).y + 1;
        this.separator0Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator0Bounds.x = this.weekdayTextFieldBounds.x + this.weekdayTextFieldBounds.width;
        if ((this.style & 0x10000000) != 0) {
            this.separator0Bounds.width = TextSizeUtil.stringExtent((Font)font, (String)",").x;
        }
        this.separator0Bounds.height = this.weekdayTextFieldBounds.height;
        this.yearTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.yearTextFieldBounds.x = this.separator0Bounds.x + this.separator0Bounds.width;
        this.yearTextFieldBounds.width = TextSizeUtil.stringExtent((Font)font, (String)"8888").x + 6;
        this.yearTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator1Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator1Bounds.x = this.yearTextFieldBounds.x + this.yearTextFieldBounds.width;
        if ((this.style & 0x10000) != 0) {
            this.separator1Bounds.width = TextSizeUtil.stringExtent((Font)font, (String)this.dateSeparator).x;
        }
        this.monthTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.monthTextFieldBounds.x = this.separator1Bounds.x + this.separator1Bounds.width;
        this.monthTextFieldBounds.width = (this.style & 0x10000) != 0 ? TextSizeUtil.stringExtent((Font)font, (String)"88").x + 6 : this.getMaxWidth(this.monthNames) + 6 + 2;
        this.monthTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator2Bounds = new Rectangle(0, padding.top, 0, 0);
        this.separator2Bounds.x = this.monthTextFieldBounds.x + this.monthTextFieldBounds.width;
        this.separator2Bounds.width = (this.style & 0x10000) != 0 ? TextSizeUtil.stringExtent((Font)font, (String)this.dateSeparator).x : TextSizeUtil.stringExtent((Font)font, (String)",").x;
        this.separator2Bounds.height = this.weekdayTextFieldBounds.height;
        this.dayTextFieldBounds = new Rectangle(0, padding.top, 0, 0);
        this.dayTextFieldBounds.x = this.separator2Bounds.x + this.separator2Bounds.width;
        if ((this.style & 0x8000) == 0) {
            this.dayTextFieldBounds.width = TextSizeUtil.stringExtent((Font)font, (String)"88").x + 6;
        }
        this.dayTextFieldBounds.height = this.weekdayTextFieldBounds.height;
        this.separator1Bounds.height = this.weekdayTextFieldBounds.height;
        this.spinnerBounds = new Rectangle(0, 0, 0, 0);
        this.spinnerBounds.x = this.dayTextFieldBounds.x + this.dayTextFieldBounds.width + padding.left;
        this.spinnerBounds.width = this.getSpinnerButtonWidth();
        this.spinnerBounds.height = this.weekdayTextFieldBounds.height + padding.top + padding.bottom;
        this.dropDownButtonBounds = new Rectangle(this.spinnerBounds.x, this.spinnerBounds.y, this.getDropDownButtonWidth(), this.spinnerBounds.height);
        int width = this.spinnerBounds.x;
        int height = this.spinnerBounds.height;
        width = (this.style & 4) == 0 ? (width += this.spinnerBounds.width) : (width += this.dropDownButtonBounds.width);
        return new Point(width, height);
    }

    private void adjustButtonsBounds() {
        Point size = this.getSize();
        BoxDimensions border = this.getBorder();
        if ((this.style & 4) != 0) {
            this.dropDownButtonBounds.x = size.x - (border.left + border.right) - this.dropDownButtonBounds.width;
            this.dropDownButtonBounds.height = size.y - (border.top + border.bottom);
        } else if ((this.style & 0x20) != 0 || (this.style & 0x80) != 0) {
            this.spinnerBounds.x = size.x - (border.left + border.right) - this.spinnerBounds.width;
            this.spinnerBounds.height = size.y - (border.top + border.bottom);
        }
    }

    private int getSpinnerButtonWidth() {
        return this.getDateTimeThemeAdapter().getSpinnerButtonWidth(this);
    }

    private DateTimeThemeAdapter getDateTimeThemeAdapter() {
        return (DateTimeThemeAdapter)this.getAdapter(ThemeAdapter.class);
    }

    private int getDropDownButtonWidth() {
        return this.getDateTimeThemeAdapter().getDropDownButtonWidth(this);
    }

    private BoxDimensions getFieldPadding() {
        return this.getDateTimeThemeAdapter().getFieldPadding(this);
    }

    @Override
    String getNameText() {
        return "DateTime";
    }

    private static int getDaysInMonth(int month, int year) {
        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
        return cal.getActualMaximum(5);
    }

    private int getMaxWidth(String[] strings) {
        Font font = this.getFont();
        int result = 0;
        int i = 0;
        while (i < strings.length) {
            int width = TextSizeUtil.stringExtent((Font)font, (String)strings[i]).x;
            result = Math.max(result, width);
            ++i;
        }
        return result;
    }

    private static String getDateSeparator() {
        DateFormat dateFormat = DateFormat.getDateInstance(3, RWT.getLocale());
        String datePattern = ((SimpleDateFormat)dateFormat).toPattern();
        String result = "";
        int index = 0;
        while (Character.isLetter(datePattern.charAt(index))) {
            ++index;
        }
        result = Character.toString(datePattern.charAt(index));
        return result;
    }

    private static String getDatePattern(String dateSeparator) {
        DateFormat format = DateFormat.getDateInstance(3, RWT.getLocale());
        String datePattern = ((SimpleDateFormat)format).toPattern();
        Object result = "";
        StringTokenizer tokenizer = new StringTokenizer(datePattern, dateSeparator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result = (String)result + Character.toString(token.charAt(0));
        }
        return ((String)result).toUpperCase();
    }

    private static boolean checkDate(int year, int month, int day) {
        boolean validDay;
        int daysInMonth = DateTime.getDaysInMonth(month, year);
        boolean validYear = year >= 1752 && year <= 9999 && day <= daysInMonth;
        boolean validMonth = month >= 0 && month <= 11 && day <= daysInMonth;
        boolean bl = validDay = day >= 1 && day <= daysInMonth;
        return validYear && validMonth && validDay;
    }

    private static boolean checkTime(int hours, int minutes, int seconds) {
        boolean validSeconds;
        boolean validHours = hours >= 0 && hours <= 23;
        boolean validMinutes = minutes >= 0 && minutes <= 59;
        boolean bl = validSeconds = seconds >= 0 && seconds <= 59;
        return validHours && validMinutes && validSeconds;
    }

    static int checkStyle(int value) {
        int style = value;
        style &= 0xFFFFFCFF;
        style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
        if (((style = DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0)) & 0x20) == 0) {
            style &= 0xFFFFFFFB;
        }
        return style;
    }

    private void applyLimits() {
        if (!this.ignoreLimits) {
            if (this.maximum != null && this.rightNow.getTimeInMillis() > this.maximum.getTime()) {
                this.rightNow.setTime(this.maximum);
            }
            if (this.minimum != null && this.rightNow.getTimeInMillis() < this.minimum.getTime()) {
                this.rightNow.setTime(this.minimum);
            }
        }
    }

    private final class DateTimeAdapter
    implements IDateTimeAdapter {
        private DateTimeAdapter() {
        }

        @Override
        public Rectangle getBounds(int widget) {
            Rectangle result = new Rectangle(0, 0, 0, 0);
            switch (widget) {
                case 0: {
                    result = DateTime.this.weekdayTextFieldBounds;
                    break;
                }
                case 1: {
                    result = DateTime.this.dayTextFieldBounds;
                    break;
                }
                case 2: {
                    result = DateTime.this.monthTextFieldBounds;
                    break;
                }
                case 3: {
                    result = DateTime.this.yearTextFieldBounds;
                    break;
                }
                case 4: {
                    result = DateTime.this.separator0Bounds;
                    break;
                }
                case 5: {
                    result = DateTime.this.separator1Bounds;
                    break;
                }
                case 6: {
                    result = DateTime.this.separator2Bounds;
                    break;
                }
                case 7: {
                    result = DateTime.this.spinnerBounds;
                    break;
                }
                case 8: {
                    result = DateTime.this.hoursTextFieldBounds;
                    break;
                }
                case 9: {
                    result = DateTime.this.minutesTextFieldBounds;
                    break;
                }
                case 10: {
                    result = DateTime.this.secondsTextFieldBounds;
                    break;
                }
                case 11: {
                    result = DateTime.this.separator3Bounds;
                    break;
                }
                case 12: {
                    result = DateTime.this.separator4Bounds;
                    break;
                }
                case 13: {
                    result = DateTime.this.dropDownButtonBounds;
                }
            }
            return result;
        }

        @Override
        public Point getCellSize() {
            return new Point(DateTime.this.cellSize.x, DateTime.this.cellSize.y);
        }

        @Override
        public String[] getMonthNames() {
            return DateTime.this.monthNames;
        }

        @Override
        public String[] getWeekdayNames() {
            return DateTime.this.weekdayNames;
        }

        @Override
        public String[] getWeekdayShortNames() {
            return DateTime.this.weekdayShortNames;
        }

        @Override
        public String getDateSeparator() {
            return DateTime.this.dateSeparator;
        }

        @Override
        public String getDatePattern() {
            return DateTime.this.datePattern;
        }
    }
}

