/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.javatest;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.TreeQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;

public class TSTestsInterview
extends Interview
implements Parameters.MutableTestsParameters {
    private YesNoQuestion qNeedTests = new YesNoQuestion(this, "needTests"){
        {
            this.setValue("No");
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return TSTestsInterview.this.qTests;
            }
            return TSTestsInterview.this.qEnd;
        }
    };
    private TreeQuestion.Model model = new TreeQuestion.Model(){

        public Object getRoot() {
            return TSTestsInterview.this.parent.getWorkDirectory().getTestResultTable().getRoot();
        }

        public int getChildCount(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getChildCount();
            }
            if (node instanceof TestResult) {
                return 0;
            }
            throw new IllegalArgumentException();
        }

        public Object getChild(Object node, int index) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getChild(index);
            }
            if (node instanceof TestResult) {
                return null;
            }
            throw new IllegalArgumentException();
        }

        public String getName(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)node).getName();
            }
            if (node instanceof TestResult) {
                TestResult tr = (TestResult)node;
                String fullName = tr.getTestName();
                int lastSlash = fullName.lastIndexOf("/");
                return lastSlash == -1 ? fullName : fullName.substring(lastSlash + 1);
            }
            throw new IllegalArgumentException();
        }

        public String getPath(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResult) {
                return ((TestResult)node).getTestName();
            }
            if (node instanceof TestResultTable.TreeNode) {
                TestResultTable.TreeNode tn = (TestResultTable.TreeNode)node;
                if (tn.isRoot()) {
                    return tn.getName();
                }
                return this.getPath(String.valueOf(tn.getParent()) + "/" + tn.getName());
            }
            throw new IllegalArgumentException();
        }

        public boolean isLeaf(Object node) {
            if (node == null) {
                throw new NullPointerException();
            }
            if (node instanceof TestResult) {
                return true;
            }
            if (node instanceof TestResultTable.TreeNode) {
                return false;
            }
            throw new IllegalArgumentException();
        }
    };
    private TreeQuestion qTests = new TreeQuestion(this, "tests", this.model){

        protected Question getNext() {
            TSTestsInterview.this.validateTests();
            if (TSTestsInterview.this.cachedTestsError != null) {
                return TSTestsInterview.this.cachedTestsError;
            }
            return TSTestsInterview.this.qEnd;
        }
    };
    private Question qNoTestsError = new ErrorQuestion((Interview)this, "noTests");
    private ErrorQuestion qBadTestsError = new ErrorQuestion(this, "badTests"){

        protected Object[] getTextArgs() {
            return TSTestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private String[] cachedTestsValue;
    private Question cachedTestsError;
    private Object[] cachedTestsErrorArgs;
    private Question qEnd = new FinalQuestion((Interview)this);
    private InterviewParameters parent;

    public TSTestsInterview(InterviewParameters parent) throws Interview.Fault {
        super((Interview)parent, "tests");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setFirstQuestion((Question)this.qNeedTests);
    }

    public String[] getTests() {
        if (this.qNeedTests.getValue() == "Yes") {
            return this.qTests.getValue();
        }
        return null;
    }

    public void setTests(String[] tests) {
        if (tests == null) {
            this.setTestsMode(1);
        } else {
            this.setTestsMode(2);
            this.setSpecifiedTests(tests);
        }
    }

    public int getTestsMode() {
        return this.qNeedTests.getValue() == "Yes" ? 2 : 1;
    }

    public void setTestsMode(int mode) {
        switch (mode) {
            case 1: {
                this.qNeedTests.setValue("No");
                break;
            }
            case 2: {
                this.qNeedTests.setValue("Yes");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String[] getSpecifiedTests() {
        return this.qTests.getValue();
    }

    public void setSpecifiedTests(String[] tests) {
        this.qTests.setValue(tests);
    }

    private void validateTests() {
        String[] tests = this.qTests.getValue();
        if (TSTestsInterview.equal(tests, this.cachedTestsValue)) {
            return;
        }
        this.cachedTestsValue = tests;
        this.cachedTestsError = null;
        WorkDirectory wd = this.parent.getWorkDirectory();
        if (wd == null) {
            return;
        }
        TestResultTable trt = wd.getTestResultTable();
        if (tests == null || tests.length == 0) {
            return;
        }
        for (int i = 0; i < tests.length; ++i) {
            if (trt.validatePath(tests[i])) continue;
            this.cachedTestsError = this.qBadTestsError;
            this.cachedTestsErrorArgs = new Object[]{tests[i]};
            return;
        }
    }

    private static boolean equal(String[] s1, String[] s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] == s2[i]) continue;
            return false;
        }
        return true;
    }
}

