/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.tex.core.ast.ContainerNode;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.Dummy;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstVisitor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public abstract class Environment
extends ContainerNode {
    final ControlNode beginNode;
    TexAstNode endNode;

    Environment(TexAstNode parent, ControlNode beginNode) {
        super(parent);
        this.beginNode = beginNode;
        this.doSetStartOffset(beginNode.getStartOffset());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ENVIRONMENT;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        return this.children.length + 2;
    }

    @Override
    public TexAstNode getChild(int index) {
        if (index == 0) {
            return this.beginNode;
        }
        if (index <= this.children.length) {
            return this.children[index - 1];
        }
        if (index == this.children.length + 1) {
            return this.endNode;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getChildIndex(AstNode child) {
        if (this.beginNode == child) {
            return 0;
        }
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == child) {
                return i + 1;
            }
            ++i;
        }
        if (this.endNode == child) {
            return this.children.length + 1;
        }
        return -1;
    }

    public ControlNode getBeginNode() {
        return this.beginNode;
    }

    public TexAstNode getEndNode() {
        return this.endNode;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.beginNode);
        TexAstNode[] texAstNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            TexAstNode child = texAstNodeArray[n2];
            visitor.visit((AstNode)child);
            ++n2;
        }
        visitor.visit((AstNode)this.endNode);
    }

    @Override
    public void acceptInTex(TexAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInTexChildren(TexAstVisitor visitor) throws InvocationTargetException {
        this.beginNode.acceptInTex(visitor);
        TexAstNode[] texAstNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            TexAstNode child = texAstNodeArray[n2];
            child.acceptInTex(visitor);
            ++n2;
        }
        this.endNode.acceptInTex(visitor);
    }

    @Override
    void setEndNode(int endOffset, TexAstNode endNode) {
        this.endNode = endNode;
        this.doSetEndOffset(endNode.getEndOffset());
    }

    static final class MathLatexShorthand
    extends Environment {
        MathLatexShorthand(TexAstNode parent, ControlNode beginNode) {
            super(parent, beginNode);
        }

        public String getText() {
            return this.beginNode.getText();
        }

        @Override
        void setMissingEnd() {
            this.doSetStatusCode(4195634);
            this.endNode = new Dummy(this, this.getChild(this.children.length).getEndOffset());
            this.doSetEndOffset(this.endNode.getEndOffset());
        }
    }

    static final class Word
    extends Environment {
        Word(TexAstNode parent, ControlNode beginNode) {
            super(parent, beginNode);
        }

        public @Nullable String getText() {
            if (this.beginNode.hasChildren()) {
                return this.beginNode.getChild(0).getChild(0).getText();
            }
            return null;
        }

        @Override
        void setMissingEnd() {
            this.doSetStatusCode(4195602);
            this.endNode = new Dummy(this, this.getChild(this.children.length).getEndOffset());
            this.doSetEndOffset(this.endNode.getEndOffset());
        }
    }
}

